/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class BiNGOAnnotationDefaultReader {
    private final String YEAST = "Saccharomyces cerevisiae";
    private final String ARABIDOPSIS = "Arabidopsis thaliana";
    private final String ORYZA_NIVARA = "Oryza nivara";
    private final String POMBE = "Schizosaccharomyces pombe";
    private final String TRYPANOSOMA = "Trypanosoma brucei";
    private final String C_ELEGANS = "Caenorhabditis elegans";
    private final String DROSOPHILA = "Drosophila melanogaster";
    private final String ZEBRA = "Brachydanio rerio";
    private final String HUMAN = "Homo Sapiens";
    private final String MOUSE = "Mus musculus";
    private final String RAT = "Rattus norvegicus";
    private final String PLASMODIUM = "Plasmodium falsiparum";
    private final String ORYZA_SATIVA = "Oryza sativa";
    private final String ANTHRAX = "Bacillus anthracis";
    private final String SHEWANELLA = "Shewanella oneidensis";
    private final String PSEUDOMONAS_SYRINGAE = "Pseudomonas syringae";
    private final String COXIELLA_BURNETII = "Coxiella burnetii";
    private final String GEOBACTER_SULFURREDUCENS = "Geobacter sulfurreducens";
    private final String METHYLOCOCCUS_CAPSULATUS = "Methylococcus capsulatus";
    private final String LISTERIA_MONOCYTOGENES = "Listeria monocytogenes";
    private final String NR_YEAST = "4932";
    private final String NR_ARABIDOPSIS = "3702";
    private final String NR_ORYZA_NIVARA = "4536";
    private final String NR_POMBE = "4896";
    private final String NR_TRYPANOSOMA = "5691";
    private final String NR_C_ELEGANS = "6239";
    private final String NR_DROSOPHILA = "7227";
    private final String NR_ZEBRA = "7955";
    private final String NR_HUMAN = "9606";
    private final String NR_MOUSE = "10090";
    private final String NR_RAT = "10116";
    private final String NR_PLASMODIUM = "36329";
    private final String NR_ORYZA_SATIVA = "39947";
    private final String NR_ANTHRAX = "198094";
    private final String NR_SHEWANELLA = "211586";
    private final String NR_PSEUDOMONAS_SYRINGAE = "223283";
    private final String NR_COXIELLA_BURNETII = "227377";
    private final String NR_GEOBACTER_SULFURREDUCENS = "243231";
    private final String NR_METHYLOCOCCUS_CAPSULATUS = "243233";
    private final String NR_LISTERIA_MONOCYTOGENES = "265669";
    private static String GENEIDSTRING = "Entrez GeneID";
    private static String SYMBOLSTRING = "Gene Symbol";
    private static String UNIGENESTRING = "Unigene";
    private static String LOCUSTAGSTRING = "LocusTag";
    Annotation annotation;
    String annotationType;
    String species;
    String curator;
    String speciesNumber;
    String filename;
    File directoryAbsolute;
    String fullText;
    String[] lines;
    HashMap synonymHash;
    Component settingsPanel;
    String idString;
    HashMap speciesNr;
    int type;
    private boolean orphansFound = false;
    private boolean consistency = false;

    public BiNGOAnnotationDefaultReader(File file, HashMap synonymHash, Component settingsPanel, String idString, String species, String annotationType, String curator) throws IllegalArgumentException, IOException, Exception {
        this(file.getPath(), synonymHash, settingsPanel, idString, species, annotationType, curator);
    }

    public BiNGOAnnotationDefaultReader(String filename, HashMap synonymHash, Component settingsPanel, String idString, String species, String annotationType, String curator) throws IllegalArgumentException, IOException, Exception {
        this.idString = idString;
        this.filename = filename;
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (IOException e0) {
            System.err.println("-- Exception while reading annotation flat file " + filename);
            System.err.println(e0.getMessage());
            throw e0;
        }
        this.speciesNr = new HashMap();
        this.speciesNr.put("Saccharomyces cerevisiae", "4932");
        this.speciesNr.put("Arabidopsis thaliana", "3702");
        this.speciesNr.put("Oryza nivara", "4536");
        this.speciesNr.put("Schizosaccharomyces pombe", "4896");
        this.speciesNr.put("Trypanosoma brucei", "5691");
        this.speciesNr.put("Caenorhabditis elegans", "6239");
        this.speciesNr.put("Drosophila melanogaster", "7227");
        this.speciesNr.put("Brachydanio rerio", "7955");
        this.speciesNr.put("Homo Sapiens", "9606");
        this.speciesNr.put("Mus musculus", "10090");
        this.speciesNr.put("Rattus norvegicus", "10116");
        this.speciesNr.put("Plasmodium falsiparum", "36329");
        this.speciesNr.put("Oryza sativa", "39947");
        this.speciesNr.put("Bacillus anthracis", "198094");
        this.speciesNr.put("Shewanella oneidensis", "211586");
        this.speciesNr.put("Pseudomonas syringae", "223283");
        this.speciesNr.put("Coxiella burnetii", "227377");
        this.speciesNr.put("Geobacter sulfurreducens", "243231");
        this.speciesNr.put("Methylococcus capsulatus", "243233");
        this.speciesNr.put("Listeria monocytogenes", "265669");
        this.species = species;
        this.speciesNumber = this.speciesNr.get(species).toString();
        this.annotationType = annotationType;
        this.curator = curator;
        this.synonymHash = synonymHash;
        this.settingsPanel = settingsPanel;
        if (idString.equals(GENEIDSTRING)) {
            this.type = 1;
        } else if (idString.equals(SYMBOLSTRING)) {
            this.type = 2;
        } else if (idString.equals(UNIGENESTRING)) {
            this.type = 3;
        } else if (idString.equals(LOCUSTAGSTRING)) {
            this.type = 4;
        }
        this.lines = this.fullText.split("\n");
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void parse() throws Exception {
        this.annotation = new Annotation(this.species, this.annotationType, this.curator);
        HashSet<Integer> orphans = new HashSet<Integer>();
        for (int i = 1; i < this.lines.length; ++i) {
            String[] tokens;
            String spec;
            String line = this.lines[i];
            if (line.length() < 2 || !(spec = (tokens = line.split("\t"))[0].trim()).equals(this.speciesNumber)) continue;
            String entityName = tokens[this.type].trim().toUpperCase();
            int id = this.stringToInt(tokens[5].trim());
            Integer id2 = new Integer(id);
            Integer mainId = (Integer)this.synonymHash.get(id2);
            if (mainId != null) {
                if (entityName != null && entityName.length() != 0 && id != -1) {
                    this.annotation.add(entityName, mainId);
                }
                this.consistency = true;
                continue;
            }
            orphans.add(id2);
            this.orphansFound = true;
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean getOrphans() {
        return this.orphansFound;
    }

    public boolean getConsistency() {
        return this.consistency;
    }
}

