/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class BiNGOAnnotationFlatFileReader {
    private Annotation annotation;
    private String annotationType;
    private String species;
    private String curator;
    private String filename;
    private File directoryAbsolute;
    private String fullText;
    private String[] lines;
    private HashMap synonymHash;
    private Component settingsPanel;
    private boolean orphansFound = false;
    private boolean consistency = false;

    public BiNGOAnnotationFlatFileReader(File file, HashMap synonymHash, Component settingsPanel) throws IllegalArgumentException, IOException, Exception {
        this(file.getPath(), synonymHash, settingsPanel);
    }

    public BiNGOAnnotationFlatFileReader(String filename, HashMap synonymHash, Component settingsPanel) throws IllegalArgumentException, IOException, Exception {
        this.filename = filename;
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (IOException e0) {
            System.err.println("-- Exception while reading ontology flat file " + filename);
            System.err.println(e0.getMessage());
            throw e0;
        }
        this.synonymHash = synonymHash;
        this.settingsPanel = settingsPanel;
        this.lines = this.fullText.split("\n");
        this.parseHeader(this.lines[0]);
        this.parse();
    }

    private int stringToInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void parseHeader(String firstLine) throws Exception {
        String[] tokens = firstLine.trim().split("\\)");
        String errorMsg = "error in AnnotationFlatFileReader.parseHeader ().\n";
        errorMsg = errorMsg + "First line of " + this.filename + " must have form:\n";
        errorMsg = errorMsg + "   (species=Homo sapiens) (type=Biological Process) (curator=GO)\n";
        errorMsg = errorMsg + "instead found:\n";
        errorMsg = errorMsg + "   " + firstLine + "\n";
        if (tokens.length != 3) {
            throw new IllegalArgumentException(errorMsg);
        }
        for (int i = 0; i < tokens.length; ++i) {
            String[] subTokens = tokens[i].split("=");
            if (subTokens.length != 2) {
                throw new IllegalArgumentException(errorMsg);
            }
            String name = subTokens[0].trim();
            String value = subTokens[1].trim();
            if (name.equalsIgnoreCase("(species")) {
                this.species = value;
                continue;
            }
            if (name.equalsIgnoreCase("(type")) {
                this.annotationType = value;
                continue;
            }
            if (!name.equalsIgnoreCase("(curator")) continue;
            this.curator = value;
        }
    }

    private void parse() throws Exception {
        this.annotation = new Annotation(this.species, this.annotationType, this.curator);
        HashSet<Integer> orphans = new HashSet<Integer>();
        for (int i = 1; i < this.lines.length; ++i) {
            String line = this.lines[i];
            if (line.length() < 2) continue;
            String[] tokens = line.split("=");
            String entityName = tokens[0].trim().toUpperCase();
            int id = this.stringToInt(tokens[1].trim());
            Integer id2 = new Integer(id);
            Integer mainId = (Integer)this.synonymHash.get(id2);
            if (mainId != null) {
                if (entityName != null && entityName.length() != 0 && id != -1) {
                    this.annotation.add(entityName, mainId);
                }
                this.consistency = true;
                continue;
            }
            orphans.add(id2);
            this.orphansFound = true;
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean getConsistency() {
        return this.consistency;
    }

    public boolean getOrphans() {
        return this.orphansFound;
    }
}

