/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.list;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.RomanList;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] LIST_LEVEL = "\\listlevel".getBytes();
    private static final byte[] LIST_LEVEL_TYPE = "\\levelnfc".getBytes();
    private static final byte[] LIST_LEVEL_TYPE_NEW = "\\levelnfcn".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT = "\\leveljc".getBytes();
    private static final byte[] LIST_LEVEL_ALIGNMENT_NEW = "\\leveljcn".getBytes();
    private static final byte[] LIST_LEVEL_START_AT = "\\levelstartat".getBytes();
    private static final byte[] LIST_LEVEL_TEXT = "\\leveltext".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_BEGIN = "\\'02\\'".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_NUMBERED_END = ".;".getBytes();
    private static final byte[] LIST_LEVEL_STYLE_BULLETED = "\\'01\\u-3913 ?;".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_BEGIN = "\\levelnumbers".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_NUMBERED = "\\'01".getBytes();
    private static final byte[] LIST_LEVEL_NUMBERS_END = ";".getBytes();
    private static final byte[] LIST_LEVEL_FIRST_INDENT = "\\fi".getBytes();
    private static final byte[] LIST_LEVEL_SYMBOL_INDENT = "\\tx".getBytes();
    private static final byte[] LIST_LEVEL_NUMBER = "\\ilvl".getBytes();
    private static final byte[] TAB = "\\tab".getBytes();
    private static final byte[] LIST_TEXT = "\\listtext".getBytes();
    private static final byte[] LIST_NUMBER_END = ".".getBytes();
    private static final byte[] LIST_BULLET = "\\'b7".getBytes();
    private static final int LIST_TYPE_BULLET = 0;
    private static final int LIST_TYPE_NUMBERED = 1;
    private static final int LIST_TYPE_UPPER_LETTERS = 2;
    private static final int LIST_TYPE_LOWER_LETTERS = 3;
    private static final int LIST_TYPE_UPPER_ROMAN = 4;
    private static final int LIST_TYPE_LOWER_ROMAN = 5;
    private ArrayList items;
    private int listLevel = 0;
    private int firstIndent = 0;
    private int leftIndent = 0;
    private int rightIndent = 0;
    private int symbolIndent = 0;
    private int listNumber = this.document.getDocumentHeader().getListNumber(this);
    private int listType = 0;
    private RtfFont fontNumber;
    private RtfFont fontBullet;
    private int alignment = 0;
    private RtfList parentList = null;

    public RtfList(RtfDocument rtfDocument, List list) {
        super(rtfDocument);
        this.items = new ArrayList();
        if (list.symbolIndent() > 0.0f && list.indentationLeft() > 0.0f) {
            this.firstIndent = (int)((double)list.symbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)(list.indentationLeft() + list.symbolIndent()) * 20.0);
        } else if (list.symbolIndent() > 0.0f) {
            this.firstIndent = (int)((double)list.symbolIndent() * 20.0 * -1.0);
            this.leftIndent = (int)((double)list.symbolIndent() * 20.0);
        } else if (list.indentationLeft() > 0.0f) {
            this.firstIndent = 0;
            this.leftIndent = (int)((double)list.indentationLeft() * 20.0);
        } else {
            this.firstIndent = 0;
            this.leftIndent = 0;
        }
        this.rightIndent = (int)((double)list.indentationRight() * 20.0);
        this.symbolIndent = (int)((double)(list.symbolIndent() + list.indentationLeft()) * 20.0);
        if (list instanceof RomanList) {
            this.listType = ((RomanList)list).isRomanLower() ? 5 : 4;
        } else if (list.isNumbered()) {
            this.listType = 1;
        } else if (list.isLettered()) {
            this.listType = list.isLowerCase() ? 3 : 2;
        }
        for (int i = 0; i < list.getItems().size(); ++i) {
            try {
                RtfBasicElement rtfBasicElement;
                Element element = (Element)list.getItems().get(i);
                if (element.type() == 10) {
                    element = new ListItem((Chunk)element);
                }
                if (element instanceof ListItem) {
                    this.alignment = ((ListItem)element).alignment();
                }
                if ((rtfBasicElement = rtfDocument.getMapper().mapElement(element)) instanceof RtfList) {
                    ((RtfList)rtfBasicElement).setListNumber(this.listNumber);
                    ((RtfList)rtfBasicElement).setListLevel(this.listLevel + 1);
                    ((RtfList)rtfBasicElement).setParent(this);
                } else if (rtfBasicElement instanceof RtfListItem) {
                    ((RtfListItem)rtfBasicElement).setParent(this);
                    ((RtfListItem)rtfBasicElement).inheritListSettings(this.listNumber, this.listLevel + 1);
                }
                this.items.add(rtfBasicElement);
                continue;
            }
            catch (DocumentException documentException) {
                documentException.printStackTrace();
            }
        }
        if (this.listLevel == 0) {
            this.correctIndentation();
        }
        this.fontNumber = new RtfFont(this.document, new Font(2, 10.0f, 0, new Color(0, 0, 0)));
        this.fontBullet = new RtfFont(this.document, new Font(3, 10.0f, 0, new Color(0, 0, 0)));
    }

    private byte[] writeIndentations() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(LIST_LEVEL_FIRST_INDENT);
            byteArrayOutputStream.write(this.intToByteArray(this.firstIndent));
            byteArrayOutputStream.write(RtfParagraphStyle.INDENT_LEFT);
            byteArrayOutputStream.write(this.intToByteArray(this.leftIndent));
            byteArrayOutputStream.write(RtfParagraphStyle.INDENT_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.rightIndent));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL);
            byteArrayOutputStream.write(LIST_LEVEL_TYPE);
            switch (this.listType) {
                case 0: {
                    byteArrayOutputStream.write(this.intToByteArray(23));
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(this.intToByteArray(0));
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(this.intToByteArray(3));
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(this.intToByteArray(4));
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write(this.intToByteArray(1));
                    break;
                }
                case 5: {
                    byteArrayOutputStream.write(this.intToByteArray(2));
                }
            }
            byteArrayOutputStream.write(LIST_LEVEL_TYPE_NEW);
            switch (this.listType) {
                case 0: {
                    byteArrayOutputStream.write(this.intToByteArray(23));
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(this.intToByteArray(0));
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(this.intToByteArray(3));
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(this.intToByteArray(4));
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write(this.intToByteArray(1));
                    break;
                }
                case 5: {
                    byteArrayOutputStream.write(this.intToByteArray(2));
                }
            }
            byteArrayOutputStream.write(LIST_LEVEL_ALIGNMENT);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(LIST_LEVEL_ALIGNMENT_NEW);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(LIST_LEVEL_START_AT);
            byteArrayOutputStream.write(this.intToByteArray(1));
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL_TEXT);
            if (this.listType != 0) {
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_NUMBERED_BEGIN);
                if (this.listLevel < 10) {
                    byteArrayOutputStream.write(this.intToByteArray(0));
                }
                byteArrayOutputStream.write(this.intToByteArray(this.listLevel));
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_NUMBERED_END);
            } else {
                byteArrayOutputStream.write(LIST_LEVEL_STYLE_BULLETED);
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_BEGIN);
            if (this.listType != 0) {
                byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_NUMBERED);
            }
            byteArrayOutputStream.write(LIST_LEVEL_NUMBERS_END);
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
            if (this.listType != 0) {
                byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
            } else {
                byteArrayOutputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
            }
            byteArrayOutputStream.write(this.writeIndentations());
            byteArrayOutputStream.write(LIST_LEVEL_SYMBOL_INDENT);
            byteArrayOutputStream.write(this.intToByteArray(this.leftIndent));
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write("\n".getBytes());
            for (int i = 0; i < this.items.size(); ++i) {
                RtfElement rtfElement = (RtfElement)this.items.get(i);
                if (rtfElement instanceof RtfList) {
                    byteArrayOutputStream.write(((RtfList)rtfElement).writeDefinition());
                } else {
                    byte[] byArray;
                    if (!(rtfElement instanceof RtfListItem) || (byArray = ((RtfListItem)rtfElement).writeDefinition()).length <= 0) continue;
                    byteArrayOutputStream.write(byArray);
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] writeListBeginning() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(RtfParagraph.IN_TABLE);
            }
            switch (this.alignment) {
                case 0: {
                    byteArrayOutputStream.write(RtfParagraphStyle.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(RtfParagraphStyle.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(RtfParagraphStyle.ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    byteArrayOutputStream.write(RtfParagraphStyle.ALIGN_JUSTIFY);
                }
            }
            byteArrayOutputStream.write(this.writeIndentations());
            byteArrayOutputStream.write(RtfFont.FONT_SIZE);
            byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontSize() * 2));
            if (this.symbolIndent > 0) {
                byteArrayOutputStream.write("\\tx".getBytes());
                byteArrayOutputStream.write(this.intToByteArray(this.leftIndent));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] writeListNumbers() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(RtfListTable.LIST_NUMBER);
            byteArrayOutputStream.write(this.intToByteArray(this.listNumber));
            if (this.listLevel > 0) {
                byteArrayOutputStream.write(LIST_LEVEL_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(this.listLevel));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.writeListBeginning());
            byteArrayOutputStream.write(this.writeListNumbers());
            byteArrayOutputStream.write(OPEN_GROUP);
            int n = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                RtfElement rtfElement = (RtfElement)this.items.get(i);
                if (rtfElement instanceof RtfListItem) {
                    ++n;
                    byteArrayOutputStream.write(OPEN_GROUP);
                    byteArrayOutputStream.write(LIST_TEXT);
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                    if (this.inTable) {
                        byteArrayOutputStream.write(RtfParagraph.IN_TABLE);
                    }
                    byteArrayOutputStream.write(RtfFontList.FONT_NUMBER);
                    if (this.listType != 0) {
                        byteArrayOutputStream.write(this.intToByteArray(this.fontNumber.getFontNumber()));
                    } else {
                        byteArrayOutputStream.write(this.intToByteArray(this.fontBullet.getFontNumber()));
                    }
                    byteArrayOutputStream.write(this.writeIndentations());
                    byteArrayOutputStream.write(DELIMITER);
                    if (this.listType != 0) {
                        switch (this.listType) {
                            case 1: {
                                byteArrayOutputStream.write(this.intToByteArray(n));
                                break;
                            }
                            case 2: {
                                byteArrayOutputStream.write(List.getUpperCaseLetter(n).getBytes());
                                break;
                            }
                            case 3: {
                                byteArrayOutputStream.write(List.getLowerCaseLetter(n).getBytes());
                                break;
                            }
                            case 4: {
                                byteArrayOutputStream.write(RomanList.getUpperCaseLetter(n).getBytes());
                                break;
                            }
                            case 5: {
                                byteArrayOutputStream.write(RomanList.getLowerCaseLetter(n).getBytes());
                            }
                        }
                        byteArrayOutputStream.write(LIST_NUMBER_END);
                    } else {
                        byteArrayOutputStream.write(LIST_BULLET);
                    }
                    byteArrayOutputStream.write(TAB);
                    byteArrayOutputStream.write(CLOSE_GROUP);
                    byteArrayOutputStream.write(rtfElement.write());
                    byteArrayOutputStream.write(RtfParagraph.PARAGRAPH);
                    if (((RtfListItem)rtfElement).isContainsInnerList()) {
                        byteArrayOutputStream.write(this.writeListNumbers());
                    }
                    byteArrayOutputStream.write("\n".getBytes());
                    continue;
                }
                if (!(rtfElement instanceof RtfList)) continue;
                byteArrayOutputStream.write(rtfElement.write());
                byteArrayOutputStream.write(this.writeListBeginning());
                byteArrayOutputStream.write(this.writeListNumbers());
                byteArrayOutputStream.write("\n".getBytes());
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            if (!this.inTable) {
                byteArrayOutputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getListLevel() {
        return this.listLevel;
    }

    public void setListLevel(int n) {
        this.listLevel = n;
        if (this.listLevel != 0) {
            this.document.getDocumentHeader().freeListNumber(this);
            for (int i = 0; i < this.items.size(); ++i) {
                if (!(this.items.get(i) instanceof RtfList)) continue;
                ((RtfList)this.items.get(i)).setListNumber(this.listNumber);
                ((RtfList)this.items.get(i)).setListLevel(this.listLevel + 1);
            }
        } else {
            this.listNumber = this.document.getDocumentHeader().getListNumber(this);
        }
    }

    protected void setParent(RtfList rtfList) {
        this.parentList = rtfList;
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int n) {
        this.listNumber = n;
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(bl);
        }
    }

    protected void correctIndentation() {
        if (this.parentList != null) {
            this.leftIndent = this.leftIndent + this.parentList.getLeftIndent() + this.parentList.getFirstIndent();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) instanceof RtfList) {
                ((RtfList)this.items.get(i)).correctIndentation();
                continue;
            }
            if (!(this.items.get(i) instanceof RtfListItem)) continue;
            ((RtfListItem)this.items.get(i)).correctIndentation();
        }
    }

    private int getLeftIndent() {
        return this.leftIndent;
    }

    private int getFirstIndent() {
        return this.firstIndent;
    }
}

