/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.init.CyInitParams;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.shadegrown.WindowUtilities;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;

public class CytoscapeInit {
    private static Properties properties;
    private static Properties visualProperties;
    private static Set pluginURLs;
    private static Set loadedPlugins;
    private static Set resourcePlugins;
    private static CyInitParams initParams;
    private static URLClassLoader classLoader;
    private static File mrud;
    private static File mruf;
    private static boolean useView;
    private static boolean suppressView;
    private static int secondaryViewThreshold;
    private static String vizmapPropertiesLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(CyInitParams params) {
        long begintime = System.currentTimeMillis();
        try {
            initParams = params;
            CytoscapeInit.initProperties();
            properties.putAll((Map<?, ?>)initParams.getProps());
            visualProperties.putAll((Map<?, ?>)initParams.getVizProps());
            Cytoscape.buildOntologyServer();
            System.out.println("init mode: " + initParams.getMode());
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                ImageIcon image = new ImageIcon(this.getClass().getResource("/cytoscape/images/CytoscapeSplashScreen.png"));
                WindowUtilities.showSplash(image, 8000);
                Cytoscape.getDesktop();
                Cytoscape.getDesktop().setCursor(Cursor.getPredefinedCursor(3));
                this.setUpAttributesChangedListener();
            }
            this.loadPlugins();
            System.out.println("loading session...");
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                this.loadSessionFile();
            }
            System.out.println("loading networks...");
            this.loadNetworks();
            System.out.println("loading attributes...");
            this.loadAttributes();
            System.out.println("loading expression files...");
            CytoscapeInit.loadExpressionFiles();
        }
        finally {
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                WindowUtilities.hideSplash();
                Cytoscape.getDesktop().setCursor(Cursor.getDefaultCursor());
                Cytoscape.getDesktop().repaint();
            }
        }
        long endtime = System.currentTimeMillis() - begintime;
        System.out.println("");
        System.out.println("Cytoscape initialized successfully in: " + endtime + " ms");
        Cytoscape.firePropertyChange(Cytoscape.CYTOSCAPE_INITIALIZED, null, null);
        return true;
    }

    public static CyInitParams getCyInitParams() {
        return initParams;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static URLClassLoader getClassLoader() {
        return classLoader;
    }

    public static Set getPluginURLs() {
        return pluginURLs;
    }

    public static Set getResourcePlugins() {
        return resourcePlugins;
    }

    public String getHelp() {
        return "Help! - you shouldn't be using this method";
    }

    public static boolean isHeadless() {
        return !useView;
    }

    public static boolean useView() {
        return useView;
    }

    public static boolean suppressView() {
        return suppressView;
    }

    public static String[] getArgs() {
        return initParams.getArgs();
    }

    public static String getPropertiesLocation() {
        return "";
    }

    public static String getBioDataServer() {
        return properties.getProperty("bioDataServer");
    }

    public static boolean noCanonicalization() {
        return properties.getProperty("canonicalizeNames").equals("true");
    }

    public static Set getExpressionFiles() {
        return new HashSet(initParams.getExpressionFiles());
    }

    public static Set getGraphFiles() {
        return new HashSet(initParams.getGraphFiles());
    }

    public static Set getEdgeAttributes() {
        return new HashSet(initParams.getEdgeAttributeFiles());
    }

    public static Set getNodeAttributes() {
        return new HashSet(initParams.getNodeAttributeFiles());
    }

    public static String getDefaultSpeciesName() {
        return properties.getProperty("defaultSpeciesName", "unknown");
    }

    public static int getViewType() {
        return CytoscapeDesktop.parseViewType(properties.getProperty("viewType"));
    }

    public static int getViewThreshold() {
        return Integer.parseInt(properties.getProperty("viewThreshold"));
    }

    public static void setViewThreshold(int threshold) {
        properties.setProperty("viewThreshold", Integer.toString(threshold));
    }

    public static int getSecondaryViewThreshold() {
        return secondaryViewThreshold;
    }

    public static void setSecondaryViewThreshold(int threshold) {
        secondaryViewThreshold = threshold;
    }

    public static String getVizmapPropertiesLocation() {
        return vizmapPropertiesLocation;
    }

    public static String getDefaultVisualStyle() {
        return properties.getProperty("defaultVisualStyle");
    }

    private void loadPlugins() {
        try {
            HashSet plugins = new HashSet();
            List p = initParams.getPlugins();
            if (p != null) {
                plugins.addAll(p);
            }
            System.out.println("Looking for plugins in:");
            for (String plugin : plugins) {
                File f = new File(plugin);
                if (plugin.endsWith(".jar")) {
                    if (!plugin.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                        System.out.println(" - file: " + f.getAbsolutePath());
                        pluginURLs.add(CytoscapeInit.jarURL(f.getAbsolutePath()));
                        continue;
                    }
                    System.out.println(" - url: " + f.getAbsolutePath());
                    pluginURLs.add(CytoscapeInit.jarURL(plugin));
                    continue;
                }
                if (!f.exists()) {
                    System.out.println(" - classpath: " + f.getAbsolutePath());
                    resourcePlugins.add(plugin);
                    continue;
                }
                if (f.isDirectory()) {
                    System.out.println(" - directory: " + f.getAbsolutePath());
                    String[] fileList = f.list();
                    for (int j = 0; j < fileList.length; ++j) {
                        if (!fileList[j].endsWith(".jar")) continue;
                        pluginURLs.add(CytoscapeInit.jarURL(f.getAbsolutePath() + System.getProperty("file.separator") + fileList[j]));
                    }
                    continue;
                }
                System.out.println(" - file manifest: " + f.getAbsolutePath());
                try {
                    TextHttpReader reader = new TextHttpReader(plugin);
                    reader.read();
                    String text = reader.getText();
                    String lineSep = System.getProperty("line.separator");
                    String[] allLines = text.split(lineSep);
                    for (int j = 0; j < allLines.length; ++j) {
                        String pluginLoc = allLines[j];
                        if (!pluginLoc.endsWith(".jar")) continue;
                        if (pluginLoc.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                            pluginURLs.add(pluginLoc);
                            continue;
                        }
                        System.err.println("Plugin location specified in " + plugin + " is not a valid url: " + pluginLoc + " -- NOT adding it.");
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    System.err.println("error reading plugin manifest file " + plugin);
                }
            }
            this.loadURLPlugins(pluginURLs);
            this.loadResourcePlugins(resourcePlugins);
        }
        catch (Exception e) {
            System.out.println("failed loading plugin!");
            e.printStackTrace();
        }
    }

    private void loadURLPlugins(Set plugin_urls) {
        URL[] urls = new URL[plugin_urls.size()];
        int count = 0;
        Iterator iter = plugin_urls.iterator();
        while (iter.hasNext()) {
            urls[count] = (URL)iter.next();
            ++count;
        }
        classLoader = new URLClassLoader(urls, Cytoscape.class.getClassLoader());
        for (int i = 0; i < urls.length; ++i) {
            System.out.println("");
            System.out.println("attempting to load plugin url: ");
            System.out.println(urls[i]);
            try {
                Class pc;
                String className;
                JarURLConnection jc = (JarURLConnection)urls[i].openConnection();
                JarFile jar = jc.getJarFile();
                if (jar == null) continue;
                Manifest m = jar.getManifest();
                if (m != null && (className = m.getMainAttributes().getValue("Cytoscape-Plugin")) != null && (pc = this.getPluginClass(className)) != null) {
                    System.out.println("Loading from manifest");
                    this.loadPlugin(pc);
                    continue;
                }
                Enumeration<JarEntry> entries = jar.entries();
                if (entries == null) continue;
                int totalPlugins = 0;
                while (entries.hasMoreElements()) {
                    String entry = ((Object)entries.nextElement()).toString();
                    if (!entry.endsWith("class")) continue;
                    entry = entry.replaceAll("\\.class$", "");
                    Class pc2 = this.getPluginClass(entry = entry.replaceAll("/|\\\\", "."));
                    if (pc2 == null) continue;
                    ++totalPlugins;
                    this.loadPlugin(pc2);
                    break;
                }
                if (totalPlugins != 0) continue;
                System.out.println("No plugin found in specified jar - assuming it's a library.");
                continue;
            }
            catch (Exception e) {
                System.out.println("Couldn't load plugin url!");
                System.err.println("Error: " + e.getMessage());
            }
        }
        System.out.println("");
    }

    private void loadResourcePlugins(Set rp) {
        for (String resource : rp) {
            System.out.println("");
            System.out.println("attempting to load plugin resourse: " + resource);
            Class<?> rclass = null;
            try {
                rclass = Class.forName(resource);
            }
            catch (Exception exc) {
                System.out.println("Getting class: " + resource + " failed");
                exc.printStackTrace();
                return;
            }
            this.loadPlugin(rclass);
        }
        System.out.println("");
    }

    public void loadPlugin(Class plugin) {
        if (CytoscapePlugin.class.isAssignableFrom(plugin) && !loadedPlugins.contains(plugin.getName())) {
            try {
                CytoscapePlugin.loadPlugin(plugin);
                loadedPlugins.add(plugin.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Class getPluginClass(String name) {
        Class<?> c = null;
        try {
            c = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            return null;
        }
        if (CytoscapePlugin.class.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    public static File getMRUD() {
        if (mrud == null) {
            mrud = new File(properties.getProperty("mrud", System.getProperty("user.dir")));
        }
        return mrud;
    }

    public static File getMRUF() {
        return mruf;
    }

    public static void setMRUD(File mrud_new) {
        mrud = mrud_new;
    }

    public static void setMRUF(File mruf_new) {
        mruf = mruf_new;
    }

    public static void setDefaultSpeciesName() {
    }

    public static File getConfigDirectoy() {
        return CytoscapeInit.getConfigDirectory();
    }

    public static File getConfigDirectory() {
        Object dir = null;
        try {
            String dirName = properties.getProperty("alternative.config.dir", System.getProperty("user.home"));
            File parent_dir = new File(dirName, ".cytoscape");
            if (parent_dir.mkdir()) {
                System.err.println("Parent_Dir: " + parent_dir + " created.");
            }
            return parent_dir;
        }
        catch (Exception e) {
            System.err.println("error getting config directory");
            return null;
        }
    }

    public static File getConfigFile(String file_name) {
        try {
            File parent_dir = CytoscapeInit.getConfigDirectory();
            File file = new File(parent_dir, file_name);
            if (file.createNewFile()) {
                System.err.println("Config file: " + file + " created.");
            }
            return file;
        }
        catch (Exception e) {
            System.err.println("error getting config file:" + file_name);
            return null;
        }
    }

    public static Properties getVisualProperties() {
        return visualProperties;
    }

    private static void loadStaticProperties(String defaultName, Properties props) {
        if (props == null) {
            System.out.println("input props is null");
            props = new Properties();
        }
        String tryName = "";
        try {
            tryName = "cytoscape.jar";
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL vmu = null;
            if (cl != null) {
                vmu = cl.getResource(defaultName);
            } else {
                System.out.println("ClassLoader for reading cytoscape.jar is null");
            }
            if (vmu != null) {
                props.load(vmu.openStream());
            } else {
                System.out.println("couldn't read " + defaultName + " from " + tryName);
            }
            tryName = "$HOME/.cytoscape";
            File vmp = CytoscapeInit.getConfigFile(defaultName);
            if (vmp != null) {
                props.load(new FileInputStream(vmp));
            } else {
                System.out.println("couldn't read " + defaultName + " from " + tryName);
            }
        }
        catch (IOException ioe) {
            System.err.println("couldn't open " + tryName + " " + defaultName + " file - creating a hardcoded default");
            ioe.printStackTrace();
        }
    }

    private static void loadExpressionFiles() {
        List ef = initParams.getExpressionFiles();
        if (ef != null && ef.size() > 0) {
            for (String expDataFilename : ef) {
                if (expDataFilename == null) continue;
                try {
                    Cytoscape.loadExpressionData(expDataFilename, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static URL jarURL(String urlString) {
        URL url = null;
        try {
            String uString = urlString.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$") ? "jar:" + urlString + "!/" : "jar:file:" + urlString + "!/";
            url = new URL(uString);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            System.out.println("couldn't create jar url from '" + urlString + "'");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSessionFile() {
        String sessionFile = initParams.getSessionFile();
        Cytoscape.getDesktop().getNetworkPanel().getTreeTable().setVisible(false);
        try {
            String sessionName = "";
            if (sessionFile != null) {
                Cytoscape.setSessionState(1);
                Cytoscape.createNewSession();
                Cytoscape.setSessionState(0);
                CytoscapeSessionReader reader = null;
                if (sessionFile.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                    URL u = new URL(sessionFile);
                    reader = new CytoscapeSessionReader(u);
                    sessionName = u.getFile();
                } else {
                    Cytoscape.setCurrentSessionFileName(sessionFile);
                    File shortName = new File(sessionFile);
                    URL sessionURL = shortName.toURL();
                    reader = new CytoscapeSessionReader(sessionURL);
                    sessionName = shortName.getName();
                }
                if (reader != null) {
                    reader.read();
                    Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session Name: " + sessionName + ")");
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("couldn't create session from file: '" + sessionFile + "'");
        }
        finally {
            Cytoscape.getDesktop().getNetworkPanel().getTreeTable().setVisible(true);
        }
        return false;
    }

    private static void initProperties() {
        if (properties == null) {
            properties = new Properties();
            CytoscapeInit.loadStaticProperties("cytoscape.props", properties);
        }
        if (visualProperties == null) {
            visualProperties = new Properties();
            CytoscapeInit.loadStaticProperties("vizmap.props", visualProperties);
        }
    }

    private void setUpAttributesChangedListener() {
        PropertyChangeListener attsChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(Cytoscape.ATTRIBUTES_CHANGED)) {
                    Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                }
            }
        };
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(attsChangeListener);
    }

    private void loadNetworks() {
        for (String net : initParams.getGraphFiles()) {
            System.out.println("Load: " + net);
            CyNetwork network = null;
            network = initParams.getMode() == 1 || initParams.getMode() == 4 ? Cytoscape.createNetworkFromFile(net, true) : Cytoscape.createNetworkFromFile(net, false);
            Object[] ret_val = new Object[]{network, net, new Integer(0)};
            Cytoscape.firePropertyChange("NETWORK_LOADED", null, ret_val);
        }
    }

    private void loadAttributes() {
        try {
            Cytoscape.loadAttributes(initParams.getNodeAttributeFiles().toArray(new String[0]), initParams.getEdgeAttributeFiles().toArray(new String[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("failure loading specified attributes");
        }
    }

    static {
        System.out.println("CytoscapeInit static initialization");
        pluginURLs = new HashSet();
        resourcePlugins = new HashSet();
        loadedPlugins = new HashSet();
        CytoscapeInit.initProperties();
        useView = true;
        suppressView = false;
    }
}

