/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.actions.ExportAsXGMMLTask;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CyFileFilter;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JOptionPane;

public class ExportAsXGMMLAction
extends CytoscapeAction {
    public ExportAsXGMMLAction() {
        super("Network and attributes as XGMML...");
        this.setPreferredMenu("File.Export");
    }

    public ExportAsXGMMLAction(boolean label) {
    }

    protected boolean checkNetworkCount() {
        Set networks = Cytoscape.getNetworkSet();
        if (networks.size() == 0) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "No network in this session!", "No network Error", 1);
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        String name;
        if (!this.checkNetworkCount()) {
            return;
        }
        CyFileFilter xgmmlFilter = new CyFileFilter();
        CyFileFilter xmlFilter = new CyFileFilter();
        CyFileFilter graphFilter = new CyFileFilter();
        xgmmlFilter.addExtension("xgmml");
        xgmmlFilter.setDescription("XGMML files");
        xmlFilter.addExtension("xml");
        xmlFilter.setDescription("XML files");
        graphFilter.addExtension("xgmml");
        graphFilter.addExtension("xml");
        graphFilter.setDescription("All xml-based network files");
        try {
            name = FileUtil.getFile("Export Network and Attributes as XGMML", FileUtil.SAVE, new CyFileFilter[]{xgmmlFilter, xmlFilter, graphFilter}).toString();
        }
        catch (Exception exp) {
            return;
        }
        if (!name.endsWith(".xgmml")) {
            name = name + ".xgmml";
        }
        CyNetwork network = Cytoscape.getCurrentNetwork();
        CyNetworkView view = Cytoscape.getNetworkView(network.getIdentifier());
        ExportAsXGMMLTask task = new ExportAsXGMMLTask(name, network, view);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner(Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(false);
        TaskManager.executeTask(task, jTaskConfig);
    }
}

