/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.HierarchicalClusteringResultTree;

public class AvgLinkHierarchicalClustering {
    protected int[][] result = null;
    protected double[] linkDistance = null;
    protected DistanceMatrix distanceMatrix = null;
    protected int nelements = 0;
    protected int[] leafOrder;
    protected boolean optimalLeafOrdering = true;
    protected boolean singleLinkage = false;
    protected ArrayList labelHighlight;
    protected int[][] linkedLeaves = null;
    private final int rightTree = 2;
    private final int leftTree = 1;
    private final double maxAdd = 2.0;

    public AvgLinkHierarchicalClustering(DistanceMatrix distanceMatrix) {
        this.distanceMatrix = distanceMatrix;
        this.nelements = distanceMatrix.getMatrixDimension();
        this.result = new int[this.nelements - 1][2];
        this.linkedLeaves = new int[this.nelements - 1][2];
        this.linkDistance = new double[this.nelements];
        this.leafOrder = new int[this.nelements];
    }

    public String getLabel(int elementIndex) {
        String elementLabel = (String)this.distanceMatrix.getLabels().get(elementIndex);
        return elementLabel;
    }

    private double findClosestPair(int nNodes, Pair pair, DistanceMatrix dmInternal) {
        double distance = dmInternal.getValue(1, 0);
        int i = 0;
        while (i < nNodes) {
            int j = 0;
            while (j < i) {
                if (dmInternal.getValue(i, j) < distance) {
                    distance = dmInternal.getValue(i, j);
                    pair.i = i;
                    pair.j = j;
                }
                ++j;
            }
            ++i;
        }
        return distance;
    }

    public void run() {
        int[] number = new int[this.nelements];
        int[] clusterid = new int[this.nelements];
        int j = 0;
        while (j < this.nelements) {
            number[j] = 1;
            clusterid[j] = j;
            ++j;
        }
        DistanceMatrix dmInternal = this.distanceMatrix.copy();
        Pair pair = new Pair();
        int nNodes = this.nelements;
        while (nNodes > 1) {
            pair.i = 1;
            pair.j = 0;
            this.linkDistance[this.nelements - nNodes] = this.findClosestPair(nNodes, pair, dmInternal);
            int isaved = pair.i;
            int jsaved = pair.j;
            int sum = 0;
            this.linkedLeaves[this.nelements - nNodes][0] = pair.i;
            this.linkedLeaves[this.nelements - nNodes][1] = pair.j;
            this.result[this.nelements - nNodes][0] = clusterid[isaved];
            this.result[this.nelements - nNodes][1] = clusterid[jsaved];
            if (!this.singleLinkage) {
                sum = number[isaved] + number[jsaved];
                int j2 = 0;
                while (j2 < jsaved) {
                    dmInternal.setValue(jsaved, j2, dmInternal.getValue(isaved, j2) * (double)number[isaved] + dmInternal.getValue(jsaved, j2) * (double)number[jsaved]);
                    dmInternal.setValue(jsaved, j2, dmInternal.getValue(jsaved, j2) / (double)sum);
                    ++j2;
                }
                j2 = jsaved + 1;
                while (j2 < isaved) {
                    dmInternal.setValue(j2, jsaved, dmInternal.getValue(isaved, j2) * (double)number[isaved] + dmInternal.getValue(j2, jsaved) * (double)number[jsaved]);
                    dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, jsaved) / (double)sum);
                    ++j2;
                }
                j2 = isaved + 1;
                while (j2 < nNodes) {
                    dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, isaved) * (double)number[isaved] + dmInternal.getValue(j2, jsaved) * (double)number[jsaved]);
                    dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, jsaved) / (double)sum);
                    ++j2;
                }
                j2 = 0;
                while (j2 < isaved) {
                    dmInternal.setValue(isaved, j2, dmInternal.getValue(nNodes - 1, j2));
                    ++j2;
                }
                j2 = isaved + 1;
                while (j2 < nNodes - 1) {
                    dmInternal.setValue(j2, isaved, dmInternal.getValue(nNodes - 1, j2));
                    ++j2;
                }
            }
            number[jsaved] = sum;
            number[isaved] = number[nNodes - 1];
            clusterid[jsaved] = nNodes - this.nelements - 1;
            clusterid[isaved] = clusterid[nNodes - 1];
            --nNodes;
        }
        dmInternal = null;
        if (this.optimalLeafOrdering) {
            this.orderLeavesBarJoseph2003(this.result, this.distanceMatrix, this.leafOrder);
        } else {
            this.orderLeavesEisenHeuristic(this.leafOrder);
        }
    }

    public void old_run() {
        int[] number = new int[this.nelements];
        int[] clusterid = new int[this.nelements];
        int j = 0;
        while (j < this.nelements) {
            number[j] = 1;
            clusterid[j] = j;
            ++j;
        }
        DistanceMatrix dmInternal = this.distanceMatrix.copy();
        Pair pair = new Pair();
        int nNodes = this.nelements;
        while (nNodes > 1) {
            pair.i = 1;
            pair.j = 0;
            this.linkDistance[this.nelements - nNodes] = this.findClosestPair(nNodes, pair, dmInternal);
            int isaved = pair.i;
            int jsaved = pair.j;
            int sum = 0;
            this.result[this.nelements - nNodes][0] = clusterid[isaved];
            this.result[this.nelements - nNodes][1] = clusterid[jsaved];
            sum = number[isaved] + number[jsaved];
            int j2 = 0;
            while (j2 < jsaved) {
                dmInternal.setValue(jsaved, j2, dmInternal.getValue(isaved, j2) * (double)number[isaved] + dmInternal.getValue(jsaved, j2) * (double)number[jsaved]);
                dmInternal.setValue(jsaved, j2, dmInternal.getValue(jsaved, j2) / (double)sum);
                ++j2;
            }
            j2 = jsaved + 1;
            while (j2 < isaved) {
                dmInternal.setValue(j2, jsaved, dmInternal.getValue(isaved, j2) * (double)number[isaved] + dmInternal.getValue(j2, jsaved) * (double)number[jsaved]);
                dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, jsaved) / (double)sum);
                ++j2;
            }
            j2 = isaved + 1;
            while (j2 < nNodes) {
                dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, isaved) * (double)number[isaved] + dmInternal.getValue(j2, jsaved) * (double)number[jsaved]);
                dmInternal.setValue(j2, jsaved, dmInternal.getValue(j2, jsaved) / (double)sum);
                ++j2;
            }
            j2 = 0;
            while (j2 < isaved) {
                dmInternal.setValue(isaved, j2, dmInternal.getValue(nNodes - 1, j2));
                ++j2;
            }
            j2 = isaved + 1;
            while (j2 < nNodes - 1) {
                dmInternal.setValue(j2, isaved, dmInternal.getValue(nNodes - 1, j2));
                ++j2;
            }
            number[jsaved] = sum;
            number[isaved] = number[nNodes - 1];
            clusterid[jsaved] = nNodes - this.nelements - 1;
            clusterid[isaved] = clusterid[nNodes - 1];
            --nNodes;
        }
        dmInternal = null;
        if (this.optimalLeafOrdering) {
            this.orderLeavesBarJoseph2003(this.result, this.distanceMatrix, this.leafOrder);
        } else {
            this.orderLeavesEisenHeuristic(this.leafOrder);
        }
    }

    public int[] cutTree(int nclusters) {
        int k;
        int icluster = 0;
        int n = this.nelements - nclusters;
        int[] clusterid = new int[this.nelements];
        boolean flag = false;
        if (nclusters > this.nelements || nclusters < 1) {
            flag = true;
        }
        int i = 0;
        while (i < this.nelements - 1) {
            if (this.result[i][0] >= this.nelements || this.result[i][0] < -i || this.result[i][1] >= this.nelements || this.result[i][1] < -i) {
                flag = true;
                break;
            }
            ++i;
        }
        if (flag) {
            i = 0;
            while (i < this.nelements) {
                clusterid[i] = -1;
                ++i;
            }
            return null;
        }
        i = this.nelements - 2;
        while (i >= n) {
            k = this.result[i][0];
            if (k >= 0) {
                clusterid[k] = icluster++;
            }
            if ((k = this.result[i][1]) >= 0) {
                clusterid[k] = icluster++;
            }
            --i;
        }
        int[] nodeid = new int[n];
        i = 0;
        while (i < n) {
            nodeid[i] = -1;
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            int j;
            if (nodeid[i] < 0) {
                nodeid[i] = j = icluster++;
            } else {
                j = nodeid[i];
            }
            k = this.result[i][0];
            if (k < 0) {
                nodeid[-k - 1] = j;
            } else {
                clusterid[k] = j;
            }
            k = this.result[i][1];
            if (k < 0) {
                nodeid[-k - 1] = j;
            } else {
                clusterid[k] = j;
            }
            --i;
        }
        return clusterid;
    }

    public boolean isOptimalLeafOrdering() {
        return this.optimalLeafOrdering;
    }

    public void setOptimalLeafOrdering(boolean optimalLeafOrdering) {
        this.optimalLeafOrdering = optimalLeafOrdering;
    }

    public void setLeafOrderingMethod(String leafOrderingMethod) {
        this.optimalLeafOrdering = leafOrderingMethod == "Bar-Joseph";
    }

    public boolean isSingleLinkage() {
        return this.singleLinkage;
    }

    public void setSingleLinkage(boolean flag) {
        this.singleLinkage = flag;
    }

    public HierarchicalClusteringResultTree getResult() {
        return this.convertResultTreeToTreeClass(this.result, this.linkDistance, this.leafOrder);
    }

    private HierarchicalClusteringResultTree convertResultTreeToTreeClass(int[][] resultTree, double[] linkDistance, int[] leafOrder) {
        ArrayList<Integer> leafOrderList = new ArrayList<Integer>();
        int i = 0;
        while (i < leafOrder.length) {
            int index = leafOrder[i];
            leafOrderList.add(new Integer(index));
            ++i;
        }
        ArrayList clusteredElementLabels = this.distanceMatrix.getLabels();
        HierarchicalClusteringResultTree t = null;
        HierarchicalClusteringResultTree[] internalNodeList = new HierarchicalClusteringResultTree[resultTree.length + 1];
        int i2 = 0;
        while (i2 < resultTree.length) {
            HierarchicalClusteringResultTree tleft = null;
            HierarchicalClusteringResultTree tright = null;
            tleft = resultTree[i2][0] >= 0 ? new HierarchicalClusteringResultTree(resultTree[i2][0], leafOrderList.indexOf(new Integer(resultTree[i2][0])), (String)clusteredElementLabels.get(resultTree[i2][0])) : internalNodeList[-resultTree[i2][0]];
            tright = resultTree[i2][1] >= 0 ? new HierarchicalClusteringResultTree(resultTree[i2][1], leafOrderList.indexOf(new Integer(resultTree[i2][1])), (String)clusteredElementLabels.get(resultTree[i2][1])) : internalNodeList[-resultTree[i2][1]];
            HierarchicalClusteringResultTree leftLeaf = new HierarchicalClusteringResultTree(this.linkedLeaves[i2][0], leafOrderList.indexOf(new Integer(this.linkedLeaves[i2][0])), (String)clusteredElementLabels.get(this.linkedLeaves[i2][0]));
            HierarchicalClusteringResultTree rightLeaf = new HierarchicalClusteringResultTree(this.linkedLeaves[i2][1], leafOrderList.indexOf(new Integer(this.linkedLeaves[i2][1])), (String)clusteredElementLabels.get(this.linkedLeaves[i2][1]));
            HierarchicalClusteringResultTree hierarchicalClusteringResultTree = new HierarchicalClusteringResultTree(tleft, tright, i2 + 1, linkDistance[i2], leftLeaf, rightLeaf);
            internalNodeList[i2 + 1] = hierarchicalClusteringResultTree;
            t = hierarchicalClusteringResultTree;
            ++i2;
        }
        return t;
    }

    public int getNelements() {
        return this.nelements;
    }

    public double getMaxDistance() {
        double maxDistance = 0.0;
        int i = 0;
        while (i < this.linkDistance.length) {
            maxDistance = Math.max(maxDistance, this.linkDistance[i]);
            ++i;
        }
        return maxDistance;
    }

    public int[] getLeafOrder() {
        return this.leafOrder;
    }

    private void treeSort(double[] order, double[] nodeorder, int[] nodecounts, int[][] NodeElement, int[] leafOrder) {
        int nNodes = this.nelements - 1;
        double[] neworder = new double[this.nelements];
        int[] clusterids = new int[this.nelements];
        int i = 0;
        while (i < this.nelements) {
            clusterids[i] = i;
            ++i;
        }
        i = 0;
        while (i < nNodes) {
            int clusterid;
            int j;
            double increase;
            int count2;
            int i1 = NodeElement[i][0];
            int i2 = NodeElement[i][1];
            double order1 = i1 < 0 ? nodeorder[-i1 - 1] : order[i1];
            double order2 = i2 < 0 ? nodeorder[-i2 - 1] : order[i2];
            int count1 = i1 < 0 ? nodecounts[-i1 - 1] : 1;
            int n = count2 = i2 < 0 ? nodecounts[-i2 - 1] : 1;
            if (i1 < i2) {
                increase = order1 < order2 ? count1 : count2;
                j = 0;
                while (j < this.nelements) {
                    clusterid = clusterids[j];
                    if (clusterid == i1 && order1 >= order2) {
                        int n2 = j;
                        neworder[n2] = neworder[n2] + increase;
                    }
                    if (clusterid == i2 && order1 < order2) {
                        int n3 = j;
                        neworder[n3] = neworder[n3] + increase;
                    }
                    if (clusterid == i1 || clusterid == i2) {
                        clusterids[j] = -i - 1;
                    }
                    ++j;
                }
            } else {
                increase = order1 <= order2 ? count1 : count2;
                j = 0;
                while (j < this.nelements) {
                    clusterid = clusterids[j];
                    if (clusterid == i1 && order1 > order2) {
                        int n4 = j;
                        neworder[n4] = neworder[n4] + increase;
                    }
                    if (clusterid == i2 && order1 <= order2) {
                        int n5 = j;
                        neworder[n5] = neworder[n5] + increase;
                    }
                    if (clusterid == i1 || clusterid == i2) {
                        clusterids[j] = -i - 1;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sort(neworder, leafOrder);
    }

    private void sort(double[] data, int[] index) {
        class DataIndexPair
        implements Comparable {
            public double data;
            public int index;

            public DataIndexPair(double data, int index) {
                this.data = data;
                this.index = index;
            }

            public int compareTo(Object o) {
                DataIndexPair that = (DataIndexPair)o;
                return (int)(this.data - that.data);
            }
        }
        TreeSet<DataIndexPair> indexValue = new TreeSet<DataIndexPair>();
        int i = 0;
        while (i < data.length) {
            DataIndexPair dataIndexDataIndexPair = new DataIndexPair(data[i], i);
            indexValue.add(dataIndexDataIndexPair);
            ++i;
        }
        Iterator values = indexValue.iterator();
        int i2 = 0;
        while (values.hasNext()) {
            DataIndexPair dataIndexPair = (DataIndexPair)values.next();
            index[i2] = dataIndexPair.index;
            ++i2;
        }
    }

    private void orderLeavesEisenHeuristic(int[] leafOrder) {
        int nNodes = this.nelements - 1;
        double[] nodeorder = new double[nNodes];
        int[] nodecounts = new int[nNodes];
        double[] origOrder = new double[this.nelements];
        int i = 0;
        while (i < origOrder.length) {
            origOrder[i] = i;
            ++i;
        }
        i = 0;
        while (i < nNodes) {
            int counts2;
            double order2;
            int counts1;
            double order1;
            int min1 = this.result[i][0];
            int min2 = this.result[i][1];
            if (min1 < 0) {
                int index1 = -min1 - 1;
                order1 = nodeorder[index1];
                counts1 = nodecounts[index1];
                this.linkDistance[i] = Math.max(this.linkDistance[i], this.linkDistance[index1]);
            } else {
                order1 = origOrder[min1];
                counts1 = 1;
            }
            if (min2 < 0) {
                int index2 = -min2 - 1;
                order2 = nodeorder[index2];
                counts2 = nodecounts[index2];
                this.linkDistance[i] = Math.max(this.linkDistance[i], this.linkDistance[index2]);
            } else {
                order2 = origOrder[min2];
                counts2 = 1;
            }
            nodecounts[i] = counts1 + counts2;
            nodeorder[i] = ((double)counts1 * order1 + (double)counts2 * order2) / (double)(counts1 + counts2);
            ++i;
        }
        i = 0;
        while (i < this.nelements) {
            leafOrder[i] = i;
            ++i;
        }
        this.treeSort(origOrder, nodeorder, nodecounts, this.result, leafOrder);
    }

    private void orderLeavesBarJoseph2003(int[][] resultTree, DistanceMatrix dm, int[] leafOrder) {
        double[][] mat = new double[dm.getMatrixDimension() + 1][dm.getMatrixDimension() + 1];
        int i = 1;
        while (i < dm.getMatrixDimension() + 1) {
            int j = 1;
            while (j < dm.getMatrixDimension() + 1) {
                mat[i][j] = dm.getValue(i - 1, j - 1) - 1.0;
                ++j;
            }
            ++i;
        }
        Tree t = this.convertResultTreeToTreeClass(resultTree, mat);
        Object[] ret = t.returnOrder();
        int[] arr = (int[])ret[0];
        int i2 = 0;
        while (i2 < this.nelements) {
            leafOrder[i2] = arr[i2] - 1;
            ++i2;
        }
    }

    private Tree convertResultTreeToTreeClass(int[][] resultTree, double[][] mat) {
        Tree t = null;
        Tree[] tlist = new Tree[this.nelements];
        int i = 0;
        while (i < this.nelements - 1) {
            Tree tleft = null;
            Tree tright = null;
            tleft = resultTree[i][0] >= 0 ? new Tree(resultTree[i][0] + 1, mat) : tlist[-resultTree[i][0]];
            tright = resultTree[i][1] >= 0 ? new Tree(resultTree[i][1] + 1, mat) : tlist[-resultTree[i][1]];
            Tree tree = new Tree(tright, tleft, i + 1);
            tlist[i + 1] = tree;
            t = tree;
            ++i;
        }
        return t;
    }

    private Tree barJosephClustering(double[][] m) {
        int j;
        int num = this.nelements;
        double[][] newM = new double[num + 1][];
        Tree[] allTrees = new Tree[num + 1];
        int i = 1;
        while (i < num + 1) {
            newM[i] = new double[num + 1];
            j = 1;
            while (j < num + 1) {
                newM[i][j] = m[i][j];
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < num + 1) {
            allTrees[i] = new Tree(i, m);
            ++i;
        }
        int r = 0;
        int l = 0;
        i = 1;
        while (i < num) {
            double max = Double.MIN_VALUE;
            int k = 1;
            while (k < num) {
                if (allTrees[k] != null) {
                    j = k + 1;
                    while (j < num + 1) {
                        if (allTrees[j] != null && max < -1.0 * newM[j][k]) {
                            max = -1.0 * newM[j][k];
                            l = k;
                            r = j;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            double rSize = allTrees[r].giveNumLeafs();
            double lSize = allTrees[l].giveNumLeafs();
            System.out.print("NODE" + i + "X" + '\t');
            if (allTrees[l].isLeaf()) {
                System.out.print("GENE" + allTrees[l].giveIndex() + "X\t");
            } else {
                System.out.print("NODE" + allTrees[l].giveIndex() + "X\t");
            }
            if (allTrees[r].isLeaf()) {
                System.out.print("GENE" + allTrees[r].giveIndex() + "X\t");
            } else {
                System.out.print("NODE" + allTrees[r].giveIndex() + "X\t");
            }
            System.out.println(max);
            Tree temp = allTrees[l];
            allTrees[l] = null;
            allTrees[l] = new Tree(temp, allTrees[r], i);
            allTrees[r] = null;
            j = 1;
            while (j < num + 1) {
                if (allTrees[j] != null && j != l) {
                    newM[j][l] = (lSize * newM[j][l] + rSize * newM[j][r]) / (lSize + rSize);
                    newM[l][j] = newM[j][l];
                }
                ++j;
            }
            ++i;
        }
        Tree res = null;
        i = 1;
        while (i < num + 1) {
            if (allTrees[i] != null) {
                res = allTrees[i];
            }
            ++i;
        }
        return res;
    }

    public void writeResultsToCytoscapeFormat(File sifFileName, File edgeAttributeFileName, double distanceCutoff) throws IOException {
        ArrayList labels = this.distanceMatrix.getLabels();
        BufferedWriter brSIF = new BufferedWriter(new FileWriter(sifFileName));
        BufferedWriter brEA = new BufferedWriter(new FileWriter(edgeAttributeFileName));
        brEA.write("ClusterDistance");
        brEA.newLine();
        int i = 0;
        while (i < this.nelements) {
            int j = i;
            while (j < this.nelements) {
                if (this.distanceMatrix.getValue(i, j) <= distanceCutoff && this.distanceMatrix.getValue(i, j) != 0.0) {
                    brSIF.write(labels.get(i) + "\tcl\t" + labels.get(j));
                    brSIF.newLine();
                    brEA.write(labels.get(i) + " (cl) " + labels.get(j) + " = " + this.distanceMatrix.getValue(i, j));
                    brEA.newLine();
                }
                ++j;
            }
            ++i;
        }
        brSIF.close();
        brEA.close();
    }

    public String writeResultsToGTRFormat() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        int i = 0;
        while (i < this.result.length) {
            sb.append("NODE" + (i + 1) + "X" + "\t");
            sb.append(String.valueOf(this.result[i][0] >= 0 ? "GENE" + Math.abs(this.result[i][0]) : "NODE" + Math.abs(this.result[i][0])) + "X" + "\t");
            sb.append(String.valueOf(this.result[i][1] >= 0 ? "GENE" + Math.abs(this.result[i][1]) : "NODE" + Math.abs(this.result[i][1])) + "X" + "\t");
            sb.append(String.valueOf(1.0 - this.linkDistance[i]) + lineSep);
            ++i;
        }
        return sb.toString();
    }

    public void setLabelHighlightInCDTOutput(ArrayList labelsToHighlight, String color) {
        if (this.labelHighlight == null) {
            this.labelHighlight = new ArrayList();
        }
        LabelColorPair lcp = new LabelColorPair(color, labelsToHighlight);
        this.labelHighlight.add(lcp);
    }

    public String toCDTString() {
        int indexi;
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        if (this.labelHighlight != null) {
            sb.append("GID\tUNIQID\tNAME\tBGCOLOR\tGWEIGHT");
        } else {
            sb.append("GID\tUNIQID\tNAME\tGWEIGHT");
        }
        ArrayList labels = this.distanceMatrix.getLabels();
        int i = 0;
        while (i < labels.size()) {
            indexi = this.leafOrder[i];
            sb.append("\t" + (String)labels.get(indexi));
            ++i;
        }
        sb.append(lineSep);
        sb.append("EWEIGHT\t\t\t");
        i = 0;
        while (i < this.nelements) {
            sb.append("\t1.000000");
            ++i;
        }
        sb.append(lineSep);
        i = 0;
        while (i < this.nelements) {
            indexi = this.leafOrder[i];
            sb.append("GENE" + indexi + "X\t" + labels.get(indexi) + "\t" + labels.get(indexi) + "\t");
            if (this.labelHighlight != null) {
                boolean found = false;
                int j = 0;
                while (j < this.labelHighlight.size()) {
                    LabelColorPair labelColorPair = (LabelColorPair)this.labelHighlight.get(j);
                    ArrayList labelsToHighlight = labelColorPair.getLabels();
                    if (labelsToHighlight.contains(labels.get(indexi))) {
                        found = true;
                        sb.append(labelColorPair.getColor());
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    sb.append("#FFFFFF");
                }
            }
            sb.append("\t1.000000");
            int j = 0;
            while (j < this.nelements) {
                int indexj = this.leafOrder[j];
                sb.append("\t" + this.distanceMatrix.getValue(indexi, indexj));
                ++j;
            }
            sb.append(lineSep);
            ++i;
        }
        return sb.toString();
    }

    private class LabelColorPair {
        private String color;
        private ArrayList labels;

        public LabelColorPair(String color, ArrayList labels) {
            this.color = color;
            this.labels = labels;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public ArrayList getLabels() {
            return this.labels;
        }

        public void setLabels(ArrayList labels) {
            this.labels = labels;
        }
    }

    private class Leaf {
        private int index;
        private LeafDist[] curDist;
        private LeafDist[] newDist;
        private double[][] distMat;
        private int listSize;
        private int newSize;
        public double bestNew;

        void setSize(int size) {
            this.listSize = size;
        }

        int giveSize() {
            return this.listSize;
        }

        LeafDist[] giveList() {
            return this.curDist;
        }

        void initNewSize(int nSize) {
            this.newDist = new LeafDist[nSize];
        }

        void initNewDist() {
            this.newDist = null;
        }

        int giveIndex() {
            return this.index;
        }

        public Leaf(int num, double[][] mat) {
            this.index = num;
            this.distMat = mat;
            LeafPair oneLeaf = new LeafPair(this.index, -1, null, null, 1, 0);
            this.curDist = new LeafDist[1];
            this.curDist[0] = new LeafDist(this.index, 0.0, oneLeaf);
            this.listSize = 1;
            this.newDist = null;
            this.newSize = 0;
            this.bestNew = Double.MAX_VALUE;
        }

        void replace() {
            int i = 0;
            while (i < this.listSize) {
                this.curDist[i] = null;
                ++i;
            }
            this.curDist = null;
            this.listSize = this.newSize;
            this.bestNew += 2.0;
            this.curDist = new LeafDist[this.listSize];
            i = 0;
            while (i < this.newSize) {
                this.curDist[i] = this.newDist[i];
                ++i;
            }
            this.newDist = null;
            Arrays.sort(this.curDist);
            this.newSize = 0;
            this.bestNew = Double.MAX_VALUE;
        }

        void addToNew(Leaf[] corner1, Leaf[] corner2, int n1, int n2, int c1, int c2, double max1) {
            double curVal;
            double bestPos;
            int i;
            int fromIndex;
            double[] bestC = new double[AvgLinkHierarchicalClustering.this.nelements + 1];
            int[] bForC = new int[AvgLinkHierarchicalClustering.this.nelements + 1];
            int cForD = 0;
            int dPlace = 0;
            double maxAC = Double.MAX_VALUE;
            int j = 0;
            while (j < c1) {
                fromIndex = corner1[j].giveIndex();
                bestC[fromIndex] = Double.MAX_VALUE;
                i = 0;
                while (i < this.listSize) {
                    bestPos = this.curDist[i].dist + max1;
                    if (bestPos > bestC[fromIndex]) {
                        i = this.listSize;
                    } else {
                        curVal = this.curDist[i].dist + this.distMat[this.curDist[i].n][fromIndex];
                        if (curVal < bestC[fromIndex]) {
                            bestC[fromIndex] = curVal;
                            bForC[fromIndex] = i;
                        }
                    }
                    ++i;
                }
                if (bestC[fromIndex] < maxAC) {
                    maxAC = bestC[fromIndex];
                }
                ++j;
            }
            j = 0;
            while (j < c2) {
                double bestD = Double.MAX_VALUE;
                Leaf curLeaf = corner2[j];
                int fromNum = curLeaf.giveSize();
                fromIndex = curLeaf.giveIndex();
                LeafDist[] fDist = curLeaf.giveList();
                i = 0;
                while (i < fromNum) {
                    bestPos = curLeaf.curDist[i].dist + maxAC;
                    if (bestPos > bestD) {
                        i = fromNum;
                    } else {
                        curVal = bestC[fDist[i].n] + curLeaf.curDist[i].dist;
                        if (curVal < bestD) {
                            bestD = curVal;
                            cForD = curLeaf.curDist[i].n;
                            dPlace = i;
                        }
                    }
                    ++i;
                }
                LeafPair newPair = new LeafPair(this.index, fromIndex, this.curDist[bForC[cForD]].best, fDist[dPlace].best, n1, n2);
                this.newDist[this.newSize] = new LeafDist(fromIndex, bestD, newPair);
                ++this.newSize;
                LeafPair cornerPair = new LeafPair(fromIndex, this.index, fDist[dPlace].best, this.curDist[bForC[cForD]].best, n2, n1);
                curLeaf.addNewDist(this.index, bestD, cornerPair);
                ++j;
            }
            bForC = null;
            bestC = null;
        }

        void addNewDist(int n, double dist, LeafPair p) {
            this.newDist[this.newSize] = new LeafDist(n, dist, p);
            ++this.newSize;
        }

        int findLast(Leaf[] corner1, Leaf[] corner2, int n1, int n2) {
            int size;
            LeafDist[] myDist;
            double best = Double.MAX_VALUE;
            int myInd = 0;
            int bestIndl = 0;
            int bestIndr = 0;
            int mBestl = 0;
            int mBestr = 0;
            LeafPair lpre = null;
            LeafPair rpre = null;
            LeafDist[][] fDist = new LeafDist[n2][];
            int i = 0;
            while (i < n2) {
                fDist[i] = corner2[i].giveList();
                ++i;
            }
            int j = 0;
            while (j < n1) {
                Leaf curLeaf = corner1[j];
                myDist = curLeaf.giveList();
                double myVal = myDist[0].dist;
                myInd = curLeaf.giveIndex();
                i = 0;
                while (i < n2) {
                    double curVal = myVal + fDist[i][0].dist + this.distMat[myInd][corner2[i].giveIndex()];
                    if (best > curVal) {
                        best = curVal;
                        bestIndl = myDist[0].n;
                        bestIndr = fDist[i][0].n;
                        mBestl = myInd;
                        mBestr = corner2[i].giveIndex();
                    }
                    ++i;
                }
                ++j;
            }
            int place = 0;
            i = 0;
            while (i < n2) {
                if (corner2[i].giveIndex() == bestIndr) {
                    size = corner2[i].giveSize();
                    j = 0;
                    while (j < size) {
                        if (fDist[i][j].n == mBestr) {
                            rpre = fDist[i][j].best;
                            j = size;
                        }
                        ++j;
                    }
                    i = n2;
                }
                ++i;
            }
            i = 0;
            while (i < n1) {
                if (corner1[i].giveIndex() == bestIndl) {
                    size = corner1[i].giveSize();
                    myDist = corner1[i].giveList();
                    j = 0;
                    while (j < size) {
                        if (myDist[j].n == mBestl) {
                            lpre = myDist[j].best;
                            j = size;
                        }
                        ++j;
                    }
                    LeafPair newPair = new LeafPair(bestIndl, bestIndr, lpre, rpre, n1, n2);
                    place = i;
                    corner1[i].initNewSize(1);
                    corner1[i].addNewDist(bestIndr, best, newPair);
                    corner1[i].replace();
                    i = n1;
                }
                ++i;
            }
            fDist = null;
            return place;
        }
    }

    private class LeafDist
    implements Comparable {
        public int n;
        public double dist;
        public LeafPair best;

        public LeafDist(int to, double d, LeafPair p) {
            this.n = to;
            this.dist = d;
            this.best = p;
        }

        public int compareTo(Object o) {
            LeafDist ld = (LeafDist)o;
            return (int)(this.dist - ld.dist);
        }
    }

    private class LeafPair {
        private int leftLeaf;
        private int rightLeaf;
        private LeafPair preLeft;
        private LeafPair preRight;
        private int n1;
        private int n2;

        public LeafPair(int l, int r, LeafPair pl, LeafPair pr, int t1, int t2) {
            this.leftLeaf = l;
            this.rightLeaf = r;
            this.preLeft = pl;
            this.preRight = pr;
            this.n1 = t1;
            this.n2 = t2;
        }
    }

    private class Pair {
        public int i = 0;
        public int j = 0;
    }

    private class Tree {
        private Tree left;
        private Tree right;
        private int numLeafs;
        private Leaf[] allLeafs;
        private int nodeNum;
        private double[][] mat;

        public Tree(int index, double[][] m) {
            Leaf myLeaf;
            this.mat = m;
            this.nodeNum = index;
            this.allLeafs = new Leaf[1];
            this.allLeafs[0] = myLeaf = new Leaf(index, this.mat);
            this.numLeafs = 1;
            this.right = null;
            this.left = null;
        }

        public Tree(Tree t1, Tree t2, int nNum) {
            this.nodeNum = nNum;
            this.mat = t1.giveMat();
            int n1 = t1.giveNumLeafs();
            int n2 = t2.giveNumLeafs();
            this.numLeafs = n1 + n2;
            this.allLeafs = new Leaf[this.numLeafs];
            Leaf[] l = t1.giveLeafs();
            int i = 0;
            while (i < n1) {
                this.allLeafs[i] = l[i];
                ++i;
            }
            l = t2.giveLeafs();
            i = 0;
            while (i < n2) {
                this.allLeafs[n1 + i] = l[i];
                ++i;
            }
            this.left = t1;
            this.right = t2;
        }

        int compDist() {
            if (this.numLeafs == 1) {
                return 0;
            }
            this.left.compDist();
            this.right.compDist();
            int n1 = this.left.giveNumLeafs();
            int n2 = this.right.giveNumLeafs();
            if (n1 + n2 == AvgLinkHierarchicalClustering.this.nelements) {
                return this.lastTree(n1, n2);
            }
            if (n1 > 1 && n2 > 1) {
                return this.compDist(n1, n2);
            }
            Leaf[] l1 = this.left.giveLeafs();
            Leaf[] l2 = this.right.giveLeafs();
            int j = 0;
            while (j < n2) {
                l2[j].initNewSize(n1);
                ++j;
            }
            int i = 0;
            while (i < n1) {
                l1[i].initNewSize(n2);
                l1[i].addToNew(l2, l2, n1, n2, n2, n2, Double.MIN_VALUE);
                l1[i].replace();
                ++i;
            }
            j = 0;
            while (j < n2) {
                l2[j].replace();
                ++j;
            }
            return 0;
        }

        int lastTree(int n1, int n2) {
            Leaf[] l1 = this.left.giveLeafs();
            Leaf[] l2 = this.right.giveLeafs();
            int res = l1[0].findLast(l1, l2, n1, n2);
            return res;
        }

        int compDist(int tot1, int tot2) {
            int j4;
            int j3;
            int j;
            Tree t1 = this.left;
            Tree t2 = this.right;
            Tree t1l = t1.left;
            Tree t1r = t1.right;
            Tree t2l = t2.left;
            Tree t2r = t2.right;
            int n1 = t1l.giveNumLeafs();
            int n2 = t1r.giveNumLeafs();
            int n3 = t2l.giveNumLeafs();
            int n4 = t2r.giveNumLeafs();
            Leaf[] l1 = t1l.giveLeafs();
            Leaf[] l2 = t1r.giveLeafs();
            Leaf[] l3 = t2l.giveLeafs();
            Leaf[] l4 = t2r.giveLeafs();
            Leaf[] c2 = t2.giveLeafs();
            double mint1rt2r = 1.0;
            double mint1rt2l = 1.0;
            double mint1lt2r = 1.0;
            double mint1lt2l = 1.0;
            int i = 0;
            while (i < n1) {
                int i1 = l1[i].giveIndex();
                j = 0;
                while (j < n3) {
                    j3 = l3[j].giveIndex();
                    if (this.mat[i1][j3] < mint1rt2r) {
                        mint1rt2r = this.mat[i1][j3];
                    }
                    ++j;
                }
                j = 0;
                while (j < n4) {
                    j4 = l4[j].giveIndex();
                    if (this.mat[i1][j4] < mint1rt2l) {
                        mint1rt2l = this.mat[i1][j4];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < n2) {
                int i2 = l2[i].giveIndex();
                j = 0;
                while (j < n3) {
                    j3 = l3[j].giveIndex();
                    if (this.mat[i2][j3] < mint1lt2r) {
                        mint1lt2r = this.mat[i2][j3];
                    }
                    ++j;
                }
                j = 0;
                while (j < n4) {
                    j4 = l4[j].giveIndex();
                    if (this.mat[i2][j4] < mint1lt2l) {
                        mint1lt2l = this.mat[i2][j4];
                    }
                    ++j;
                }
                ++i;
            }
            j = 0;
            while (j < tot2) {
                c2[j].initNewSize(tot1);
                ++j;
            }
            i = 0;
            while (i < n1) {
                l1[i].initNewSize(tot2);
                l1[i].addToNew(l4, l3, tot1, tot2, n4, n3, mint1lt2l);
                l1[i].addToNew(l3, l4, tot1, tot2, n3, n4, mint1lt2r);
                l1[i].replace();
                ++i;
            }
            i = 0;
            while (i < n2) {
                l2[i].initNewSize(tot2);
                l2[i].addToNew(l4, l3, tot1, tot2, n4, n3, mint1rt2l);
                l2[i].addToNew(l3, l4, tot1, tot2, n3, n4, mint1rt2r);
                l2[i].replace();
                ++i;
            }
            j = 0;
            while (j < tot2) {
                c2[j].replace();
                ++j;
            }
            return 0;
        }

        Object[] returnOrder() {
            int start = this.compDist();
            LeafDist[] myDist = this.allLeafs[start].giveList();
            Double bestDist = new Double(myDist[0].dist);
            LeafPair best = myDist[0].best;
            int[] res = new int[this.numLeafs];
            this.compTree(best.preLeft, res, 0, best.n1 - 1, 1);
            this.compTree(best.preRight, res, best.n1, this.numLeafs - 1, 2);
            Object[] ret = new Object[]{res, bestDist};
            return ret;
        }

        void compTree(LeafPair best, int[] res, int start, int last, int l) {
            if (start == last) {
                res[start] = best.leftLeaf;
                return;
            }
            if (l == 1) {
                this.compTree(best.preLeft, res, start, start + best.n1 - 1, 1);
                this.compTree(best.preRight, res, start + best.n1, last, 2);
            }
            if (l == 2) {
                this.compTree(best.preLeft, res, start + best.n2, last, 2);
                this.compTree(best.preRight, res, start, start + best.n2 - 1, 1);
            }
        }

        double curDist(double[][] m) {
            if (this.numLeafs == 1) {
                return 0.0;
            }
            double d1 = this.left.curDist(m);
            double d2 = this.right.curDist(m);
            int lCorner = this.left.findRight();
            int rCorner = this.right.findLeft();
            return d1 + d2 + m[lCorner][rCorner];
        }

        int findRight() {
            if (this.numLeafs == 1) {
                return this.allLeafs[0].giveIndex();
            }
            return this.right.findRight();
        }

        int findLeft() {
            if (this.numLeafs == 1) {
                return this.allLeafs[0].giveIndex();
            }
            return this.left.findLeft();
        }

        int[] initOrder() {
            int[] res = new int[this.numLeafs + 1];
            this.fillArray(res, 0, this.numLeafs - 1);
            return res;
        }

        void fillArray(int[] array, int s, int l) {
            if (this.numLeafs == 1) {
                array[s] = this.allLeafs[0].giveIndex();
                return;
            }
            int n1 = this.left.giveNumLeafs();
            this.left.fillArray(array, s, s + n1 - 1);
            this.right.fillArray(array, s + n1, l);
        }

        boolean isLeaf() {
            return this.numLeafs == 1;
        }

        int giveIndex() {
            return this.nodeNum;
        }

        double[][] giveMat() {
            return this.mat;
        }

        int giveNumLeafs() {
            return this.numLeafs;
        }

        Leaf[] giveLeafs() {
            return this.allLeafs;
        }
    }
}

