/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.File;
import org.baderlab.brain.ProteinDatabaseSearchParams;

public class BrainParameterSet {
    private File databaseFileName = null;
    private String databaseFormat = null;
    private ProteinDatabaseSearchParams searchParams = null;
    private File profileFileName = null;
    private double scoreThreshold;
    private double scorePercentageThreshold;
    private int numberTopHits;
    private double fuzzFactor;
    private boolean profileSearch;
    private File expressionDataSetFile = null;
    private File samplesOfInterestFile = null;
    private File nodeXrefToAffyIDMappingFile = null;
    private File codonBiasFileName = null;
    private boolean uniquePeptides;
    private boolean uniqueQueryProteinNodes;

    public BrainParameterSet(File databaseFileName, String databaseFormat, ProteinDatabaseSearchParams searchParams, File profileFileName, File codonBiasFileName, double scoreThreshold, double scorePercentageThreshold, int numberTopHits, double fuzzFactor, boolean uniquePeptides, boolean uniqueQueryProteinNodes) {
        this.databaseFileName = databaseFileName;
        this.databaseFormat = databaseFormat;
        this.searchParams = searchParams;
        this.scoreThreshold = scoreThreshold;
        this.profileFileName = profileFileName;
        this.codonBiasFileName = codonBiasFileName;
        this.scorePercentageThreshold = scorePercentageThreshold;
        this.numberTopHits = numberTopHits;
        this.fuzzFactor = fuzzFactor;
        this.profileSearch = true;
        this.uniquePeptides = uniquePeptides;
        this.uniqueQueryProteinNodes = uniqueQueryProteinNodes;
    }

    public BrainParameterSet() {
        this.databaseFileName = null;
        this.databaseFormat = null;
        this.searchParams = new ProteinDatabaseSearchParams(true);
        this.scoreThreshold = 12.0;
        this.scorePercentageThreshold = 100.0;
        this.numberTopHits = 20;
        this.fuzzFactor = 1.0;
        this.uniquePeptides = true;
        this.uniqueQueryProteinNodes = false;
    }

    public BrainParameterSet copy() {
        BrainParameterSet newParam = new BrainParameterSet(this.getDatabaseFileName(), this.getDatabaseFormat(), this.getSearchParams().copy(), this.getProfileFile(), this.getCodonBiasFile(), this.getScoreThreshold(), this.getScorePercentageThreshold(), this.getNumberTopHits(), this.getFuzzFactor(), this.getUniquePeptides(), this.getUniqueQueryProteinNodes());
        return newParam;
    }

    public File getDatabaseFileName() {
        return this.databaseFileName;
    }

    public String getDatabaseFormat() {
        return this.databaseFormat;
    }

    public ProteinDatabaseSearchParams getSearchParams() {
        return this.searchParams;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public File getProfileFile() {
        return this.profileFileName;
    }

    public File getCodonBiasFile() {
        return this.codonBiasFileName;
    }

    public boolean getUniquePeptides() {
        return this.uniquePeptides;
    }

    public boolean getUniqueQueryProteinNodes() {
        return this.uniqueQueryProteinNodes;
    }

    public double getScorePercentageThreshold() {
        return this.scorePercentageThreshold;
    }

    public int getNumberTopHits() {
        return this.numberTopHits;
    }

    public double getFuzzFactor() {
        return this.fuzzFactor;
    }

    public void setDatabaseFileName(File databaseFileName) {
        this.databaseFileName = databaseFileName;
    }

    public void setDatabaseFormat(String databaseFormat) {
        this.databaseFormat = databaseFormat;
    }

    public void setSearchParams(ProteinDatabaseSearchParams searchParams) {
        this.searchParams = searchParams;
    }

    public void setScoreThreshold(double scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }

    public void setProfileFileName(File profileFileName) {
        this.profileFileName = profileFileName;
    }

    public void setCodonBiasFileName(File codonBiasFileName) {
        this.codonBiasFileName = codonBiasFileName;
    }

    public void setUniquePeptides(boolean value) {
        this.uniquePeptides = value;
    }

    public void setUniqueQueryProteinNodes(boolean value) {
        this.uniqueQueryProteinNodes = value;
    }

    public void setScorePercentageThreshold(double scorePercentageThreshold) {
        this.scorePercentageThreshold = scorePercentageThreshold;
    }

    public void setNumberTopHits(int numberTopHits) {
        this.numberTopHits = numberTopHits;
    }

    public void setFuzzFactor(double fuzzFactor) {
        this.fuzzFactor = fuzzFactor;
    }

    public File getExpressionDataSetFile() {
        return this.expressionDataSetFile;
    }

    public void setExpressionDataSetFile(File expressionDataSetFile) {
        this.expressionDataSetFile = expressionDataSetFile;
    }

    public File getSamplesOfInterestFile() {
        return this.samplesOfInterestFile;
    }

    public void setSamplesOfInterestFile(File samplesOfInterestFile) {
        this.samplesOfInterestFile = samplesOfInterestFile;
    }

    public File getNodeXrefToAffyIDMappingFile() {
        return this.nodeXrefToAffyIDMappingFile;
    }

    public void setNodeXrefToAffyIDMappingFile(File nodeXrefToAffyIDMappingFile) {
        this.nodeXrefToAffyIDMappingFile = nodeXrefToAffyIDMappingFile;
    }

    public boolean validateDBOptions() {
        if (this.databaseFileName == null) {
            return false;
        }
        if (this.databaseFormat == null) {
            return false;
        }
        if (this.searchParams == null) {
            return false;
        }
        return this.searchParams.getTerminus() != null;
    }

    public boolean validateProfileOptions() {
        return this.profileFileName != null;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (this.profileSearch) {
            sb.append("Profile search threshold " + this.scoreThreshold + (this.searchParams.isNormalized() ? " (Normalized)" : " (Not Normalized)") + lineSep);
            sb.append("Profile Fuzz Factor: " + this.fuzzFactor + lineSep);
            sb.append("Top " + this.scorePercentageThreshold + " percent of hits." + lineSep);
            sb.append("Codon Bias File: " + (this.codonBiasFileName == null ? "None" : this.codonBiasFileName));
            sb.append("Unique Profile Peptides: " + (this.uniquePeptides ? "Yes" : "No"));
            sb.append("Node Representation: " + (this.uniqueQueryProteinNodes ? "Proteins" : "Domains"));
        }
        sb.append(this.searchParams.toString());
        if (this.databaseFormat != null && this.databaseFileName != null) {
            sb.append(String.valueOf(this.databaseFormat) + " database: " + this.databaseFileName.toString() + lineSep);
        } else {
            if (this.databaseFormat == null) {
                sb.append("Database format not defined." + lineSep);
            }
            if (this.databaseFileName == null) {
                sb.append("Database not defined." + lineSep);
            }
        }
        return sb.toString();
    }
}

