/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.List;
import org.baderlab.brain.DistanceMetric;

public class DistanceMatrix {
    private double[] distanceMatrix = null;
    private int matrixDim = 0;
    private ArrayList labels = null;
    private double minimumDistance = Double.MAX_VALUE;
    private int mini = -1;
    private int minj = -1;

    public DistanceMatrix(int matrixDim) {
        if (matrixDim < 2) {
            throw new RuntimeException("Distance matrix size must be larger than 1");
        }
        this.matrixDim = matrixDim;
        this.distanceMatrix = new double[(matrixDim * matrixDim - 1) / 2];
    }

    public int getMatrixDimension() {
        return this.matrixDim;
    }

    public void setValue(int i, int j, double value) {
        if (j >= i) {
            return;
        }
        this.distanceMatrix[i * (i - 1) / 2 + j] = value;
    }

    public double getValue(int i, int j) {
        if (i == j) {
            return 0.0;
        }
        if (j > i) {
            int oldj = j;
            j = i;
            i = oldj;
        }
        return this.distanceMatrix[i * (i - 1) / 2 + j];
    }

    public void setLabels(ArrayList labels) {
        this.labels = labels;
    }

    public ArrayList getLabels() {
        return this.labels;
    }

    public void calcDistances(List objectList, DistanceMetric distanceMetric) {
        int i = 0;
        while (i < objectList.size()) {
            Object object1 = objectList.get(i);
            int j = 0;
            while (j < i) {
                Object object2 = objectList.get(j);
                double distance = distanceMetric.calc(object1, object2);
                if (distance < this.minimumDistance) {
                    this.minimumDistance = distance;
                    this.mini = i;
                    this.minj = j;
                }
                this.setValue(i, j, distance);
                ++j;
            }
            ++i;
        }
    }

    public double getMinimumDistance() {
        return this.minimumDistance;
    }

    public int getMinimumI() {
        return this.mini;
    }

    public int getMinimumJ() {
        return this.minj;
    }

    public DistanceMatrix copy() {
        DistanceMatrix dm = new DistanceMatrix(this.matrixDim);
        System.arraycopy(this.distanceMatrix, 0, dm.distanceMatrix, 0, this.distanceMatrix.length);
        dm.setLabels(this.getLabels());
        return dm;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        int i = 0;
        while (i < this.labels.size()) {
            sb.append("\t" + (String)this.labels.get(i));
            ++i;
        }
        sb.append(lineSep);
        i = 0;
        while (i < this.matrixDim) {
            sb.append(this.labels.get(i) + "\t");
            int j = 0;
            while (j < i) {
                sb.append(this.getValue(i, j));
                if (j < i) {
                    sb.append("\t");
                }
                ++j;
            }
            sb.append(lineSep);
            ++i;
        }
        return sb.toString();
    }
}

