/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import cytoscape.task.TaskMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.baderlab.brain.AlignmentMatrix;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.HierarchicalClusteringBootstrapResult;
import org.baderlab.brain.HierarchicalClusteringResultTree;
import org.baderlab.brain.LogoSizeSpecification;
import org.baderlab.brain.ProfileAlignment;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceLogo;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.brain.ProteinTerminus;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;

public class LogoTreeDraw {
    private TaskMonitor taskMonitor = null;
    private HierarchicalClusteringResultTree root = null;
    private int totalNumberOfLeaves = 0;
    private double maxDistance = 0.0;
    private List profileList = null;
    private List nodeProfileList = null;
    private AvgLinkHierarchicalClustering cluster = null;
    private int[] leafOrder;
    private int sequenceLogoStartIndex = 1;
    private ArrayList labelHighlight;
    private HierarchicalClusteringBootstrapResult bootstrapResults = null;
    private SymbolStyle symbolStyle;
    public static int LETTER = 1;
    public static int LEGAL = 2;
    private int width;
    private int height;
    private final double leftPadFactor = 0.13;
    private final double rightPadFactor = 0.13;
    private final double logoScaleFactorPercentage = 0.13;
    private double logoScaleFactor;
    private double logoWidthScaleDownFactor = 1.0;
    private int baseLogoHeight;
    private int leftPad;
    private int rightPad;
    private int topPad = 0;
    private String title = null;
    private boolean trimLeafLogo = false;
    private boolean trimNodeLogo = false;
    private double trimLeafLogoPercentage = 0.1;
    private double trimNodeLogoPercentage = 0.1;
    private int nodeLogoProfileLength = 0;
    private ProteinTerminus nodeLogoProfileTerminus = null;
    private int rightMarginXCoord;
    private AlignmentMatrix alignmentMatrix = null;
    private ProfileAlignment profileAlignment = null;

    public LogoTreeDraw(AvgLinkHierarchicalClustering cluster, List profileList, AlignmentMatrix alignmentMatrix) {
        this.root = cluster.getResult();
        this.totalNumberOfLeaves = cluster.getNelements();
        this.maxDistance = cluster.getMaxDistance();
        this.leafOrder = cluster.getLeafOrder();
        this.profileList = profileList;
        this.cluster = cluster;
        this.alignmentMatrix = alignmentMatrix;
        this.nodeProfileList = this.createClusterProfileList(profileList);
        this.setSize(10625, 13750);
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    private void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.baseLogoHeight = (int)(((double)height + (double)height * 0.05) / (double)this.totalNumberOfLeaves);
        this.leftPad = (int)((double)width * 0.13);
        this.rightPad = (int)((double)width * 0.13);
        int maxLogoWidth = this.getMaxLogoWidth();
        double relativeLogoWidthThreshold = 0.2;
        double maxRelativeLogoWidth = (double)maxLogoWidth / (double)width;
        double ratioRelativeWidth = Math.max(1.0, maxRelativeLogoWidth / relativeLogoWidthThreshold);
        this.logoWidthScaleDownFactor = 1.0 / ratioRelativeWidth;
        this.baseLogoHeight = (int)((double)this.baseLogoHeight / ratioRelativeWidth);
        maxLogoWidth = this.getMaxLogoWidth();
        if (maxLogoWidth > this.rightPad) {
            this.rightPad = maxLogoWidth * 2;
        }
        this.logoScaleFactor = Math.max(1.0, (double)height * 0.13 / (double)this.baseLogoHeight * this.logoWidthScaleDownFactor);
        this.rightMarginXCoord = width - this.rightPad;
    }

    public void draw(Graphics2D g) {
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        if (this.title != null) {
            g.setColor(Color.BLACK);
            g.setFont(new Font("Dialog", 1, this.baseLogoHeight));
            FontMetrics f = g.getFontMetrics();
            double titleWidth = f.getStringBounds(this.title, g).getWidth();
            LineMetrics l = f.getLineMetrics(this.title, g);
            double fontScaleFactor = 1.0;
            int availableStringSpace = this.width;
            if (titleWidth > (double)availableStringSpace) {
                fontScaleFactor = (double)availableStringSpace / titleWidth;
                g.setFont(new Font("Dialog", 1, (int)((double)this.baseLogoHeight * fontScaleFactor)));
            }
            g.drawString(this.title, (int)(((double)availableStringSpace - titleWidth * fontScaleFactor) / 2.0), (int)l.getAscent());
            this.topPad = (int)f.getStringBounds(this.title, g).getHeight();
            this.height -= this.topPad;
            this.baseLogoHeight = (int)(((double)this.height + (double)this.height * 0.05) / (double)this.totalNumberOfLeaves);
            int maxLogoWidth = this.getMaxLogoWidth();
            double relativeLogoWidthThreshold = 0.2;
            double maxRelativeLogoWidth = (double)maxLogoWidth / (double)this.width;
            double ratioRelativeWidth = Math.max(1.0, maxRelativeLogoWidth / relativeLogoWidthThreshold);
            this.baseLogoHeight = (int)((double)this.baseLogoHeight / ratioRelativeWidth);
        }
        this.drawNode(this.root, g);
        this.drawLeaves(g);
    }

    public void outputToPDF(File outputFile) {
        Properties p = new Properties();
        p.setProperty("PageSize", "Letter");
        VectorGraphics g = null;
        try {
            g = new PDFGraphics2D(outputFile, new Dimension(this.width, this.height));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        g.setProperties(p);
        g.startExport();
        this.draw(g);
        g.endExport();
    }

    public BufferedImage outputToGraphics() throws OutOfMemoryError {
        this.setSize(2136, 2750);
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D graphics = image.createGraphics();
        this.draw(graphics);
        return image;
    }

    public void outputToPS(File outputFile, int pageSize) {
        if (pageSize == LETTER) {
            this.width = 10625;
            this.height = 13750;
        } else if (pageSize == LEGAL) {
            this.width = 10625;
            this.height = 17500;
        }
        Properties p = new Properties();
        p.setProperty("PageSize", "Letter");
        VectorGraphics g = null;
        try {
            g = new PSGraphics2D(outputFile, new Dimension(this.width, this.height));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        g.setProperties(p);
        g.startExport();
        this.draw(g);
        g.endExport();
    }

    public void setTrimLeafLogo(boolean trimLeafLogo, double percentageLogoHeight) {
        this.trimLeafLogo = trimLeafLogo;
        this.trimLeafLogoPercentage = percentageLogoHeight;
    }

    public void setTrimNodeLogo(boolean trimNodeLogo, double percentageLogoHeight) {
        this.trimNodeLogo = trimNodeLogo;
        this.trimNodeLogoPercentage = percentageLogoHeight;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSequenceLogoStartIndex(int sequenceLogoStartIndex) {
        this.sequenceLogoStartIndex = sequenceLogoStartIndex;
    }

    public void setBootstrapResults(HierarchicalClusteringBootstrapResult bootstrapResults) {
        this.bootstrapResults = bootstrapResults;
    }

    public void setSymbolStyle(SymbolStyle symbolStyle) {
        this.symbolStyle = symbolStyle;
    }

    public void setNodeLogoSubset(int profileLength, ProteinTerminus terminus) {
        this.nodeLogoProfileLength = profileLength;
        this.nodeLogoProfileTerminus = terminus;
    }

    private Color getLeafLabelHighlightColor(String label) {
        int j = 0;
        while (j < this.labelHighlight.size()) {
            LabelColorPair labelColorPair = (LabelColorPair)this.labelHighlight.get(j);
            ArrayList labelsToHighlight = labelColorPair.getLabels();
            if (labelsToHighlight.contains(label)) {
                return labelColorPair.getColor();
            }
            ++j;
        }
        return null;
    }

    public void setLeafLabelHighlightColor(ArrayList labelsToHighlight, Color color) {
        if (this.labelHighlight == null) {
            this.labelHighlight = new ArrayList();
        }
        LabelColorPair lcp = new LabelColorPair(color, labelsToHighlight);
        this.labelHighlight.add(lcp);
    }

    private void drawNode(HierarchicalClusteringResultTree node, Graphics2D g) {
        if (node.leaf) {
            return;
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Drawing node " + node.nodeIndex + " of " + this.nodeProfileList.size());
        }
        int leftY = (int)((node.left.leafOrderIndex + 0.5) / (double)this.totalNumberOfLeaves * (double)this.height);
        leftY += this.topPad;
        int rightY = (int)((node.right.leafOrderIndex + 0.5) / (double)this.totalNumberOfLeaves * (double)this.height);
        rightY += this.topPad;
        int topX = (int)(this.getDistanceScale(node.distance) * (double)(this.width - this.leftPad - this.rightPad) + (double)this.leftPad);
        int bottomLeftX = (int)(this.getDistanceScale(node.left.distance) * (double)(this.width - this.leftPad - this.rightPad) + (double)this.leftPad);
        int bottomRightX = (int)(this.getDistanceScale(node.right.distance) * (double)(this.width - this.leftPad - this.rightPad) + (double)this.leftPad);
        Stroke s = g.getStroke();
        g.setStroke(new BasicStroke(this.height / 1000));
        g.drawPolyline(new int[]{bottomLeftX, topX, topX, bottomRightX}, new int[]{leftY, leftY, rightY, rightY}, 4);
        g.setStroke(s);
        ProteinProfile nodeProfile = (ProteinProfile)this.nodeProfileList.get(node.nodeIndex - 1);
        Point center = new Point(topX, (leftY + rightY) / 2);
        double scaleFactor = this.logoScaleFactor - this.getClusterSizeScale(node.numberOfLeaves) * (this.logoScaleFactor - 1.0) * this.logoWidthScaleDownFactor;
        ProteinSequenceLogo logo = null;
        if (this.nodeLogoProfileLength > 0) {
            int originalProfileLegth = nodeProfile.getNumColumns();
            nodeProfile = nodeProfile.getTruncatedProfileCopy(this.nodeLogoProfileLength, this.nodeLogoProfileTerminus);
            if (this.nodeLogoProfileTerminus.equals(ProteinTerminus.C)) {
                this.sequenceLogoStartIndex += originalProfileLegth - this.nodeLogoProfileLength;
            }
        }
        logo = this.trimNodeLogo ? new ProteinSequenceLogo(nodeProfile, this.trimNodeLogoPercentage, (int)((double)this.baseLogoHeight * scaleFactor)) : new ProteinSequenceLogo(nodeProfile, (int)((double)this.baseLogoHeight * scaleFactor));
        logo.sequenceLogoSetStartIndex(this.sequenceLogoStartIndex);
        if (this.symbolStyle != null) {
            logo.drawSequenceLogo(g, center, this.symbolStyle);
        } else {
            logo.drawSequenceLogo(g, center);
        }
        int logoWidth = logo.getLogoWidth();
        if (topX + logoWidth / 2 > this.width - this.rightPad) {
            this.rightMarginXCoord = Math.max(this.rightMarginXCoord, topX + logoWidth / 2);
        }
        if (this.bootstrapResults != null) {
            int bootstrapCount = this.bootstrapResults.getBootstrapCount(node);
            Color origColor = g.getColor();
            g.setColor(Color.red);
            Font origFont = g.getFont();
            int fontHeight = logo.getLogoHeight() / 2;
            if (fontHeight > this.height / 80) {
                fontHeight = this.height / 80;
            }
            g.setFont(new Font("Dialog", 1, fontHeight));
            g.drawString(Integer.toString(bootstrapCount), center.x - logoWidth / 2, center.y - logo.getLogoHeight() / 2);
            g.setColor(origColor);
            g.setFont(origFont);
        }
        this.drawNode(node.left, g);
        this.drawNode(node.right, g);
    }

    private void drawHighlightRectangle(String label, int x, int y, Graphics2D g) {
        Color c = this.getLeafLabelHighlightColor(label);
        if (c != null) {
            Color oldColor = g.getColor();
            g.setColor(c);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D r = fm.getStringBounds(label, g);
            g.fillRect(x, y - fm.getMaxAscent(), (int)r.getWidth() + 1, fm.getMaxAscent() + 1);
            g.setColor(oldColor);
        }
    }

    private void drawLeaves(Graphics2D g) {
        int maxLogoWidth = this.getMaxLogoWidth();
        maxLogoWidth = (int)((double)maxLogoWidth + (double)maxLogoWidth * 0.05);
        int i = 0;
        while (i < this.leafOrder.length) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setStatus("Drawing leaf " + i + " of " + this.leafOrder.length);
            }
            int leafIndex = this.leafOrder[i];
            ProteinProfile leafProfile = (ProteinProfile)this.profileList.get(leafIndex);
            ProteinSequenceLogo logo = null;
            logo = this.trimLeafLogo ? new ProteinSequenceLogo(leafProfile, this.trimLeafLogoPercentage, this.baseLogoHeight) : new ProteinSequenceLogo(leafProfile, this.baseLogoHeight);
            logo.sequenceLogoSetStartIndex(this.sequenceLogoStartIndex);
            int logoWidth = logo.getLogoWidth();
            LogoSizeSpecification logoSize = logo.getDetailedLogoSizeSpecification();
            int pushRight = (int)((double)logoSize.minColumnIndex * logoSize.columnWidth);
            int alignmentPosition = this.profileAlignment.getAbsoluteAlignmentPosition(leafProfile);
            int alignmentShift = (int)((double)alignmentPosition * logoSize.columnWidth);
            Point center = new Point(this.rightMarginXCoord + logoWidth / 2 + pushRight + alignmentShift, (int)(((double)i + 0.5) / (double)this.totalNumberOfLeaves * (double)this.height) + this.topPad);
            if (this.symbolStyle != null) {
                logo.drawSequenceLogo(g, center, this.symbolStyle);
            } else {
                logo.drawSequenceLogo(g, center);
            }
            String profileName = leafProfile.getName();
            g.setColor(Color.BLACK);
            g.setFont(new Font("Dialog", 0, 10));
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D stringBounds = fm.getStringBounds(profileName, g);
            double fontScaleFactor = 1.0;
            int padBoundsWidth = 20;
            int availableStringWidth = this.width - this.rightMarginXCoord - maxLogoWidth - padBoundsWidth;
            if (stringBounds.getWidth() < (double)availableStringWidth) {
                fontScaleFactor = (double)availableStringWidth / stringBounds.getWidth();
                if (stringBounds.getHeight() * fontScaleFactor > logoSize.logoHeight) {
                    fontScaleFactor = logoSize.logoHeight / stringBounds.getHeight();
                }
            }
            AffineTransform startMatrix = g.getTransform();
            g.scale(fontScaleFactor, fontScaleFactor);
            int xRightJustified = this.rightMarginXCoord + maxLogoWidth + padBoundsWidth;
            int yCenter = (int)(((double)i + 0.5) / (double)this.totalNumberOfLeaves * (double)this.height) + this.topPad;
            LineMetrics l = fm.getLineMetrics(profileName, g);
            yCenter = (int)((double)yCenter + (double)(l.getAscent() / 2.0f) * fontScaleFactor);
            int x = (int)((double)xRightJustified / fontScaleFactor);
            int y = (int)((double)yCenter / fontScaleFactor);
            if (this.labelHighlight != null) {
                this.drawHighlightRectangle(profileName, x, y, g);
            }
            g.drawString(profileName, x, y);
            g.setTransform(startMatrix);
            ++i;
        }
    }

    private int getMaxLogoWidth() {
        int maxLogoWidth = 0;
        int i = 0;
        while (i < this.profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)this.profileList.get(i);
            ProteinSequenceLogo logo = null;
            logo = this.trimLeafLogo ? new ProteinSequenceLogo(proteinProfile, this.trimLeafLogoPercentage, this.baseLogoHeight) : new ProteinSequenceLogo(proteinProfile, this.baseLogoHeight);
            maxLogoWidth = Math.max(maxLogoWidth, logo.getLogoWidth());
            ++i;
        }
        return maxLogoWidth;
    }

    private double getDistanceScale(double distance) {
        return (this.maxDistance - distance) / this.maxDistance;
    }

    private double getClusterSizeScale(int numberOfLeavesAtThisNode) {
        return (double)(this.totalNumberOfLeaves - numberOfLeavesAtThisNode) / (double)this.totalNumberOfLeaves;
    }

    private ArrayList createClusterProfileList(List profileList) {
        ArrayList<String> comboProfileList = new ArrayList<String>(profileList.size());
        int i = 0;
        while (i < profileList.size()) {
            comboProfileList.add(new String("null"));
            ++i;
        }
        HierarchicalClusteringResultTree clusterResult = this.cluster.getResult();
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Aligning profiles");
        }
        this.profileAlignment = new ProfileAlignment((ArrayList)profileList, this.alignmentMatrix);
        this.profileAlignment.run();
        this.collectComboProfiles(clusterResult, profileList, comboProfileList);
        return comboProfileList;
    }

    private void collectComboProfiles(HierarchicalClusteringResultTree node, List profileList, ArrayList comboProfileList) {
        if (!node.leaf) {
            ArrayList childrenLeaves = new ArrayList(node.flatLeftChildrenLeaves);
            childrenLeaves.addAll(node.flatRightChildrenLeaves);
            ArrayList profileListForNode = new ArrayList();
            int i = 0;
            while (i < childrenLeaves.size()) {
                HierarchicalClusteringResultTree leaf = (HierarchicalClusteringResultTree)childrenLeaves.get(i);
                profileListForNode.add(profileList.get(leaf.nodeIndex));
                ++i;
            }
            ProteinProfile comboProfile = null;
            comboProfile = new ProteinProfile(profileListForNode, "Node" + node.nodeIndex, this.profileAlignment);
            comboProfileList.set(node.nodeIndex - 1, comboProfile);
            this.collectComboProfiles(node.left, profileList, comboProfileList);
            this.collectComboProfiles(node.right, profileList, comboProfileList);
        }
    }

    private List rightAlignProfiles(List profileList) {
        ProteinProfile maxProfile = null;
        int maxProfileIndex = -1;
        int maxProfileColumns = 0;
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            int numColumns = proteinProfile.getNumColumns();
            if (numColumns > maxProfileColumns) {
                maxProfileColumns = numColumns;
                maxProfileIndex = i;
            }
            ++i;
        }
        maxProfile = (ProteinProfile)profileList.get(maxProfileIndex);
        Alphabet alphabet = maxProfile.getWeightMatrix().getAlphabet();
        ArrayList alphabetArray = this.get20aaAlphabet();
        ArrayList<ProteinProfile> newProfileList = new ArrayList<ProteinProfile>();
        newProfileList.add(maxProfile);
        int i2 = 0;
        while (i2 < profileList.size()) {
            if (i2 != maxProfileIndex) {
                try {
                    ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i2);
                    SimpleWeightMatrix originalWM = proteinProfile.getWeightMatrix();
                    SimpleWeightMatrix newWM = new SimpleWeightMatrix(alphabet, maxProfileColumns, DistributionFactory.DEFAULT);
                    int deltaColumns = newWM.columns() - originalWM.columns();
                    int j = 0;
                    while (j < newWM.columns()) {
                        Distribution column = newWM.getColumn(j);
                        if (j < deltaColumns) {
                            for (Symbol symbol : alphabetArray) {
                                column.setWeight(symbol, 0.0);
                            }
                        } else {
                            Distribution originalColumn = originalWM.getColumn(j - deltaColumns);
                            for (Symbol symbol : alphabetArray) {
                                column.setWeight(symbol, originalColumn.getWeight(symbol));
                            }
                        }
                        ++j;
                    }
                    ProteinProfile newProfile = new ProteinProfile(newWM, proteinProfile.getName());
                    newProfile.setSequenceMap(proteinProfile.getSequenceMap());
                    newProfileList.add(newProfile);
                }
                catch (IllegalAlphabetException e) {
                    e.printStackTrace();
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
                catch (ChangeVetoException e) {
                    e.printStackTrace();
                }
                catch (BioException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        return newProfileList;
    }

    private ArrayList get20aaAlphabet() {
        ArrayList<Symbol> alphabet = new ArrayList<Symbol>(20);
        HashMap alphabetMap = ProteinSequenceUtil.get20aaAlphabet();
        Collection symbols = alphabetMap.values();
        for (Symbol symbol : symbols) {
            alphabet.add(symbol);
        }
        return alphabet;
    }

    private class LabelColorPair {
        private Color color;
        private ArrayList labels;

        public LabelColorPair(Color color, ArrayList labels) {
            this.color = color;
            this.labels = labels;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public ArrayList getLabels() {
            return this.labels;
        }

        public void setLabels(ArrayList labels) {
            this.labels = labels;
        }
    }
}

