/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.test;

import java.io.File;
import junit.framework.TestCase;
import org.baderlab.brain.BindingPeptideList;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;
import org.baderlab.brain.ProteinTerminus;

public class ProteinProfileTest
extends TestCase {
    ProteinProfile profile1 = null;
    ProteinProfile profile2 = null;
    ProteinDatabaseSearchParams params = null;
    BindingPeptideList peptideList = null;

    public void setUp() throws Exception {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "SH3_pep8.txt");
        this.profile1 = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(4, ProteinTerminus.C), 1.0, new String("testProfile"));
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "PDZ_pep8.txt");
        this.profile2 = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(4, ProteinTerminus.C), 1.0, new String("testProfile"));
    }

    public void testDistanceMetric() {
        ProteinProfileTest.assertEquals((double)0.0, (double)ProteinProfileDistance.calculateDistributionDistance(this.profile1, this.profile1), (double)1.0E-6);
        double d1 = ProteinProfileDistance.calculateDistributionDistance(this.profile1, this.profile2);
        ProteinProfileTest.assertTrue((d1 > 0.0 ? 1 : 0) != 0);
        double d2 = ProteinProfileDistance.calculateDistributionDistance(this.profile2, this.profile1);
        ProteinProfileTest.assertTrue((d1 == d2 ? 1 : 0) != 0);
    }

    public void testNNKCodonBiasReweight() {
        System.out.println(this.profile1.toString());
        this.profile1.reWeightByNNKCodonBias();
        System.out.println();
        System.out.println(this.profile1.toString());
    }
}

