/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.AbstractBeadRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class RectangularBeadRenderer
extends AbstractBeadRenderer {
    public static final ChangeType HEIGHTSCALING = new ChangeType("The height scaling policy of the features has changed", "org.biojava.bio.gui.sequence.RectangularBeadRenderer", "HEIGHTSCALING", SequenceRenderContext.LAYOUT);
    protected Rectangle2D rect = new Rectangle2D.Double();
    protected boolean scaleHeight = true;

    public RectangularBeadRenderer() {
    }

    public RectangularBeadRenderer(double beadDepth, double beadDisplacement, Paint beadOutline, Paint beadFill, Stroke beadStroke) {
        super(beadDepth, beadDisplacement, beadOutline, beadFill, beadStroke);
    }

    public void renderBead(Graphics2D g2, Feature f, SequenceRenderContext context) {
        Location loc = f.getLocation();
        int min = loc.getMin();
        int max = loc.getMax();
        int dif = max - min;
        if (context.getDirection() == 0) {
            double height;
            double posXW = context.sequenceToGraphics(min);
            double posYN = this.beadDisplacement;
            double width = Math.max((double)(dif + 1) * context.getScale(), 1.0);
            if (this.scaleHeight) {
                height = Math.min(this.beadDepth, width / 2.0);
                if (height < this.beadDepth) {
                    posYN += (this.beadDepth - height) / 2.0;
                }
            } else {
                height = this.beadDepth;
            }
            this.rect.setRect(posXW, posYN, Math.floor(width), Math.floor(height));
        } else {
            double width;
            double posXW = this.beadDisplacement;
            double posYN = context.sequenceToGraphics(min);
            double height = Math.max(((double)dif + 1.0) * context.getScale(), 1.0);
            if (this.scaleHeight) {
                width = Math.min(this.beadDepth, height / 2.0);
                if (width < this.beadDepth) {
                    posXW += (this.beadDepth - width) / 2.0;
                }
            } else {
                width = this.beadDepth;
            }
            this.rect.setRect(posXW, posYN, Math.floor(width), Math.floor(height));
        }
        g2.setPaint(this.beadFill);
        g2.fill(this.rect);
        g2.setStroke(this.beadStroke);
        g2.setPaint(this.beadOutline);
        g2.draw(this.rect);
    }

    public double getDepth(SequenceRenderContext context) {
        double maxDepth = super.getDepth(context);
        return Math.max(maxDepth, this.beadDepth + this.beadDisplacement);
    }

    public boolean getHeightScaling() {
        return this.scaleHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeightScaling(boolean isEnabled) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, HEIGHTSCALING, new Boolean(this.scaleHeight), new Boolean(isEnabled)));
                cs.firePreChangeEvent(ce);
                this.scaleHeight = isEnabled;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.scaleHeight = isEnabled;
        }
    }
}

