/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.ssaha.CompactedDataStore;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.DataStoreFactory;
import org.biojava.bio.program.ssaha.SequenceStreamer;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.Constants;

public class CompactedDataStoreFactory
implements DataStoreFactory {
    public DataStore getDataStore(File storeFile) throws IOException {
        return new CompactedDataStore(storeFile);
    }

    public DataStore buildDataStore(File storeFile, SequenceDB seqDB, Packing packing, int wordLength, int threshold) throws IllegalAlphabetException, IOException, BioException {
        return this.buildDataStore(storeFile, new SequenceStreamer.SequenceDBStreamer(seqDB), packing, wordLength, 1, threshold);
    }

    public DataStore buildDataStore(File storeFile, SequenceStreamer streamer, Packing packing, int wordLength, int stepSize, int threshold) throws IllegalAlphabetException, IOException, BioException {
        ByteArrayOutputStream packingStream = new ByteArrayOutputStream();
        ObjectOutputStream packingSerializer = new ObjectOutputStream(packingStream);
        packingSerializer.writeObject(packing);
        packingSerializer.flush();
        int structDataSize = 6 * Constants.BYTES_IN_INT + packingStream.toByteArray().length;
        storeFile.createNewFile();
        RandomAccessFile store = new RandomAccessFile(storeFile, "rw");
        FileChannel channel = store.getChannel();
        int words = 1 << packing.wordSize() * wordLength;
        int hashTablePos = structDataSize;
        int hashTableSize = Constants.BYTES_IN_INT + words * Constants.BYTES_IN_INT;
        if (hashTableSize < words) {
            throw new AssertionFailure("Possible underflow. number of words: " + words + "\tsize of hash table: " + hashTableSize + "\tcompared to Integer.MAX_VALUE " + Integer.MAX_VALUE);
        }
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_WRITE, hashTablePos, hashTableSize);
        IntBuffer hashTable = hashTable_MB.asIntBuffer();
        hashTable.put(0, hashTableSize);
        for (int i = 0; i < words; ++i) {
            hashTable.put(i + 1, 0);
        }
        hashTable.position(0);
        FirstPassListener fpl = new FirstPassListener(packing, wordLength, stepSize, hashTable);
        streamer.reset();
        while (streamer.hasNext()) {
            streamer.streamNext(fpl);
        }
        int nameArrayPos = hashTablePos + hashTableSize;
        int nameArraySize = (fpl.seqCount * 2 + 1) * Constants.BYTES_IN_INT;
        MappedByteBuffer nameArray_MB = channel.map(FileChannel.MapMode.READ_WRITE, nameArrayPos, nameArraySize);
        IntBuffer nameArray = nameArray_MB.asIntBuffer();
        nameArray.put(0, nameArraySize);
        int nameTablePos = nameArrayPos + nameArraySize;
        int nameTableSize = Constants.BYTES_IN_INT + fpl.seqCount * Constants.BYTES_IN_INT + fpl.nameChars * Constants.BYTES_IN_CHAR;
        MappedByteBuffer nameTable = channel.map(FileChannel.MapMode.READ_WRITE, nameTablePos, nameTableSize);
        nameTable.putInt(0, nameTableSize);
        nameTable.position(Constants.BYTES_IN_INT);
        int kmersUsed = 0;
        int hitCount = 0;
        for (int i = 0; i < words; ++i) {
            int counts = hashTable.get(i + 1);
            if (counts <= 0 || counts >= threshold) continue;
            ++hitCount;
            kmersUsed += counts;
        }
        int hitTablePos = nameTablePos + nameTableSize;
        long hitTableSize = (long)Constants.BYTES_IN_INT + (long)kmersUsed * (long)Constants.BYTES_IN_INT + (long)hitCount * (long)Constants.BYTES_IN_INT;
        MappedByteBuffer hitTable = channel.map(FileChannel.MapMode.READ_WRITE, hitTablePos, (int)hitTableSize);
        hitTable.putInt(0, (int)hitTableSize);
        hitTable.position(Constants.BYTES_IN_INT);
        int hitOffset = 0;
        for (int i = 0; i < words; ++i) {
            int counts = hashTable.get(i + 1);
            if (counts > 0 && counts < threshold) {
                try {
                    if (hitOffset < 0) {
                        throw new IndexOutOfBoundsException("Hit offset negative");
                    }
                    hashTable.put(i + 1, hitOffset);
                    hitTable.putInt(hitOffset + Constants.BYTES_IN_INT, 0);
                    hitOffset += Constants.BYTES_IN_INT + counts * Constants.BYTES_IN_INT;
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("counts:\t" + counts);
                    System.out.println("word:\t" + i);
                    System.out.println("hitOffset:\t" + hitOffset);
                    throw e;
                }
            }
            if (counts == 0) {
                hashTable.put(i + 1, -1);
                continue;
            }
            hashTable.put(i + 1, -2);
        }
        SecondPassListener spl = new SecondPassListener(packing, wordLength, stepSize, hashTable, nameArray, nameTable, hitTable);
        streamer.reset();
        while (streamer.hasNext()) {
            streamer.streamNext(spl);
        }
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, structDataSize);
        rootBuffer.position(0);
        rootBuffer.putInt(hashTablePos);
        rootBuffer.putInt(hitTablePos);
        rootBuffer.putInt(nameArrayPos);
        rootBuffer.putInt(nameTablePos);
        rootBuffer.putInt(wordLength);
        rootBuffer.putInt(packingStream.toByteArray().length);
        rootBuffer.put(packingStream.toByteArray());
        rootBuffer.force();
        hashTable_MB.force();
        hitTable.force();
        nameArray_MB.force();
        nameTable.force();
        return this.getDataStore(storeFile);
    }

    private void addCount(IntBuffer buffer, int word) {
        int count = buffer.get(word + 1);
        buffer.put(word + 1, ++count);
    }

    private void writeRecord(IntBuffer hashTable, MappedByteBuffer hitTable, int offset, int seqNumber, int word) {
        int kmerPointer = hashTable.get(word + 1);
        if (kmerPointer >= 0) {
            int hitCount = hitTable.getInt(kmerPointer += Constants.BYTES_IN_INT);
            int pos = kmerPointer + hitCount * Constants.BYTES_IN_INT + Constants.BYTES_IN_INT;
            hitTable.position(pos);
            hitTable.putInt(offset);
            hitTable.putInt(kmerPointer, hitCount + 1);
        }
    }

    private void validateNames(int nameCount, IntBuffer nameArray, MappedByteBuffer nameTable) {
        for (int ni = 0; ni < nameCount; ++ni) {
            int pos = nameArray.get(ni + 1);
            if (pos < 0) {
                throw new Error("Negative pos at index: " + ni);
            }
            int length = nameTable.getInt(Constants.BYTES_IN_INT + pos);
            if (length < 1 || length > 100) {
                throw new Error("Silly sequence length for " + ni + " : " + length);
            }
            StringBuffer buff = new StringBuffer(length);
            for (int ci = 0; ci < length; ++ci) {
                buff.append(nameTable.getChar(Constants.BYTES_IN_INT + pos + Constants.BYTES_IN_INT + Constants.BYTES_IN_CHAR * ci));
            }
            System.out.println(ni + " " + buff);
        }
    }

    private class SecondPassListener
    extends PackingListener {
        private final IntBuffer hashTable;
        private final IntBuffer nameArray;
        private final MappedByteBuffer nameTable;
        private final MappedByteBuffer hitTable;
        private int seqNumber;
        private int concatOffset;
        private String name;
        private int length;

        SecondPassListener(Packing packing, int wordLength, int stepSize, IntBuffer hashTable, IntBuffer nameArray, MappedByteBuffer nameTable, MappedByteBuffer hitTable) {
            super(packing, wordLength, stepSize);
            this.seqNumber = 0;
            this.concatOffset = 0;
            this.name = "";
            this.length = -1;
            if (hashTable == null || nameArray == null || nameTable == null || hitTable == null) {
                throw new NullPointerException("Buffers must not be null. \thashTable: " + hashTable + "\tnameArray: " + nameArray + "\tnameTable: " + nameTable + "\thitTable: " + hitTable);
            }
            this.hashTable = hashTable;
            this.nameArray = nameArray;
            this.nameTable = nameTable;
            this.hitTable = hitTable;
            nameTable.position(Constants.BYTES_IN_INT);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void foundLength(int length) {
            this.length = length;
        }

        public void endSequence() throws ParseException {
            super.endSequence();
            this.nameArray.put(this.seqNumber * 2 + 1, this.nameTable.position() - Constants.BYTES_IN_INT);
            this.nameArray.put(this.seqNumber * 2 + 2, this.concatOffset);
            this.nameTable.putInt(this.name.length());
            for (int j = 0; j < this.name.length(); ++j) {
                this.nameTable.putChar(this.name.charAt(j));
            }
            ++this.seqNumber;
            this.concatOffset += this.length + 100;
        }

        public void processWord(int word, int pos) throws ParseException {
            if (pos < 1) {
                throw new ParseException("pos < 1");
            }
            CompactedDataStoreFactory.this.writeRecord(this.hashTable, this.hitTable, pos + this.concatOffset, this.seqNumber, word);
        }
    }

    private class FirstPassListener
    extends PackingListener {
        private final IntBuffer hashTable;
        int seqCount;
        int nameChars;

        FirstPassListener(Packing packing, int wordLength, int stepSize, IntBuffer hashTable) {
            super(packing, wordLength, stepSize);
            this.seqCount = 0;
            this.nameChars = 0;
            this.hashTable = hashTable;
        }

        public void startSequence() throws ParseException {
            super.startSequence();
            ++this.seqCount;
        }

        public void setName(String name) throws ParseException {
            this.nameChars += name.length();
        }

        public void processWord(int word, int pos) throws ParseException {
            CompactedDataStoreFactory.this.addCount(this.hashTable, word);
        }
    }

    private abstract class PackingListener
    extends SeqIOAdapter {
        private final Packing packing;
        private final int wordLength;
        private final int stepSize;
        private int pos = -1;
        private int word = 0;
        private int lengthFromUnknown = 0;

        public PackingListener(Packing packing, int wordLength, int stepSize) {
            this.packing = packing;
            this.wordLength = wordLength;
            this.stepSize = stepSize;
        }

        public void startSequence() throws ParseException {
            this.pos = 0;
            this.word = 0;
            this.lengthFromUnknown = 0;
        }

        public void endSequence() throws ParseException {
            this.foundLength(this.pos);
            this.pos = -1;
        }

        public void foundLength(int length) throws ParseException {
        }

        public abstract void processWord(int var1, int var2) throws ParseException;

        public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
            if (alpha != this.packing.getAlphabet()) {
                throw new IllegalAlphabetException("Alphabet " + alpha.getName() + " doesn't match packing");
            }
            int stepCounter = this.stepSize;
            for (int i = start; i < start + length; ++i) {
                this.word >>= this.packing.wordSize();
                try {
                    byte p = this.packing.pack(syms[i]);
                    if (p < 0) {
                        this.lengthFromUnknown = 0;
                    } else {
                        ++this.lengthFromUnknown;
                        this.word |= p << (this.wordLength - 1) * this.packing.wordSize();
                    }
                }
                catch (IllegalSymbolException ex) {
                    throw new BioRuntimeException(ex);
                }
                ++this.pos;
                if (--stepCounter != 0) continue;
                stepCounter = this.stepSize;
                if (this.lengthFromUnknown < this.wordLength) continue;
                try {
                    this.processWord(this.word, this.pos - this.wordLength + 1);
                    continue;
                }
                catch (ParseException ex) {
                    throw new BioRuntimeException(ex);
                }
            }
        }
    }
}

