/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;

public class RecentItemTextField
extends JComboBox {
    private int m_minWidth = -1;
    private int m_maxWidth = -1;
    private int m_nItems;
    private String[] m_dropDownItems;
    private String m_key = null;
    private JTextField m_textField;
    private ChangeEvent m_changeEvent = null;
    private Properties m_prop = null;
    private boolean m_clickDefault;
    private MyListener myListener = new MyListener();
    static /* synthetic */ Class class$0;

    public RecentItemTextField() {
        this(null, 4, false);
    }

    public RecentItemTextField(String[] dropDownItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        this.init(dropDownItems);
    }

    public RecentItemTextField(String key, int nItems, boolean clickDefault) {
        this.m_clickDefault = clickDefault;
        Application app = Application.getApplication();
        this.m_prop = app == null ? null : app.getUserProperties();
        this.m_nItems = nItems;
        this.m_key = key;
        this.init(key != null && this.m_prop != null ? PropertyUtilities.getStringArray(this.m_prop, key, null) : null);
    }

    public RecentItemTextField(String key, String lengthKey, boolean clickDefault) {
        this(key, PropertyUtilities.getInteger(Application.getApplication().getUserProperties(), lengthKey, 4), clickDefault);
    }

    private void init(String[] dropDownItems) {
        this.m_dropDownItems = dropDownItems;
        if (this.m_dropDownItems != null) {
            int i = 0;
            while (i < this.m_dropDownItems.length) {
                this.addItem(this.m_dropDownItems[i]);
                ++i;
            }
        }
        this.setEditable(true);
        this.m_textField = (JTextField)this.getEditor().getEditorComponent();
        this.m_textField.addKeyListener(this.myListener);
        this.m_textField.getDocument().addDocumentListener(this.myListener);
    }

    public void addKeyListener(KeyListener kl) {
        if (this.m_textField != null) {
            this.m_textField.addKeyListener(kl);
        }
    }

    public void saveState() {
        if (this.m_key != null && this.m_prop != null) {
            PropertyUtilities.setStringArray(this.m_prop, this.m_key, RecentItemTextField.updateStringArray(this.m_dropDownItems, this.getText(), this.m_nItems));
        }
    }

    public String getText() {
        return this.m_textField.getText();
    }

    public void setText(String s) {
        if (s.equals(this.getItemAt(0))) {
            return;
        }
        this.removeItem(s);
        this.insertItemAt(s, 0);
        this.setSelectedIndex(0);
    }

    private void fireStateChanged() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(clazz);
        int i = listeners.length - 1;
        while (i >= 0) {
            if (this.m_changeEvent == null) {
                this.m_changeEvent = new ChangeEvent(this);
            }
            listeners[i].stateChanged(this.m_changeEvent);
            --i;
        }
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void addActionListener(ActionListener l) {
        this.m_textField.addActionListener(l);
    }

    protected void fireItemStateChanged(ItemEvent event) {
        super.fireItemStateChanged(event);
        this.fireStateChanged();
    }

    public void requestFocus() {
        this.m_textField.requestFocus();
    }

    public void setMaxWidth(int maxWidth) {
        this.m_maxWidth = maxWidth;
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        return d;
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.m_minWidth > 0 && this.m_minWidth > d.width) {
            d.width = this.m_minWidth;
        }
        if (this.m_maxWidth > 0 && this.m_maxWidth < d.width) {
            d.width = this.m_maxWidth;
        }
        return d;
    }

    public static String showInputDialog(Component owner, Object message, String key) {
        return RecentItemTextField.showInputDialog(owner, message, "Input", 3, key);
    }

    public static String showInputDialog(Component owner, Object message, String title, int messageType, String key) {
        RecentItemTextField field = new RecentItemTextField(key, 4, true);
        JPanel mpanel = new JPanel(new BorderLayout());
        if (message instanceof Component) {
            mpanel.add((JComponent)message);
        } else {
            mpanel.add(new JLabel(message.toString()));
        }
        mpanel.add((Component)field, "South");
        int rc = JOptionPane.showOptionDialog(owner, mpanel, title, 2, messageType, null, null, null);
        if (rc == 0) {
            field.saveState();
            return field.getText();
        }
        return null;
    }

    private static String[] updateStringArray(String[] oldArray, String newString, int nStored) {
        if (newString == null) {
            return oldArray;
        }
        if (oldArray != null && oldArray.length > 0) {
            if (oldArray[0].equals(newString)) {
                return oldArray;
            }
            int i = 1;
            while (i < oldArray.length) {
                if (oldArray[i].equals(newString)) {
                    while (i > 0) {
                        oldArray[i] = oldArray[i - 1];
                        --i;
                    }
                    oldArray[0] = newString;
                    return oldArray;
                }
                ++i;
            }
            if (oldArray.length < nStored) {
                String[] result = new String[oldArray.length + 1];
                result[0] = newString;
                int i2 = 0;
                while (i2 < oldArray.length) {
                    result[i2 + 1] = oldArray[i2];
                    ++i2;
                }
                return result;
            }
            i = nStored - 1;
            while (i > 0) {
                oldArray[i] = oldArray[i - 1];
                --i;
            }
            oldArray[0] = newString;
            return oldArray;
        }
        oldArray = new String[]{newString};
        return oldArray;
    }

    public String getKey() {
        return this.m_key;
    }

    public void setKey(String key) {
        this.m_key = key;
        if (key != null && this.m_prop != null) {
            this.init(PropertyUtilities.getStringArray(this.m_prop, key, null));
        }
    }

    public int getNumberOfItems() {
        return this.m_nItems;
    }

    public void setNumberOfItems(int numberOfItems) {
        this.m_nItems = numberOfItems;
    }

    public boolean isClickDefault() {
        return this.m_clickDefault;
    }

    public void setClickDefault(boolean clickDefault) {
        this.m_clickDefault = clickDefault;
    }

    private class MyListener
    implements KeyListener,
    DocumentListener {
        MyListener() {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            JButton b;
            if (e.getSource() != RecentItemTextField.this.m_textField) {
                return;
            }
            if (e.getKeyCode() == 10 && RecentItemTextField.this.m_clickDefault && (b = RecentItemTextField.this.getRootPane().getDefaultButton()) != null) {
                b.doClick();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            RecentItemTextField.this.fireStateChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            RecentItemTextField.this.fireStateChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            RecentItemTextField.this.fireStateChanged();
        }
    }
}

