/*
 * Decompiled with CFR 0.152.
 */
package archive;

import cytoscape.task.TaskMonitor;
import java.awt.EventQueue;
import java.awt.Frame;
import javax.swing.JDialog;

public final class ProgressUIControl
implements TaskMonitor {
    private final boolean[] m_monitor;
    private final JDialog m_dialog;
    private final TaskMonitor m_monitorHook;
    private final Frame m_parent;

    ProgressUIControl(boolean[] monitor, JDialog dialog, TaskMonitor monitorHook, Frame parent) {
        this.m_monitor = monitor;
        this.m_dialog = dialog;
        this.m_monitorHook = monitorHook;
        this.m_parent = parent;
    }

    public void setPercentCompleted(int percent) {
        if (percent < -1 || percent > 100) {
            throw new IllegalArgumentException("percent must be in the range [-1, 100]");
        }
        this.m_monitorHook.setPercentCompleted(percent);
    }

    public void setEstimatedTimeRemaining(long time) {
        this.m_monitorHook.setEstimatedTimeRemaining(time);
    }

    public void setException(Throwable t, String userErrorMessage) {
        this.m_monitorHook.setException(t, userErrorMessage);
    }

    public void setStatus(String message) {
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.m_monitorHook.setStatus(message);
    }

    public void show() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("show() required to be called from the AWT event dispatch thread");
        }
        this.m_dialog.pack();
        this.m_dialog.setLocation((this.m_parent.getSize().width - this.m_dialog.getSize().width) / 2 + this.m_parent.getLocation().x, (this.m_parent.getSize().height - this.m_dialog.getSize().height) / 2 + this.m_parent.getLocation().y);
        this.m_dialog.setVisible(true);
    }

    public void dispose() {
        Runnable dispose = new Runnable(){

            public void run() {
                ((ProgressUIControl)ProgressUIControl.this).m_monitor[0] = false;
                ProgressUIControl.this.m_dialog.dispose();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(dispose);
        } else {
            dispose.run();
        }
    }
}

