/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;

class ImportAttributesTask
implements Task {
    private TaskMonitor taskMonitor;
    private File[] files;
    private int type;
    static final int NODE_ATTRIBUTES = 0;
    static final int EDGE_ATTRIBUTES = 1;

    ImportAttributesTask(File[] files, int type) {
        this.files = files;
        this.type = type;
    }

    public void run() {
        try {
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Reading in Attributes");
            for (int i = 0; i < this.files.length; ++i) {
                this.taskMonitor.setPercentCompleted(100 * i / this.files.length);
                if (this.type == 0) {
                    Cytoscape.loadAttributes(new String[]{this.files[i].getAbsolutePath()}, new String[0]);
                    continue;
                }
                if (this.type == 1) {
                    Cytoscape.loadAttributes(new String[0], new String[]{this.files[i].getAbsolutePath()});
                    continue;
                }
                throw new Exception("Unknown attribute type: " + Integer.toString(this.type));
            }
            this.taskMonitor.setPercentCompleted(100);
            Cytoscape.firePropertyChange(Cytoscape.ATTRIBUTES_CHANGED, null, null);
            this.taskMonitor.setStatus("Done");
        }
        catch (Exception e) {
            this.taskMonitor.setException(e, e.getMessage());
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        if (this.type == 0) {
            return new String("Loading Node Attributes");
        }
        return new String("Loading Edge Attributes");
    }
}

