/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.KeyValue;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class GMLWriter {
    private Set<Integer> newNodes;
    private Set<Integer> newEdges;

    public void writeGML(CyNetwork network, CyNetworkView view, List oldList) {
        this.newNodes = new HashSet<Integer>(network.getNodeCount());
        this.newEdges = new HashSet<Integer>(network.getEdgeCount());
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            this.newNodes.add(new Integer(((Node)it.next()).getRootGraphIndex()));
        }
        it = network.edgesIterator();
        while (it.hasNext()) {
            this.newEdges.add(new Integer(((Edge)it.next()).getRootGraphIndex()));
        }
        KeyValue graph = null;
        KeyValue creator = null;
        KeyValue version = null;
        KeyValue keyVal2 = null;
        for (KeyValue keyVal2 : oldList) {
            if (keyVal2.key.equals(GMLReader.GRAPH)) {
                graph = keyVal2;
                continue;
            }
            if (keyVal2.key.equals(GMLReader.CREATOR)) {
                creator = keyVal2;
                continue;
            }
            if (!keyVal2.key.equals(GMLReader.VERSION)) continue;
            version = keyVal2;
        }
        if (creator == null) {
            creator = new KeyValue(GMLReader.CREATOR, null);
            oldList.add(creator);
        }
        if (version == null) {
            version = new KeyValue(GMLReader.VERSION, null);
            oldList.add(version);
        }
        if (graph == null) {
            graph = new KeyValue(GMLReader.GRAPH, new Vector());
            oldList.add(graph);
        }
        this.writeGraph(network, view, (List)graph.value);
        creator.value = "Cytoscape";
        version.value = new Double(1.0);
        List graph_list = (List)graph.value;
        while (!this.newNodes.isEmpty()) {
            KeyValue nodePair = new KeyValue(GMLReader.NODE, new Vector());
            graph_list.add(nodePair);
            ((List)nodePair.value).add(new KeyValue(GMLReader.ROOT_INDEX, this.newNodes.iterator().next()));
            this.writeGraphNode(network, view, (List)nodePair.value);
        }
        while (!this.newEdges.isEmpty()) {
            KeyValue edgePair = new KeyValue(GMLReader.EDGE, new Vector());
            graph_list.add(edgePair);
            ((List)edgePair.value).add(new KeyValue(GMLReader.ROOT_INDEX, this.newEdges.iterator().next()));
            this.writeGraphEdge(network, view, (List)edgePair.value);
        }
    }

    private void writeGraph(CyNetwork network, CyNetworkView view, List oldList) {
        Iterator it = oldList.iterator();
        while (it.hasNext()) {
            KeyValue keyVal = (KeyValue)it.next();
            if (keyVal.key.equals(GMLReader.NODE)) {
                if (this.writeGraphNode(network, view, (List)keyVal.value)) continue;
                it.remove();
                continue;
            }
            if (!keyVal.key.equals(GMLReader.EDGE) || this.writeGraphEdge(network, view, (List)keyVal.value)) continue;
            it.remove();
        }
    }

    private boolean writeGraphNode(CyNetwork network, CyNetworkView view, List oldList) {
        Integer root_index = null;
        KeyValue graphicsPair = null;
        KeyValue labelPair = null;
        KeyValue idPair = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals(GMLReader.ROOT_INDEX)) {
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(GMLReader.GRAPHICS)) {
                graphicsPair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.LABEL)) {
                labelPair = keyVal;
                continue;
            }
            if (!keyVal.key.equals(GMLReader.ID)) continue;
            idPair = keyVal;
        }
        if (root_index == null) {
            return false;
        }
        Node node = Cytoscape.getRootGraph().getNode(root_index);
        if (!network.containsNode(node)) {
            return false;
        }
        this.newNodes.remove(root_index);
        if (idPair == null) {
            idPair = new KeyValue(GMLReader.ID, null);
            oldList.add(idPair);
        }
        idPair.value = root_index;
        if (view != Cytoscape.getNullNetworkView()) {
            if (graphicsPair == null) {
                graphicsPair = new KeyValue(GMLReader.GRAPHICS, new Vector());
                oldList.add(graphicsPair);
            }
            this.writeGraphNodeGraphics(network, view.getNodeView(node), (List)graphicsPair.value);
        }
        if (labelPair == null) {
            labelPair = new KeyValue(GMLReader.LABEL, null);
            oldList.add(labelPair);
        }
        labelPair.value = node.getIdentifier();
        return true;
    }

    private boolean writeGraphEdge(CyNetwork network, CyNetworkView view, List oldList) {
        Integer root_index = null;
        KeyValue graphicsPair = null;
        KeyValue labelPair = null;
        KeyValue sourcePair = null;
        KeyValue targetPair = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals(GMLReader.GRAPHICS)) {
                graphicsPair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.LABEL)) {
                labelPair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.ROOT_INDEX)) {
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(GMLReader.SOURCE)) {
                sourcePair = keyVal;
                continue;
            }
            if (!keyVal.key.equals(GMLReader.TARGET)) continue;
            targetPair = keyVal;
        }
        if (root_index == null) {
            return false;
        }
        Edge edge = Cytoscape.getRootGraph().getEdge(root_index);
        if (!network.containsEdge(edge)) {
            return false;
        }
        this.newEdges.remove(root_index);
        if (targetPair == null) {
            targetPair = new KeyValue(GMLReader.TARGET, null);
            oldList.add(targetPair);
        }
        targetPair.value = new Integer(edge.getTarget().getRootGraphIndex());
        if (sourcePair == null) {
            sourcePair = new KeyValue(GMLReader.SOURCE, null);
            oldList.add(sourcePair);
        }
        sourcePair.value = new Integer(edge.getSource().getRootGraphIndex());
        if (view != Cytoscape.getNullNetworkView()) {
            if (graphicsPair == null) {
                graphicsPair = new KeyValue(GMLReader.GRAPHICS, new Vector());
            }
            this.writeGraphEdgeGraphics(network, view.getEdgeView(edge), (List)graphicsPair.value);
        }
        if (labelPair == null) {
            labelPair = new KeyValue(GMLReader.LABEL, null);
            oldList.add(labelPair);
        }
        labelPair.value = Cytoscape.getEdgeAttributes().getStringAttribute(edge.getIdentifier(), "interaction");
        return true;
    }

    private void writeGraphNodeGraphics(CyNetwork network, NodeView nodeView, List oldList) {
        KeyValue x = null;
        KeyValue y = null;
        KeyValue w = null;
        KeyValue h = null;
        KeyValue type = null;
        KeyValue fill = null;
        KeyValue outline = null;
        KeyValue outline_width = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals(GMLReader.X)) {
                x = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.Y)) {
                y = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.W)) {
                w = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.H)) {
                h = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.TYPE)) {
                type = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.FILL)) {
                fill = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.OUTLINE)) {
                outline = keyVal;
                continue;
            }
            if (!keyVal.key.equals(GMLReader.OUTLINE_WIDTH)) continue;
            outline_width = keyVal;
        }
        if (x == null) {
            x = new KeyValue(GMLReader.X, null);
            oldList.add(x);
        }
        if (y == null) {
            y = new KeyValue(GMLReader.Y, null);
            oldList.add(y);
        }
        if (w == null) {
            w = new KeyValue(GMLReader.W, null);
            oldList.add(w);
        }
        if (h == null) {
            h = new KeyValue(GMLReader.H, null);
            oldList.add(h);
        }
        if (fill == null) {
            fill = new KeyValue(GMLReader.FILL, null);
            oldList.add(fill);
        }
        if (type == null) {
            type = new KeyValue(GMLReader.TYPE, null);
            oldList.add(type);
        }
        if (outline == null) {
            outline = new KeyValue(GMLReader.OUTLINE, null);
            oldList.add(outline);
        }
        if (outline_width == null) {
            outline_width = new KeyValue(GMLReader.OUTLINE_WIDTH, null);
            oldList.add(outline_width);
        }
        x.value = new Double(nodeView.getXPosition());
        y.value = new Double(nodeView.getYPosition());
        w.value = new Double(nodeView.getWidth());
        h.value = new Double(nodeView.getHeight());
        fill.value = GMLWriter.getColorHexString((Color)nodeView.getUnselectedPaint());
        outline.value = GMLWriter.getColorHexString((Color)nodeView.getBorderPaint());
        outline_width.value = new Double(nodeView.getBorderWidth());
        switch (nodeView.getShape()) {
            case 6: {
                type.value = GMLReader.RECTANGLE;
                break;
            }
            case 2: {
                type.value = GMLReader.ELLIPSE;
                break;
            }
            case 1: {
                type.value = GMLReader.DIAMOND;
                break;
            }
            case 3: {
                type.value = GMLReader.HEXAGON;
                break;
            }
            case 4: {
                type.value = GMLReader.OCTAGON;
                break;
            }
            case 5: {
                type.value = GMLReader.PARALELLOGRAM;
                break;
            }
            case 0: {
                type.value = GMLReader.TRIANGLE;
            }
        }
    }

    private void writeGraphEdgeGraphics(CyNetwork network, EdgeView edgeView, List oldList) {
        KeyValue width = null;
        KeyValue fill = null;
        KeyValue line = null;
        KeyValue type = null;
        KeyValue source_arrow = null;
        KeyValue target_arrow = null;
        for (KeyValue keyVal : oldList) {
            if (keyVal.key.equals(GMLReader.WIDTH)) {
                width = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.FILL)) {
                fill = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.LINE)) {
                line = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.TYPE)) {
                type = keyVal;
                continue;
            }
            if (keyVal.key.equals(GMLReader.SOURCE_ARROW)) {
                source_arrow = keyVal;
                continue;
            }
            if (!keyVal.key.equals(GMLReader.TARGET_ARROW)) continue;
            target_arrow = keyVal;
        }
        if (width == null) {
            width = new KeyValue(GMLReader.WIDTH, null);
            oldList.add(width);
        }
        width.value = new Double(edgeView.getStrokeWidth());
        if (fill == null) {
            fill = new KeyValue(GMLReader.FILL, null);
            oldList.add(fill);
        }
        fill.value = GMLWriter.getColorHexString((Color)edgeView.getUnselectedPaint());
        if (type == null) {
            type = new KeyValue(GMLReader.TYPE, null);
            oldList.add(type);
        }
        switch (edgeView.getLineType()) {
            case 2: {
                type.value = GMLReader.STRAIGHT_LINES;
                break;
            }
            case 1: {
                type.value = GMLReader.CURVED_LINES;
            }
        }
        if (line == null) {
            line = new KeyValue(GMLReader.LINE, null);
            oldList.add(line);
        }
        Point2D[] pointsArray = edgeView.getBend().getDrawPoints();
        Vector<KeyValue> points = new Vector<KeyValue>(pointsArray.length);
        for (int idx = pointsArray.length - 2; idx > 0; --idx) {
            Vector<KeyValue> coords = new Vector<KeyValue>(2);
            coords.add(new KeyValue(GMLReader.X, new Double(pointsArray[idx].getX())));
            coords.add(new KeyValue(GMLReader.Y, new Double(pointsArray[idx].getY())));
            points.add(new KeyValue(GMLReader.POINT, coords));
        }
        line.value = points;
        if (source_arrow == null) {
            source_arrow = new KeyValue(GMLReader.SOURCE_ARROW, null);
            oldList.add(source_arrow);
        }
        source_arrow.value = new Integer(edgeView.getSourceEdgeEnd());
        if (target_arrow == null) {
            target_arrow = new KeyValue(GMLReader.TARGET_ARROW, null);
            oldList.add(target_arrow);
        }
        target_arrow.value = new Integer(edgeView.getTargetEdgeEnd());
    }

    private static String getColorHexString(Color c) {
        return "#" + Integer.toHexString(256 + c.getRed()).substring(1) + Integer.toHexString(256 + c.getGreen()).substring(1) + Integer.toHexString(256 + c.getBlue()).substring(1);
    }
}

