/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.TaskMonitor;
import giny.model.Edge;
import giny.model.Node;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class InteractionWriter {
    public static void writeInteractions(CyNetwork network, Writer writer, TaskMonitor taskMonitor) throws IOException {
        String sif = InteractionWriter.getInteractionString(network, taskMonitor);
        writer.write(sif);
    }

    public static void writeInteractions(CyNetwork network, Writer writer) throws IOException {
        InteractionWriter.writeInteractions(network, writer, null);
    }

    public static String getInteractionString(CyNetwork network) {
        return InteractionWriter.getInteractionString(network, null);
    }

    public static String getInteractionString(CyNetwork network, TaskMonitor taskMonitor) {
        if (network == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        List nodeList = network.nodesList();
        CyAttributes nodeAtts = Cytoscape.getNodeAttributes();
        CyAttributes edgeAtts = Cytoscape.getEdgeAttributes();
        Node[] nodes = nodeList.toArray(new Node[0]);
        for (int i = 0; i < nodes.length; ++i) {
            if (taskMonitor != null) {
                double percent = (double)i / (double)nodes.length * 100.0;
                taskMonitor.setPercentCompleted((int)percent);
            }
            Node node = nodes[i];
            String canonicalName = node.getIdentifier();
            List edges = network.getAdjacentEdgesList(node, true, true, true);
            if (edges.size() == 0) {
                sb.append(canonicalName + lineSep);
                continue;
            }
            for (Edge edge : edges) {
                if (node != edge.getSource()) continue;
                Node target = edge.getTarget();
                String canonicalTargetName = target.getIdentifier();
                String edgeName = edge.getIdentifier();
                String interactionName = edgeAtts.getStringAttribute(edge.getIdentifier(), "interaction");
                if (interactionName == null) {
                    interactionName = "xx";
                }
                sb.append(canonicalName);
                sb.append("\t");
                sb.append(interactionName);
                sb.append("\t");
                sb.append(canonicalTargetName);
                sb.append(lineSep);
            }
        }
        return sb.toString();
    }
}

