/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.view.CyMenus;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoManager {
    private javax.swing.undo.UndoManager undo = new javax.swing.undo.UndoManager();
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();

    public UndoManager(CyMenus menus) {
        JMenuItem undoItem = new JMenuItem(this.undoAction);
        JMenuItem redoItem = new JMenuItem(this.redoAction);
        undoItem.setEnabled(false);
        redoItem.setEnabled(false);
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        menus.getMenuBar().getMenu("Edit").add(undoItem);
        menus.getMenuBar().getMenu("Edit").add(redoItem);
        menus.getMenuBar().getMenu("Edit").add(new JSeparator());
        System.out.println("UndoManager initialized");
    }

    public void addEdit(UndoableEdit edit) {
        this.undo.addEdit(edit);
        this.undoAction.update();
        this.redoAction.update();
        Cytoscape.firePropertyChange("NETWORK_MODIFIED", null, Cytoscape.getCurrentNetwork());
    }

    public void discardAllEdits() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.update();
            UndoManager.this.undoAction.update();
            Cytoscape.firePropertyChange("NETWORK_MODIFIED", "cytoscape.util.UndoManager", Cytoscape.getCurrentNetwork());
        }

        protected void update() {
            if (UndoManager.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", UndoManager.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UndoManager.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            UndoManager.this.redoAction.update();
            Cytoscape.firePropertyChange("NETWORK_MODIFIED", "cytoscape.util.UndoManager", Cytoscape.getCurrentNetwork());
        }

        protected void update() {
            if (UndoManager.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", UndoManager.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

