/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.freehep.util.export.ExportDialog;

public class LegendDialog
extends JDialog {
    private Map legendMap;
    private VisualStyle visualStyle;
    private JPanel jPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JScrollPane jScrollPane1;
    private Component parent;

    public LegendDialog(Dialog parent, VisualStyle vs) {
        super(parent, true);
        this.visualStyle = vs;
        this.parent = parent;
        this.initComponents();
    }

    private JPanel generateLegendPanel() {
        JPanel legend = new JPanel();
        legend.setLayout(new BoxLayout(legend, 1));
        legend.setBackground(Color.white);
        NodeAppearanceCalculator nac = this.visualStyle.getNodeAppearanceCalculator();
        List<Calculator> calcs = nac.getCalculators();
        for (Calculator calc : calcs) {
            if (nac.getNodeSizeLocked() ? calc.getType() == 127 || calc.getType() == 126 : calc.getType() == 4) continue;
            ObjectMapping om = calc.getMapping(0);
            JPanel mleg = om.getLegend(calc.getTypeName(), calc.getType());
            if (om instanceof PassThroughMapping) {
                legend.add((Component)mleg, 0);
                continue;
            }
            legend.add(mleg);
        }
        EdgeAppearanceCalculator eac = this.visualStyle.getEdgeAppearanceCalculator();
        calcs = eac.getCalculators();
        int top = legend.getComponentCount();
        for (Calculator calc : calcs) {
            ObjectMapping om = calc.getMapping(0);
            JPanel mleg = om.getLegend(calc.getTypeName(), calc.getType());
            if (om instanceof PassThroughMapping) {
                legend.add((Component)mleg, top);
                continue;
            }
            legend.add(mleg);
        }
        return legend;
    }

    private void initComponents() {
        this.jPanel1 = this.generateLegendPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jButton1 = new JButton();
        this.jButton1.setText("Export");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.export();
            }
        });
        this.jButton2 = new JButton();
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.jButton1);
        buttonPanel.add(this.jButton2);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.add(this.jScrollPane1);
        containerPanel.add(buttonPanel);
        this.setContentPane(containerPanel);
        this.setPreferredSize(new Dimension(400, 400));
        this.pack();
    }

    private void export() {
        ExportDialog export = new ExportDialog();
        export.showExportDialog(this.parent, "Export legend as ...", this.jPanel1, "export");
    }
}

