/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import BiNGO.BiNGOAnnotationDefaultReader;
import BiNGO.BiNGOOntologyFlatFileReader;
import BiNGO.HypergeometricTestCalculate;
import BiNGO.MultipleTestingCorrection;
import BiNGO.SettingsPanel;
import BiNGO.SignificantFigures;
import cytoscape.CyNetwork;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.baderlab.brain.AlignedProteinSequenceIdentityDistance;
import org.baderlab.brain.AlignmentMatrix;
import org.baderlab.brain.AminoAcidGrouping;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.BrainCurrentParameters;
import org.baderlab.brain.BrainParameterSet;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.DistanceMetric;
import org.baderlab.brain.GenPeptUtil;
import org.baderlab.brain.Hit;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.PeptideChipDesign;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinDatabaseSearch;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;
import org.baderlab.brain.ProteinSequenceLogo;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceSearchResultSet;
import org.baderlab.brain.util.FileReaderUtil;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;

public class BrainAlgorithm {
    private BrainParameterSet params = BrainCurrentParameters.getInstance().getParamsCopy();
    private ProteinDatabaseSearch search = null;
    private TaskMonitor taskMonitor = null;

    public MultiSequenceSearchResultSet runProfileSearch() {
        return this.runProfileSearch(null, null, null);
    }

    public MultiSequenceSearchResultSet runProfileSearch(List profileList, List scoreThresholdList, BrainParameterSet internalParams) {
        MultiSequenceSearchResultSet searchResults;
        block12: {
            searchResults = null;
            if (internalParams == null) {
                internalParams = this.params;
            }
            File codonBiasFile = this.params.getCodonBiasFile();
            boolean uniquePeptides = this.params.getUniquePeptides();
            if (profileList == null) {
                profileList = PeptideToProfileReader.readPeptidesAsProfiles(internalParams.getProfileFile(), internalParams.getFuzzFactor(), codonBiasFile, uniquePeptides, false);
            }
            if (scoreThresholdList == null) {
                scoreThresholdList = new ArrayList<Double>(profileList.size());
                int i = 0;
                while (i < profileList.size()) {
                    scoreThresholdList.add(new Double(internalParams.getScoreThreshold()));
                    ++i;
                }
            }
            try {
                if (internalParams.getDatabaseFileName() != null && internalParams.getDatabaseFormat() != null) {
                    this.search = new ProteinDatabaseSearch(this.params.getDatabaseFileName().toString(), internalParams.getDatabaseFormat());
                    this.search.setTaskMonitor(this.taskMonitor);
                    break block12;
                }
                System.err.println("Database filename or format not specified. Can't continue.");
                return null;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (BioException e) {
                e.printStackTrace();
            }
        }
        try {
            searchResults = this.search.multiProfileSearchDB(profileList, scoreThresholdList, internalParams.getSearchParams());
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        try {
            this.search.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return searchResults;
    }

    public void runAllVsAllProfileDistance(String profileListFileName) {
        String separatorString = "\t";
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile1 = (ProteinProfile)profileList.get(i);
            System.out.print(String.valueOf(proteinProfile1.getName()) + "\t");
            int j = 0;
            while (j < profileList.size()) {
                ProteinProfile proteinProfile2 = (ProteinProfile)profileList.get(j);
                System.out.print(ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2));
                if (j < profileList.size()) {
                    System.out.print("\t");
                }
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }

    public void runPeptideAAByPositionHistogramAnalysis(String profileListFileName, int peptideLength) {
        String aaList = "ACDEFGHIKLMNPQRSTVWYX-";
        long[][] histogram = new long["ACDEFGHIKLMNPQRSTVWYX-".length()][peptideLength];
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), -1, null, 0.0, null, true, false);
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            Collection peptideList = proteinProfile.getSequenceMap();
            for (Sequence sequence : peptideList) {
                String seqString = sequence.seqString();
                int k = 0;
                while (k < seqString.length()) {
                    long[] lArray = histogram["ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(k))];
                    int n = k++;
                    lArray[n] = lArray[n] + 1L;
                }
            }
            ++i;
        }
        System.out.print("\n");
        i = 0;
        while (i < histogram.length) {
            System.out.print(String.valueOf("ACDEFGHIKLMNPQRSTVWYX-".charAt(i)) + "\t");
            int j = 0;
            while (j < histogram[i].length) {
                System.out.print(histogram[i][j]);
                if (j < histogram.length - 1) {
                    System.out.print("\t");
                }
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
    }

    public void runPeptideAAByPositionPairHistogramAnalysis(String profileListFileName, int peptideLength, int position1, int position2) {
        String aaList = "ACDEFGHIKLMNPQRSTVWYX-";
        long[][] histogram = new long["ACDEFGHIKLMNPQRSTVWYX-".length()]["ACDEFGHIKLMNPQRSTVWYX-".length()];
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            Collection peptideList = proteinProfile.getSequenceMap();
            for (Sequence sequence : peptideList) {
                String seqString = sequence.seqString();
                long[] lArray = histogram["ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(position1))];
                int n = "ACDEFGHIKLMNPQRSTVWYX-".indexOf(seqString.charAt(position2));
                lArray[n] = lArray[n] + 1L;
            }
            ++i;
        }
        System.out.print("\n");
        i = 0;
        while (i < histogram.length) {
            System.out.print(String.valueOf("ACDEFGHIKLMNPQRSTVWYX-".charAt(i)) + "\t");
            int j = 0;
            while (j < histogram[i].length) {
                System.out.print(histogram[i][j]);
                if (j < histogram.length - 1) {
                    System.out.print("\t");
                }
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
    }

    public BufferedImage runProfileCluster(String profileListFileName, String logoTreeTitle, File logoTreeOutput, boolean saveToPDF) {
        return this.runProfileCluster(profileListFileName, -1, null, logoTreeTitle, logoTreeOutput, null, null, saveToPDF);
    }

    public LogoTreeDraw runAlignedProfileCluster(String profileListFileName, List profileList, String logoTreeTitle, File logoTreeOutput, double leafTrimFactor, double internalTrimFactor, String leafOrderingMethod, AminoAcidGrouping aaGrouping, boolean saveToPDF) {
        return this.runAlignedProfileCluster(profileListFileName, profileList, -1, null, logoTreeTitle, logoTreeOutput, null, null, leafTrimFactor, internalTrimFactor, leafOrderingMethod, aaGrouping, saveToPDF);
    }

    public BufferedImage runProfileCluster(String profileListFileName, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile, boolean saveToPDF) {
        ArrayList<ProteinProfile> originalProfileList;
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        clusterProfileList = originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true, false);
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            int i = 0;
            while (i < originalProfileList.size()) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, terminus));
                ++i;
            }
            clusterProfileList = cutProfileList;
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            @Override
            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
                return ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, groupingByPosition);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        int i = 0;
        while (i < clusterProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(i);
            al.add(i, proteinProfile.getName());
            ++i;
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(true);
        cluster.run();
        LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList, null);
        ltd.setTrimNodeLogo(true, 0.2);
        ltd.setNodeLogoSubset(profileLength, terminus);
        ltd.setTitle(logoTreeTitle);
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(-9);
        if (saveToPDF) {
            ltd.outputToPDF(logoTreeOutput);
        }
        return ltd.outputToGraphics();
    }

    public LogoTreeDraw runAlignedProfileCluster(String profileListFileName, List profileList, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile, double leafTrimFactor, double internalTrimFactor, String leafOrderingMethod, final AminoAcidGrouping aaGrouping, boolean saveToPDF) throws OutOfMemoryError {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List<ProteinProfile> originalProfileList = null;
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        originalProfileList = profileList == null || profileList.size() == 0 ? PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true, false) : profileList;
        clusterProfileList = originalProfileList;
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            int i = 0;
            while (i < originalProfileList.size()) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, terminus));
                ++i;
            }
            clusterProfileList = cutProfileList;
        }
        AlignmentMatrix alignMatrix = new AlignmentMatrix(clusterProfileList.size());
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        int i = 0;
        while (i < clusterProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(i);
            al.add(i, proteinProfile.getName());
            ++i;
        }
        alignMatrix.setLabels(al);
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Performing profile multiple alignment");
        }
        alignMatrix.calcAlignment(clusterProfileList, aaGrouping.getSelectedGroups());
        alignMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            @Override
            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                return ProteinProfileDistance.calculateOptimalAlignedDistributionDistance(proteinProfile1, proteinProfile2, aaGrouping.getSelectedGroups());
            }
        });
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Clustering profiles");
        }
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(alignMatrix);
        cluster.setSingleLinkage(false);
        cluster.setLeafOrderingMethod(leafOrderingMethod);
        cluster.run();
        LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList, alignMatrix);
        ltd.setTaskMonitor(this.taskMonitor);
        ltd.setTrimNodeLogo(true, internalTrimFactor);
        ltd.setTrimLeafLogo(true, leafTrimFactor);
        ltd.setNodeLogoSubset(profileLength, terminus);
        ltd.setTitle(logoTreeTitle);
        ltd.setSymbolStyle(aaGrouping.getProteinLogoStyle());
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(1);
        if (saveToPDF) {
            ltd.outputToPDF(logoTreeOutput);
        }
        return ltd;
    }

    public void runProfileClusterPositionRange(String profileListFileName, int profileStartColumn, int profileEndColumn, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> singleColumnProfileList = null;
        int maxProfileLength = 0;
        List originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true, false);
        int i = profileStartColumn;
        while (i <= profileEndColumn) {
            singleColumnProfileList = new ArrayList<ProteinProfile>();
            int j = 0;
            while (j < originalProfileList.size()) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(j);
                singleColumnProfileList.add(proteinProfile.getProfileSubsetCopy(Integer.toString(i)));
                maxProfileLength = Math.max(maxProfileLength, proteinProfile.getNumColumns());
                ++j;
            }
            clusterProfileList = singleColumnProfileList;
            DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
            distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

                @Override
                public double calc(Object object1, Object object2) {
                    ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                    ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                    return ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2);
                }
            });
            ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
            int j2 = 0;
            while (j2 < clusterProfileList.size()) {
                ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(j2);
                al.add(j2, proteinProfile.getName());
                ++j2;
            }
            distanceMatrix.setLabels(al);
            AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
            cluster.setOptimalLeafOrdering(true);
            cluster.run();
            LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList, null);
            ltd.setTrimNodeLogo(true, 0.2);
            ltd.setNodeLogoSubset(profileLength, terminus);
            ltd.setTitle(String.valueOf(logoTreeTitle) + "- Position " + (i - maxProfileLength + 1));
            if (leafLabelHighlightFile != null) {
                ArrayList list = null;
                try {
                    list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
            }
            ltd.setSequenceLogoStartIndex(-9);
            ltd.outputToPDF(new File(String.valueOf(logoTreeOutput.toString()) + "_pos" + (i - maxProfileLength + 1) + ".pdf"));
            ++i;
        }
    }

    public void runProfileClusterPosition(String profileListFileName, String filter, int profileLength, ProteinTerminus terminus, String logoTreeTitle, File logoTreeOutput, File leafLabelHighlightFile, File codonBiasFile) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> filteredColumnProfileList = null;
        List originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), 0, null, this.params.getFuzzFactor(), codonBiasFile, true, false);
        filteredColumnProfileList = new ArrayList<ProteinProfile>();
        int j = 0;
        while (j < originalProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(j);
            filteredColumnProfileList.add(proteinProfile.getProfileSubsetCopy(filter));
            ++j;
        }
        clusterProfileList = filteredColumnProfileList;
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            @Override
            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                return ProteinProfileDistance.calculateDistributionDistance(proteinProfile1, proteinProfile2);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        int j2 = 0;
        while (j2 < clusterProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(j2);
            al.add(j2, proteinProfile.getName());
            ++j2;
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(true);
        cluster.run();
        LogoTreeDraw ltd = new LogoTreeDraw(cluster, originalProfileList, null);
        ltd.setNodeLogoSubset(profileLength, terminus);
        ltd.setTitle(String.valueOf(logoTreeTitle) + "- Position " + filter);
        if (leafLabelHighlightFile != null) {
            ArrayList list = null;
            try {
                list = FileReaderUtil.readFileAsLineList(leafLabelHighlightFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ltd.setLeafLabelHighlightColor(list, Color.YELLOW);
        }
        ltd.setSequenceLogoStartIndex(-9);
        ltd.outputToPDF(new File(String.valueOf(logoTreeOutput.toString()) + "_pos" + filter));
    }

    private void writeProfileListToCytoscapeNodeAttributesFile(List originalProfileList, File nodeAttributeFileName) throws IOException {
        BufferedWriter brNA = new BufferedWriter(new FileWriter(nodeAttributeFileName));
        brNA.write("NumberOfPeptides");
        brNA.newLine();
        int i = 0;
        while (i < originalProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
            brNA.write(String.valueOf(proteinProfile.getName()) + " = " + proteinProfile.getNumSequences());
            brNA.newLine();
            ++i;
        }
        brNA.close();
    }

    public void runAllVsAllProfileDistancePairOutput(String profileListFileName) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(0.0);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.params.getProfileFile(), this.params.getFuzzFactor());
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile1 = (ProteinProfile)profileList.get(i);
            int j = 0;
            while (j < profileList.size()) {
                ProteinProfile proteinProfile2 = (ProteinProfile)profileList.get(j);
                System.out.print(String.valueOf(proteinProfile1.getName()) + "_" + proteinProfile2.getName() + "\t");
                System.out.println(ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, "STQN, KRH, DE, FLAMPWIVCY, G"));
                ++j;
            }
            ++i;
        }
    }

    public void runHistogramScoreAnalysis(String profileListFileName, String databaseName, String dbFileFormat, ProteinTerminus term) {
        this.params = new BrainParameterSet();
        this.params.setProfileFileName(new File(profileListFileName));
        this.params.setFuzzFactor(1.0);
        this.params.setDatabaseFileName(new File(databaseName));
        this.params.setDatabaseFormat(dbFileFormat);
        this.params.setScoreThreshold(25.0);
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(term);
        dbparams.setNormalized(true);
        dbparams.setDontSaveSequences(true);
        this.params.setSearchParams(dbparams);
        MultiSequenceSearchResultSet searchResults = this.runProfileSearch();
        Collection results = searchResults.getAllResultSets();
        HashMap<String, int[]> histMap = new HashMap<String, int[]>();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            int[] histogram = sequenceSearchResultSet.getScoreHistogram(25);
            histMap.put(sequenceSearchResultSet.getProfile().getName(), histogram);
        }
        Set keys = histMap.keySet();
        for (String name : keys) {
            System.out.print(name);
            int[] histogram = (int[])histMap.get(name);
            int i = 0;
            while (i < histogram.length) {
                int val = histogram[i];
                System.out.print("\t" + val);
                ++i;
            }
            System.out.println("");
        }
    }

    public List findAutoScoreThreshold(BrainParameterSet inputParams) {
        int maxScoreThreshold = 100;
        BrainParameterSet internalParams = new BrainParameterSet();
        internalParams.setDatabaseFileName(inputParams.getDatabaseFileName());
        internalParams.setDatabaseFormat(inputParams.getDatabaseFormat());
        internalParams.setScoreThreshold(100.0);
        internalParams.setFuzzFactor(inputParams.getFuzzFactor());
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(inputParams.getSearchParams().getTerminus());
        dbparams.setNormalized(inputParams.getSearchParams().isNormalized());
        dbparams.setDontSaveSequences(true);
        internalParams.setSearchParams(dbparams);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(inputParams.getProfileFile(), inputParams.getFuzzFactor());
        Double[] scoreThresholdArray = new Double[profileList.size()];
        MultiSequenceSearchResultSet searchResults = this.runProfileSearch(profileList, null, internalParams);
        Collection results = searchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            int[] histogram = sequenceSearchResultSet.getScoreHistogram(100);
            int cumulativeHitCount = 0;
            int i = 0;
            while (i < histogram.length) {
                int j = histogram[i];
                if (cumulativeHitCount > 1 && j > cumulativeHitCount) {
                    scoreThresholdArray[profileList.indexOf((Object)sequenceSearchResultSet.getProfile())] = new Double(i - 1);
                    break;
                }
                cumulativeHitCount += j;
                ++i;
            }
            if (scoreThresholdArray[profileList.indexOf(sequenceSearchResultSet.getProfile())] != null) continue;
            scoreThresholdArray[profileList.indexOf((Object)sequenceSearchResultSet.getProfile())] = new Double(0.0);
        }
        return Arrays.asList(scoreThresholdArray);
    }

    public void runProteinSequenceSpaceCoverageAnalysis(File proteinsToCluster, File proteinsOfInterest, File failedProteins, String limitToColumns, int numberOfTrials) throws FileNotFoundException, BioException {
        int j;
        int j2;
        boolean report = true;
        BufferedReader brCluster = new BufferedReader(new FileReader(proteinsToCluster));
        SequenceIterator clusterProteins = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brCluster);
        ArrayList<String> clusterProteinSequenceStringList = new ArrayList<String>();
        ArrayList<String> clusterProteinNameList = new ArrayList<String>();
        ArrayList<Sequence> clusterProteinSequenceList = new ArrayList<Sequence>();
        while (clusterProteins.hasNext()) {
            Sequence sequence = clusterProteins.nextSequence();
            clusterProteinSequenceList.add(sequence);
            if (limitToColumns != null) {
                clusterProteinSequenceStringList.add(ProteinSequenceUtil.filterSequenceByColumns(sequence, limitToColumns));
            } else {
                clusterProteinSequenceStringList.add(sequence.seqString());
            }
            clusterProteinNameList.add(sequence.getName());
        }
        BufferedReader brInterest = new BufferedReader(new FileReader(proteinsOfInterest));
        SequenceIterator interestProteins = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brInterest);
        ArrayList<String> interestProteinNameList = new ArrayList<String>();
        while (interestProteins.hasNext()) {
            Sequence sequence = interestProteins.nextSequence();
            interestProteinNameList.add(sequence.getName());
        }
        BufferedReader brFailed = new BufferedReader(new FileReader(failedProteins));
        SequenceIterator failedProteinSequences = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brFailed);
        ArrayList<String> failedProteinNameList = new ArrayList<String>();
        while (failedProteinSequences.hasNext()) {
            Sequence sequence = failedProteinSequences.nextSequence();
            failedProteinNameList.add(sequence.getName());
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProteinSequenceStringList.size());
        distanceMatrix.setLabels(clusterProteinNameList);
        distanceMatrix.calcDistances(clusterProteinSequenceStringList, new AlignedProteinSequenceIdentityDistance());
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.run();
        if (report) {
            System.out.print(cluster.writeResultsToGTRFormat());
            System.out.println();
            cluster.setLabelHighlightInCDTOutput(interestProteinNameList, "#FFFF00");
            cluster.setLabelHighlightInCDTOutput(failedProteinNameList, "#FF0000");
            System.out.print(cluster.toCDTString());
            System.out.println();
        }
        if (report) {
            System.out.println("Number of Clusters\t% Sequences Covered\tLargest Cluster Size\tSmallest Cluster Size");
        }
        double[] sequenceSpaceCoverage = new double[distanceMatrix.getMatrixDimension()];
        int[] mostBiasedClusterAssignment = null;
        int mostBiasedClusterAssignmentLargestCluster = -1;
        int i = 1;
        while (i <= distanceMatrix.getMatrixDimension()) {
            int[] clusterAssignment = cluster.cutTree(i);
            int[] clusterSize = new int[i];
            int[] numberInterestingElementsInCluster = new int[i];
            int largestClusterSize = 0;
            int smallestClusterSize = Integer.MAX_VALUE;
            j2 = 0;
            while (j2 < clusterAssignment.length) {
                int clusterID;
                int n = clusterID = clusterAssignment[j2];
                clusterSize[n] = clusterSize[n] + 1;
                if (interestProteinNameList.contains(distanceMatrix.getLabels().get(j2))) {
                    int n2 = clusterID;
                    numberInterestingElementsInCluster[n2] = numberInterestingElementsInCluster[n2] + 1;
                }
                ++j2;
            }
            int totalSequencesCovered = 0;
            int j3 = 0;
            while (j3 < numberInterestingElementsInCluster.length) {
                int numElements = numberInterestingElementsInCluster[j3];
                if (numElements > 0) {
                    totalSequencesCovered += clusterSize[j3];
                }
                ++j3;
            }
            int indexOfLargestCluster = -1;
            int j4 = 0;
            while (j4 < clusterSize.length) {
                int size = clusterSize[j4];
                if (largestClusterSize < size) {
                    largestClusterSize = size;
                    indexOfLargestCluster = j4;
                }
                smallestClusterSize = Math.min(smallestClusterSize, size);
                ++j4;
            }
            if (largestClusterSize <= interestProteinNameList.size() && mostBiasedClusterAssignment == null) {
                mostBiasedClusterAssignment = new int[clusterAssignment.length];
                System.arraycopy(clusterAssignment, 0, mostBiasedClusterAssignment, 0, clusterAssignment.length);
                mostBiasedClusterAssignmentLargestCluster = indexOfLargestCluster;
            }
            sequenceSpaceCoverage[i - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
            if (report) {
                System.out.println(String.valueOf(i) + "\t" + (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension() + "\t" + largestClusterSize + "\t" + smallestClusterSize);
            }
            ++i;
        }
        if (report) {
            System.out.println();
        }
        ArrayList mostBiasedNameList = new ArrayList();
        int i2 = 0;
        while (i2 < mostBiasedClusterAssignment.length) {
            int clusterIndex = mostBiasedClusterAssignment[i2];
            if (clusterIndex == mostBiasedClusterAssignmentLargestCluster) {
                mostBiasedNameList.add(clusterProteinNameList.get(i2));
            }
            ++i2;
        }
        int k = 1;
        while (k <= distanceMatrix.getMatrixDimension()) {
            int[] clusterAssignment = cluster.cutTree(k);
            int[] clusterSize = new int[k];
            int[] numberInterestingElementsInCluster = new int[k];
            j = 0;
            while (j < clusterAssignment.length) {
                int clusterID;
                int n = clusterID = clusterAssignment[j];
                clusterSize[n] = clusterSize[n] + 1;
                if (mostBiasedNameList.contains(distanceMatrix.getLabels().get(j))) {
                    int n3 = clusterID;
                    numberInterestingElementsInCluster[n3] = numberInterestingElementsInCluster[n3] + 1;
                }
                ++j;
            }
            int totalSequencesCovered = 0;
            j2 = 0;
            while (j2 < numberInterestingElementsInCluster.length) {
                int numElements = numberInterestingElementsInCluster[j2];
                if (numElements > 0) {
                    totalSequencesCovered += clusterSize[j2];
                }
                ++j2;
            }
            sequenceSpaceCoverage[k - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
            ++k;
        }
        if (report) {
            int v = 0;
            while (v < sequenceSpaceCoverage.length) {
                System.out.println(String.valueOf(v + 1) + "\t" + sequenceSpaceCoverage[v]);
                ++v;
            }
        }
        double[] sequenceSpaceCoverageSum = null;
        int i3 = 0;
        while (i3 < numberOfTrials) {
            ArrayList randomSequencelist = this.createRandomSamplingWithoutReplacement(clusterProteinSequenceList, interestProteinNameList.size());
            ArrayList<String> randomSequenceNameList = new ArrayList<String>();
            j = 0;
            while (j < randomSequencelist.size()) {
                Sequence sequence = (Sequence)randomSequencelist.get(j);
                randomSequenceNameList.add(sequence.getName());
                ++j;
            }
            int k2 = 1;
            while (k2 <= distanceMatrix.getMatrixDimension()) {
                int[] clusterAssignment = cluster.cutTree(k2);
                int[] clusterSize = new int[k2];
                int[] numberInterestingElementsInCluster = new int[k2];
                int j5 = 0;
                while (j5 < clusterAssignment.length) {
                    int clusterID;
                    int n = clusterID = clusterAssignment[j5];
                    clusterSize[n] = clusterSize[n] + 1;
                    if (randomSequenceNameList.contains(distanceMatrix.getLabels().get(j5))) {
                        int n4 = clusterID;
                        numberInterestingElementsInCluster[n4] = numberInterestingElementsInCluster[n4] + 1;
                    }
                    ++j5;
                }
                int totalSequencesCovered = 0;
                int j6 = 0;
                while (j6 < numberInterestingElementsInCluster.length) {
                    int numElements = numberInterestingElementsInCluster[j6];
                    if (numElements > 0) {
                        totalSequencesCovered += clusterSize[j6];
                    }
                    ++j6;
                }
                sequenceSpaceCoverage[k2 - 1] = (double)totalSequencesCovered / (double)distanceMatrix.getMatrixDimension();
                ++k2;
            }
            if (sequenceSpaceCoverageSum == null) {
                sequenceSpaceCoverageSum = new double[sequenceSpaceCoverage.length];
            }
            if (!report) {
                int v = 0;
                while (v < sequenceSpaceCoverage.length) {
                    System.out.println(String.valueOf(v + 1) + "\t" + sequenceSpaceCoverage[v]);
                    ++v;
                }
            }
            j = 0;
            while (j < sequenceSpaceCoverage.length) {
                int n = j;
                sequenceSpaceCoverageSum[n] = sequenceSpaceCoverageSum[n] + sequenceSpaceCoverage[j];
                ++j;
            }
            ++i3;
        }
        if (report) {
            double[] sequenceSpaceCoverageAverage = new double[sequenceSpaceCoverageSum.length];
            int i4 = 0;
            while (i4 < sequenceSpaceCoverageSum.length) {
                sequenceSpaceCoverageAverage[i4] = sequenceSpaceCoverageSum[i4] / (double)numberOfTrials;
                System.out.println(String.valueOf(i4 + 1) + "\t" + sequenceSpaceCoverageAverage[i4]);
                ++i4;
            }
        }
    }

    private ArrayList createRandomSamplingWithoutReplacement(ArrayList itemsToSample, int numberOfSamples) {
        if (numberOfSamples > itemsToSample.size()) {
            throw new RuntimeException("Number of samples must be smaller than the size of the list given to sample.");
        }
        if (numberOfSamples == itemsToSample.size()) {
            return itemsToSample;
        }
        ArrayList randomSampling = new ArrayList();
        ArrayList sampleCopy = (ArrayList)itemsToSample.clone();
        int i = 0;
        while (i < numberOfSamples) {
            int randomIndex = (int)Math.round((double)(sampleCopy.size() - 1) * Math.random());
            randomSampling.add(sampleCopy.remove(randomIndex));
            ++i;
        }
        return randomSampling;
    }

    public void clusterProteinSequences(File proteinsToCluster) throws FileNotFoundException, BioException {
        BufferedReader brCluster = new BufferedReader(new FileReader(proteinsToCluster));
        SequenceIterator clusterProteins = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brCluster);
        ArrayList<String> clusterProteinSequenceStringList = new ArrayList<String>();
        ArrayList<String> clusterProteinNameList = new ArrayList<String>();
        ArrayList<Sequence> clusterProteinSequenceList = new ArrayList<Sequence>();
        while (clusterProteins.hasNext()) {
            Sequence sequence = clusterProteins.nextSequence();
            clusterProteinSequenceList.add(sequence);
            clusterProteinSequenceStringList.add(sequence.seqString());
            clusterProteinNameList.add(sequence.getName());
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProteinSequenceStringList.size());
        distanceMatrix.setLabels(clusterProteinNameList);
        distanceMatrix.calcDistances(clusterProteinSequenceStringList, new AlignedProteinSequenceIdentityDistance());
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.run();
        System.out.print(cluster.writeResultsToGTRFormat());
        System.out.println();
        System.out.print(cluster.toCDTString());
        System.out.println();
    }

    public void runFullRegexSearchToCytoscape(String proteinName, String queryDatabaseFileName, ProteinTerminus searchTerminus, int motifLength, String[] regexList, CyNetwork net) {
        ProteinDatabaseSearch search = null;
        try {
            search = new ProteinDatabaseSearch(queryDatabaseFileName, "FASTA"){

                @Override
                public String getIdentifier(Sequence sequence) {
                    return null;
                }
            };
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        SequenceSearchResultSet results = null;
        int i = 0;
        while (i < regexList.length) {
            try {
                ProteinDatabaseSearchParams params = new ProteinDatabaseSearchParams(searchTerminus, motifLength);
                results = search.regexSearchDB(regexList[i], params);
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            DatabaseReference protein = new DatabaseReference("SwissProt", proteinName);
            System.out.println("Found " + results.getNumberSequencesHit() + " matching sequences out of " + results.getNumberOfSequencesSearched() + " for regular expression " + regexList[i] + ".");
            try {
                search.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            ++i;
        }
        SequenceSearchResultSet uniqueResults = results.getUniqueResultsBySequence();
        System.out.println("Found " + uniqueResults.getNumberSequencesHit() + " unique results.");
        System.out.println(uniqueResults);
        System.out.println("\n\n\n");
        PeptideChipDesign chip = null;
        try {
            chip = new PeptideChipDesign("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\Protein chip design\\ecoli_preferredCodons.txt", uniqueResults);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        chip.setDescription("Worm chip");
        System.out.println(chip);
    }

    public BrainParameterSet getParams() {
        return this.params;
    }

    public void setParams(BrainParameterSet params) {
        this.params = params;
    }

    public void cancel() {
        this.search.setCancelled(true);
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    public void writeSequenceLogos(String profileListFileName, String outputDirectory, String codonBiasFileName, double fuzzFactor) {
        File codonBiasFile = null;
        if (codonBiasFileName != null) {
            codonBiasFile = new File(codonBiasFileName);
        }
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(new File(profileListFileName), 0, null, fuzzFactor, codonBiasFile, true, false);
        String outFileName = null;
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            outFileName = new String(String.valueOf(outputDirectory) + File.separator + proteinProfile.getName() + ".png");
            ProteinSequenceLogo logo = new ProteinSequenceLogo(proteinProfile, 240);
            try {
                logo.sequenceLogoSetStartIndex(-9);
                ImageIO.write((RenderedImage)logo.drawSequenceLogo(), "png", new File(outFileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void findOverrepresentedGOTermsForAllPredictedPPIsForAllPossibleProfileClusters(AvgLinkHierarchicalClustering cluster, MultiSequenceSearchResultSet inputSearchResults) {
        HashMap profileLabelStringToEntrezGeneIDStringListMap = new HashMap();
        HashMap<String, String> entrezGeneIDToGeneName = new HashMap<String, String>();
        HashMap<String, String> entrezGeneIDToMotifAndScoreString = new HashMap<String, String>();
        Collection searchResults = inputSearchResults.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : searchResults) {
            Set sequences = sequenceSearchResultSet.getSequences();
            ArrayList<String> entrezGeneIDs = new ArrayList<String>();
            for (Sequence sequence : sequences) {
                Sequence originalDBSequence = sequenceSearchResultSet.getOriginalSequence(sequence);
                DatabaseReference dbRef = GenPeptUtil.getEntrezGeneID(originalDBSequence);
                if (dbRef != null) {
                    String entrezGeneID = dbRef.getDbid();
                    entrezGeneIDs.add(entrezGeneID);
                    if (!entrezGeneIDToGeneName.containsKey(entrezGeneID)) {
                        entrezGeneIDToGeneName.put(entrezGeneID, GenPeptUtil.getGeneName(originalDBSequence));
                    }
                    if (entrezGeneIDToMotifAndScoreString.containsKey(entrezGeneID)) continue;
                    double bestScore = Double.MAX_VALUE;
                    String bestMotif = null;
                    List hits = sequenceSearchResultSet.getHits(sequence);
                    int i = 0;
                    while (i < hits.size()) {
                        Hit hit = (Hit)hits.get(i);
                        if (hit.getScore() < bestScore) {
                            bestScore = hit.getScore();
                            bestMotif = hit.getMatchString();
                        }
                        ++i;
                    }
                    bestScore = BrainAlgorithm.truncateDouble(bestScore, 3);
                    entrezGeneIDToMotifAndScoreString.put(entrezGeneID, String.valueOf(bestMotif) + ":" + bestScore);
                    continue;
                }
                System.out.println("Couldn't find a database reference for " + sequence.getName());
            }
            profileLabelStringToEntrezGeneIDStringListMap.put(sequenceSearchResultSet.getProfile().getName(), entrezGeneIDs);
        }
        int i = 1;
        while (i <= cluster.getNelements()) {
            int[] clusterAssignment = cluster.cutTree(i);
            ArrayList[] clusterIDToProfileLabelStringListArray = new ArrayList[i];
            int j = 0;
            while (j < i) {
                clusterIDToProfileLabelStringListArray[j] = new ArrayList();
                ++j;
            }
            j = 0;
            while (j < clusterAssignment.length) {
                int clusterID = clusterAssignment[j];
                clusterIDToProfileLabelStringListArray[clusterID].add(cluster.getLabel(j));
                ++j;
            }
            Vector[] clusterIDToEntrezGeneIDStringVectorArray = new Vector[i];
            int j2 = 0;
            while (j2 < i) {
                clusterIDToEntrezGeneIDStringVectorArray[j2] = new Vector();
                ++j2;
            }
            j2 = 0;
            while (j2 < i) {
                ArrayList profileLabelList = clusterIDToProfileLabelStringListArray[j2];
                int k = 0;
                while (k < profileLabelList.size()) {
                    String profileLabel = (String)profileLabelList.get(k);
                    ArrayList entrezGeneIDs = (ArrayList)profileLabelStringToEntrezGeneIDStringListMap.get(profileLabel);
                    int l = 0;
                    while (l < entrezGeneIDs.size()) {
                        String entrezGeneID = (String)entrezGeneIDs.get(l);
                        if (!clusterIDToEntrezGeneIDStringVectorArray[j2].contains(entrezGeneID)) {
                            clusterIDToEntrezGeneIDStringVectorArray[j2].add(entrezGeneID);
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j2;
            }
            String clusterCutDirName = "D:\\Gbader\\Code\\PDZ\\data\\PDZ\\PPI Prediction\\ORA\\ClusterBiNGO\\ClusterCutInto" + i + "\\";
            File newDir = new File(clusterCutDirName);
            newDir.mkdirs();
            int j3 = 0;
            while (j3 < i) {
                Vector entrezGeneIDList = clusterIDToEntrezGeneIDStringVectorArray[j3];
                String bingoDir = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005";
                SettingsPanel settingsPanel = new SettingsPanel(bingoDir);
                BiNGOOntologyFlatFileReader readerOntology = null;
                String ontologyFile = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005\\GO_Biological_Process";
                try {
                    readerOntology = new BiNGOOntologyFlatFileReader(new File(ontologyFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Ontology ontology = readerOntology.getOntology();
                HashMap synonymHash = readerOntology.getSynonymHash();
                BiNGOAnnotationDefaultReader readerAnnotation = null;
                String annotationFile = "D:\\Gbader\\Code\\PDZ\\data\\DBs\\BiNGO-data-v1_1_nov2005\\H_sapiens_default";
                try {
                    String idString = "Entrez GeneID";
                    readerAnnotation = new BiNGOAnnotationDefaultReader(new File(annotationFile), synonymHash, (Component)settingsPanel, idString, "Homo Sapiens", "GO Biological Process", "GO");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Annotation annotation = readerAnnotation.getAnnotation();
                Vector selectedNodes = entrezGeneIDList;
                String[] nodes = annotation.getNames();
                Vector<String> allNodes = new Vector<String>();
                int n = 0;
                while (n < nodes.length) {
                    if (nodes[n] != null && nodes[n].length() != 0) {
                        allNodes.add(nodes[n].toUpperCase());
                    }
                    ++n;
                }
                HypergeometricTestCalculate test = new HypergeometricTestCalculate(selectedNodes, allNodes, annotation, ontology);
                test.calculate();
                HashMap testMap = test.getTestMap();
                HashMap mapSmallX = test.getMapSmallX();
                HashMap mapSmallN = test.getMapSmallN();
                int bigX = test.getBigX();
                int bigN = test.getBigN();
                String alphaString = "0.05";
                String correctionString = "Benjamini & Hochberg False Discovery Rate (FDR) correction";
                MultipleTestingCorrection mtc = new MultipleTestingCorrection(alphaString, testMap, correctionString);
                mtc.calculate();
                HashMap correctionMap = mtc.getCorrectionMap();
                try {
                    String testString = "Hypergeometric";
                    String overUnderString = "Over-representation";
                    String dirName = clusterCutDirName;
                    String fileName = "Node" + Integer.toString(j3) + ".txt";
                    String clusterVsString = "Vs. genome";
                    String catString = "Over-represented categories after correction";
                    Vector selectedCanonicalNameVector = selectedNodes;
                    HashMap annotatedGenes = new HashMap();
                    String dateString = DateFormat.getDateInstance().format(new Date());
                    String timeString = DateFormat.getTimeInstance().format(new Date());
                    String NONE = "---";
                    String CATEGORY_BEFORE_CORRECTION = "Overrepresented categories before correction";
                    String CATEGORY_CORRECTION = "Overrepresented categories after correction";
                    File results = new File(dirName, fileName);
                    BufferedWriter output = new BufferedWriter(new FileWriter(results));
                    System.out.println("BiNGO results file: " + results.getPath());
                    output.write("File created with BiNGO (c) on " + dateString + " at " + timeString);
                    output.newLine();
                    output.write(ontology.toString());
                    output.newLine();
                    output.write("Selected ontology file: " + ontologyFile);
                    output.newLine();
                    output.write("Selected annotation file: " + annotationFile);
                    output.newLine();
                    output.write(overUnderString);
                    output.newLine();
                    output.write("Selected statistical test: " + testString);
                    output.newLine();
                    output.write("Selected correction: " + correctionString);
                    output.newLine();
                    output.write("Selected significance level: " + alphaString);
                    output.newLine();
                    output.write("Testing option: " + clusterVsString);
                    output.newLine();
                    output.write("The selected profiles: ");
                    ArrayList arrayList = clusterIDToProfileLabelStringListArray[j3];
                    int l = 0;
                    while (l < arrayList.size()) {
                        String s = (String)arrayList.get(l);
                        output.write(s);
                        if (l < arrayList.size() - 1) {
                            output.write(", ");
                        }
                        ++l;
                    }
                    output.newLine();
                    output.write("The selected predicted binders: ");
                    int n2 = 0;
                    while (n2 < selectedCanonicalNameVector.size()) {
                        int[] nodeClassifications = annotation.getClassifications(selectedCanonicalNameVector.get(n2).toString());
                        int k = 0;
                        while (k < nodeClassifications.length) {
                            String cat = new Integer(nodeClassifications[k]).toString();
                            if (!annotatedGenes.containsKey(cat)) {
                                HashSet catset = new HashSet();
                                annotatedGenes.put(cat, catset);
                            }
                            ((HashSet)annotatedGenes.get(cat)).add(selectedCanonicalNameVector.get(n2).toString());
                            ++k;
                        }
                        output.write(entrezGeneIDToGeneName.get(selectedCanonicalNameVector.get(n2).toString()) + " (" + entrezGeneIDToMotifAndScoreString.get(selectedCanonicalNameVector.get(n2).toString()) + ")");
                        if (n2 < selectedCanonicalNameVector.size() - 1) {
                            output.write(", ");
                        }
                        ++n2;
                    }
                    output.newLine();
                    output.newLine();
                    output.write("Number of genes selected: " + bigX);
                    output.newLine();
                    output.write("Total number of genes in annotation: " + bigN);
                    output.newLine();
                    output.newLine();
                    if (testString.equals(NONE)) {
                        output.write("GO-ID\t# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    } else if (correctionString.equals(NONE)) {
                        output.write("GO-ID\tp-value\t# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    } else {
                        output.write("GO-ID\tp-value\tcorr p-value# selected\t# total\tDescription\tGenes in test set");
                        output.newLine();
                    }
                    HashSet keySet = !testString.equals(NONE) ? new HashSet(testMap.keySet()) : new HashSet(mapSmallX.keySet());
                    Iterator it = keySet.iterator();
                    String[] keyLabels = new String[keySet.size()];
                    int n3 = 0;
                    while (it.hasNext()) {
                        keyLabels[n3] = it.next().toString();
                        ++n3;
                    }
                    String[] ordenedKeySet = !testString.equals(NONE) ? this.orderKeysByPvalues(keyLabels, testMap) : this.orderKeysBySmallX(keyLabels, mapSmallX);
                    boolean ok = true;
                    int n4 = 0;
                    while (n4 < ordenedKeySet.length && ok) {
                        Iterator k;
                        String description;
                        String smallN;
                        String smallX;
                        String termID = ordenedKeySet[n4];
                        String pvalue = "";
                        String correctedPvalue = "";
                        if (!testString.equals(NONE)) {
                            try {
                                pvalue = SignificantFigures.sci_format(testMap.get(new Integer(termID)).toString(), 5);
                            }
                            catch (Exception e) {
                                pvalue = "N/A";
                            }
                        } else {
                            pvalue = "N/A";
                        }
                        if (!correctionString.equals(NONE)) {
                            try {
                                correctedPvalue = SignificantFigures.sci_format(correctionMap.get(termID).toString(), 5);
                            }
                            catch (Exception e) {
                                correctedPvalue = "N/A";
                            }
                        } else {
                            correctedPvalue = "N/A";
                        }
                        try {
                            smallX = mapSmallX.get(new Integer(termID)).toString();
                        }
                        catch (Exception e) {
                            smallX = "N/A";
                        }
                        try {
                            smallN = mapSmallN.get(new Integer(termID)).toString();
                        }
                        catch (Exception e) {
                            smallN = "N/A";
                        }
                        try {
                            description = ontology.getTerm(Integer.parseInt(termID)).getName();
                        }
                        catch (Exception e) {
                            description = "?";
                        }
                        if (testString.equals(NONE)) {
                            output.write(String.valueOf(termID) + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                            if (annotatedGenes.containsKey(termID)) {
                                k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                while (k.hasNext()) {
                                    output.write(k.next().toString());
                                    if (!k.hasNext()) continue;
                                    output.write(124);
                                }
                            }
                            output.write("\n");
                        } else if (correctionString.equals(NONE)) {
                            if (catString.equals(CATEGORY_BEFORE_CORRECTION)) {
                                if (new BigDecimal(testMap.get(new Integer(ordenedKeySet[n4])).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                    output.write(String.valueOf(termID) + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                    if (annotatedGenes.containsKey(termID)) {
                                        k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                        while (k.hasNext()) {
                                            output.write(k.next().toString());
                                            if (!k.hasNext()) continue;
                                            output.write(124);
                                        }
                                    }
                                    output.newLine();
                                } else {
                                    ok = false;
                                }
                            } else {
                                output.write(String.valueOf(termID) + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                if (annotatedGenes.containsKey(termID)) {
                                    k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                    while (k.hasNext()) {
                                        output.write(k.next().toString());
                                        if (!k.hasNext()) continue;
                                        output.write(124);
                                    }
                                }
                                output.write("\n");
                            }
                        } else if (catString.equals(CATEGORY_CORRECTION)) {
                            if (new BigDecimal(correctionMap.get(ordenedKeySet[n4]).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                output.write(String.valueOf(termID) + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                if (annotatedGenes.containsKey(termID)) {
                                    k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                    while (k.hasNext()) {
                                        output.write((String)entrezGeneIDToGeneName.get(k.next().toString()));
                                        if (!k.hasNext()) continue;
                                        output.write(124);
                                    }
                                }
                                output.newLine();
                            } else {
                                ok = false;
                            }
                        } else if (catString.equals(CATEGORY_BEFORE_CORRECTION)) {
                            if (new BigDecimal(testMap.get(new Integer(ordenedKeySet[n4])).toString()).compareTo(new BigDecimal(alphaString)) < 0) {
                                output.write(String.valueOf(termID) + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                                if (annotatedGenes.containsKey(termID)) {
                                    k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                    while (k.hasNext()) {
                                        output.write(k.next().toString());
                                        if (!k.hasNext()) continue;
                                        output.write(124);
                                    }
                                }
                                output.newLine();
                            } else {
                                ok = false;
                            }
                        } else {
                            output.write(String.valueOf(termID) + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                            if (annotatedGenes.containsKey(termID)) {
                                k = ((HashSet)annotatedGenes.get(termID)).iterator();
                                while (k.hasNext()) {
                                    output.write((String)entrezGeneIDToGeneName.get(k.next().toString()));
                                    if (!k.hasNext()) continue;
                                    output.write(124);
                                }
                            }
                            output.newLine();
                        }
                        ++n4;
                    }
                    output.close();
                }
                catch (Exception e) {
                    System.out.println("Error: " + e);
                }
                ++j3;
            }
            ++i;
        }
    }

    private static double truncateDouble(double inputDouble, int numberSignificantDigits) {
        double returnDouble = inputDouble * Math.pow(10.0, numberSignificantDigits);
        returnDouble = Math.rint(returnDouble);
        return returnDouble / Math.pow(10.0, numberSignificantDigits);
    }

    public String[] orderKeysByPvalues(String[] labels, HashMap testMap) {
        int i = 1;
        while (i < labels.length) {
            int j = i;
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(testMap.get(new Integer(labels[i])).toString());
            while (j > 0 && val.compareTo(new BigDecimal(testMap.get(new Integer(labels[j - 1])).toString())) < 0) {
                labels[j] = labels[j - 1];
                --j;
            }
            labels[j] = insert_label;
            ++i;
        }
        return labels;
    }

    public String[] orderKeysBySmallX(String[] labels, HashMap mapSmallX) {
        int i = 1;
        while (i < labels.length) {
            int j = i;
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(mapSmallX.get(new Integer(labels[i])).toString());
            while (j > 0 && val.compareTo(new BigDecimal(mapSmallX.get(new Integer(labels[j - 1])).toString())) > 0) {
                labels[j] = labels[j - 1];
                --j;
            }
            labels[j] = insert_label;
            ++i;
        }
        return labels;
    }

    public double calculateSpecificityScoreCorrectionFactor(String codonBiasFileName) {
        File codonBiasFile = null;
        if (codonBiasFileName != null) {
            codonBiasFile = new File(codonBiasFileName);
        }
        String aaList = "ACDEFGHIKLMNPQRSTVWYX";
        double[] codonBias = new double["ACDEFGHIKLMNPQRSTVWYX".length()];
        try {
            BufferedReader br = new BufferedReader(new FileReader(codonBiasFile));
            String fileLine = null;
            while ((fileLine = br.readLine()) != null) {
                String[] aaBiasString = fileLine.split("\\t");
                if (aaBiasString.length == 2) {
                    String residue = aaBiasString[0];
                    codonBias["ACDEFGHIKLMNPQRSTVWYX".indexOf((String)residue)] = Double.parseDouble(aaBiasString[1]);
                    continue;
                }
                System.out.println("Codon bias file is malformed.  Expecting two tab-delimited columns, but found " + fileLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double sum = 0.0;
        int i = 0;
        while (i < codonBias.length) {
            double bias = codonBias[i];
            sum += bias;
            ++i;
        }
        i = 0;
        while (i < codonBias.length) {
            codonBias[i] = codonBias[i] / sum;
            ++i;
        }
        double information = Math.log(20.0) / Math.log(2.0);
        int i2 = 0;
        while (i2 < codonBias.length) {
            double p = codonBias[i2];
            if (p != 0.0) {
                double lp = Math.log(p);
                information -= -p * lp / Math.log(2.0);
            }
            ++i2;
        }
        return Math.pow(2.0, information);
    }

    public void calculateSpecificityScoreForAllProfiles(String profileListFileName, String codonBiasFileName, int profileLength, ProteinTerminus terminus) {
        double specificityScoreCorrectionFactor = this.calculateSpecificityScoreCorrectionFactor(codonBiasFileName);
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(new File(profileListFileName), profileLength, terminus, 0.0, null, true, false);
        System.out.println(specificityScoreCorrectionFactor);
        System.out.println("PDZ\t-9\t-8\t-7\t-6\t-5\t-4\t-3\t-2\t-1\tFull Profile\tEffective Specificity Residues\tNumber of Peptides");
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            System.out.print(String.valueOf(proteinProfile.getName()) + "\t");
            double profileSpecificityScore = 1.0;
            int j = 0;
            while (j < proteinProfile.getNumColumns()) {
                ProteinProfile subsetPosition = proteinProfile.getProfileSubsetCopy(Integer.toString(j));
                double correctedPositionSpecificityScore = subsetPosition.calculateSpecificityScore() - specificityScoreCorrectionFactor;
                if (correctedPositionSpecificityScore < 1.0) {
                    correctedPositionSpecificityScore = 1.0;
                }
                profileSpecificityScore *= correctedPositionSpecificityScore;
                System.out.print(String.valueOf(correctedPositionSpecificityScore) + "\t");
                ++j;
            }
            System.out.println(String.valueOf(profileSpecificityScore) + "\t" + Math.log(profileSpecificityScore) / Math.log(20.0) + "\t" + proteinProfile.getNumSequences());
            ++i;
        }
    }

    public static void main(String[] args) {
        BrainAlgorithm alg = new BrainAlgorithm();
    }

    private static void GoORAAnalysis(BrainAlgorithm alg) {
        ArrayList<ProteinProfile> originalProfileList;
        BrainParameterSet params = new BrainParameterSet();
        params.setProfileFileName(new File("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\BindingProfiles\\Human\\ProfileDataSets-ProjectFiles\\ProjectFile.txt"));
        params.setFuzzFactor(1.0);
        params.setDatabaseFileName(new File("D:\\Gbader\\Code\\PDZ\\data\\DBs\\refseq_May16_2005_human.protein.gpff"));
        params.setDatabaseFormat("genpept");
        ProteinDatabaseSearchParams dbparams = new ProteinDatabaseSearchParams(ProteinTerminus.C);
        dbparams.setNormalized(true);
        params.setSearchParams(dbparams);
        alg.setParams(params);
        System.out.println("Searching...");
        MultiSequenceSearchResultSet searchResults = alg.runProfileSearch(null, alg.findAutoScoreThreshold(params), params);
        System.out.println("Clustering...");
        ArrayList<ProteinProfile> clusterProfileList = null;
        ArrayList<ProteinProfile> cutProfileList = null;
        params.setFuzzFactor(0.0);
        clusterProfileList = originalProfileList = PeptideToProfileReader.readPeptidesAsProfiles(params.getProfileFile(), 0, null, params.getFuzzFactor(), new File("D:\\Gbader\\Code\\PDZ\\data\\PDZ\\BindingProfiles\\Human\\PhageCodonBias\\phageLibraryNNKTheoreticalCodonBias.txt"), true, false);
        int profileLength = 4;
        if (profileLength > 0) {
            cutProfileList = new ArrayList<ProteinProfile>();
            int i = 0;
            while (i < originalProfileList.size()) {
                ProteinProfile proteinProfile = (ProteinProfile)originalProfileList.get(i);
                cutProfileList.add(proteinProfile.getTruncatedProfileCopy(profileLength, ProteinTerminus.C));
                ++i;
            }
            clusterProfileList = cutProfileList;
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(clusterProfileList.size());
        distanceMatrix.calcDistances(clusterProfileList, new DistanceMetric(){

            @Override
            public double calc(Object object1, Object object2) {
                ProteinProfile proteinProfile1 = (ProteinProfile)object1;
                ProteinProfile proteinProfile2 = (ProteinProfile)object2;
                String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
                return ProteinProfileDistance.calculateAAGroupedDistributionDistance(proteinProfile1, proteinProfile2, groupingByPosition);
            }
        });
        ArrayList<String> al = new ArrayList<String>(clusterProfileList.size());
        int i = 0;
        while (i < clusterProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)clusterProfileList.get(i);
            al.add(i, proteinProfile.getName());
            ++i;
        }
        distanceMatrix.setLabels(al);
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(distanceMatrix);
        cluster.setOptimalLeafOrdering(false);
        cluster.run();
        System.out.println("Running ORA...");
        alg.findOverrepresentedGOTermsForAllPredictedPPIsForAllPossibleProfileClusters(cluster, searchResults);
    }
}

