/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.Serializable;
import org.baderlab.brain.ProteinProfile;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class NormalizedProfileAnnotator
implements SequenceAnnotator,
Serializable {
    private ProteinProfile profile;
    private WeightMatrix matrix;
    private double threshold;
    private final ScoreType scoreType;

    @Override
    public Sequence annotate(Sequence seq) throws IllegalAlphabetException, BioException, ChangeVetoException {
        seq = new ViewSequence(seq);
        int cols = this.matrix.columns();
        Feature.Template template = new Feature.Template();
        template.source = "NormalizedProfileAnnotator";
        int offset = 1;
        while (offset <= seq.length() - cols + 1) {
            double score = DP.scoreWeightMatrix(this.matrix, seq, this.scoreType, offset);
            double qraw = Math.exp(score);
            double q = this.profile.getNormalizedPValue(qraw);
            if (q > 1.0) {
                q = 1.0;
            }
            if (q >= this.threshold) {
                template.location = new RangeLocation(offset, offset + cols - 1);
                SimpleAnnotation ann = new SimpleAnnotation();
                ann.setProperty("score", new Double(q));
                ann.setProperty("raw_score", new Double(qraw));
                template.annotation = ann;
                seq.createFeature(template);
            }
            ++offset;
        }
        return seq;
    }

    public NormalizedProfileAnnotator(ProteinProfile profile, double threshold) {
        this.profile = profile;
        this.matrix = profile.getWeightMatrix();
        this.threshold = threshold;
        this.scoreType = ScoreType.PROBABILITY;
    }
}

