/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.Iterator;
import org.baderlab.brain.AminoAcidGrouping;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.SimilarityMatrix;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class ProteinProfileDistance {
    private static ArrayList get20aaAlphabet() {
        ArrayList<Symbol> alphabet = new ArrayList<Symbol>(20);
        FiniteAlphabet symbols = ProteinTools.getAlphabet();
        Iterator symbolIterator = symbols.iterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol = (Symbol)symbolIterator.next();
            String symbolString = null;
            try {
                symbolString = symbols.getTokenization("token").tokenizeSymbol(symbol);
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            if (symbolString.equals("U")) continue;
            alphabet.add(symbol);
        }
        return alphabet;
    }

    public static int calculateOptimalAlignedPosition(ProteinProfile profile1, ProteinProfile profile2, String grouping) {
        int minProfileSize;
        int maxProfileSize;
        ProteinProfile minProfile;
        ProteinProfile maxProfile;
        double minDistance = Double.MAX_VALUE;
        int section = 0;
        int sectionPosition = 0;
        int alignedPosition = 0;
        boolean debugMode = false;
        boolean profilesSwapped = false;
        ProteinProfile trimProfile1 = profile1.getTrimmedProfileCopy(0.4);
        ProteinProfile trimProfile2 = profile2.getTrimmedProfileCopy(0.4);
        if (debugMode) {
            System.out.println("\nAligning: " + profile1.getName() + "(1), " + profile2.getName() + "(2)");
        }
        int trimmedColumnsProfile1 = profile1.getNumberOfLeftTrimmedColumns(0.4);
        int trimmedColumnsProfile2 = profile2.getNumberOfLeftTrimmedColumns(0.4);
        int trimShift = trimmedColumnsProfile1 - trimmedColumnsProfile2;
        if (trimProfile1.getNumColumns() >= trimProfile2.getNumColumns()) {
            maxProfile = trimProfile1;
            minProfile = trimProfile2;
            maxProfileSize = trimProfile1.getNumColumns();
            minProfileSize = trimProfile2.getNumColumns();
            profilesSwapped = false;
        } else {
            maxProfile = trimProfile2;
            minProfile = trimProfile1;
            maxProfileSize = trimProfile2.getNumColumns();
            minProfileSize = trimProfile1.getNumColumns();
            profilesSwapped = true;
        }
        int profileLengthSum = minProfile.getNumColumns() + maxProfile.getNumColumns();
        if (debugMode) {
            System.out.println("Aligning: " + maxProfile.getName() + "(max), " + minProfile.getName() + "(min)\n");
        }
        try {
            double distance;
            ProteinProfile p2;
            ProteinProfile p1;
            int i = 0;
            while (i < minProfileSize - 1) {
                p1 = maxProfile.getProfileSubsetCopy("0-" + i);
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy(String.valueOf(minProfileSize - i - 1) + "-" + (minProfileSize - 1)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                    section = 1;
                    sectionPosition = i;
                }
                if (debugMode) {
                    System.out.println("section = 1");
                    System.out.println(String.valueOf(p1.getName()) + "\n" + p1.toString());
                    System.out.println(String.valueOf(p2.getName()) + "\n" + p2.toString());
                    System.out.println("distance = " + distance);
                    System.out.println("minDistance = " + minDistance + "\n");
                }
                ++i;
            }
            i = 0;
            while (i < maxProfileSize - minProfileSize + 1) {
                p1 = maxProfile.getProfileSubsetCopy(String.valueOf(i) + "-" + (i + minProfileSize - 1));
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy("0-" + (minProfileSize - 1)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                    section = 2;
                    sectionPosition = i;
                }
                if (debugMode) {
                    System.out.println("section = 2");
                    System.out.println(String.valueOf(p1.getName()) + "\n" + p1.toString());
                    System.out.println(String.valueOf(p2.getName()) + "\n" + p2.toString());
                    System.out.println("distance = " + distance);
                    System.out.println("minDistance = " + minDistance + "\n");
                }
                ++i;
            }
            i = 0;
            while (i < minProfileSize - 1) {
                p1 = maxProfile.getProfileSubsetCopy(String.valueOf(maxProfileSize - minProfileSize + i + 1) + "-" + (maxProfileSize - 1));
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy("0-" + (minProfileSize - i - 2)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                    section = 3;
                    sectionPosition = i;
                }
                if (debugMode) {
                    System.out.println("section = 3");
                    System.out.println(String.valueOf(p1.getName()) + "\n" + p1.toString());
                    System.out.println(String.valueOf(p2.getName()) + "\n" + p2.toString());
                    System.out.println("distance = " + distance);
                    System.out.println("minDistance = " + minDistance + "\n");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (section == 1) {
            alignedPosition = minProfile == profile1 ? minProfileSize - sectionPosition : sectionPosition - minProfileSize;
        } else if (section == 2) {
            alignedPosition = minProfile == profile1 ? -sectionPosition : sectionPosition;
        } else if (section == 3) {
            alignedPosition = minProfile == profile1 ? minProfileSize - maxProfileSize - sectionPosition - 1 : maxProfileSize - minProfileSize + sectionPosition + 1;
        }
        int optimalPosition = profilesSwapped ? -alignedPosition + trimShift : alignedPosition + trimShift;
        if (debugMode) {
            System.out.println("Optimal Alignment Position: " + optimalPosition);
            System.out.println("  section = " + section);
            System.out.println("  sectionPosition = " + sectionPosition);
            System.out.println("  alignedPosition = " + alignedPosition);
            System.out.println("  trimShift = " + trimShift);
        }
        return optimalPosition;
    }

    public static double calculateOptimalAlignedDistributionDistance(ProteinProfile profile1, ProteinProfile profile2, String grouping) {
        int minProfileSize;
        int maxProfileSize;
        ProteinProfile minProfile;
        ProteinProfile maxProfile;
        double minDistance = Double.MAX_VALUE;
        ProteinProfile trimProfile1 = profile1.getTrimmedProfileCopy(0.4);
        ProteinProfile trimProfile2 = profile2.getTrimmedProfileCopy(0.4);
        if (trimProfile1.getNumColumns() >= trimProfile2.getNumColumns()) {
            maxProfile = trimProfile1;
            minProfile = trimProfile2;
            maxProfileSize = trimProfile1.getNumColumns();
            minProfileSize = trimProfile2.getNumColumns();
        } else {
            maxProfile = trimProfile2;
            minProfile = trimProfile1;
            maxProfileSize = trimProfile2.getNumColumns();
            minProfileSize = trimProfile1.getNumColumns();
        }
        String groupingByPosition = AminoAcidGrouping.getPolarChargedHydrophobeGrouping();
        int profileLengthSum = minProfile.getNumColumns() + maxProfile.getNumColumns();
        try {
            double distance;
            ProteinProfile p2;
            ProteinProfile p1;
            int i = 0;
            while (i < minProfileSize - 1) {
                p1 = maxProfile.getProfileSubsetCopy("0-" + i);
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy(String.valueOf(minProfileSize - i - 1) + "-" + (minProfileSize - 1)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                }
                ++i;
            }
            i = 0;
            while (i < maxProfileSize - minProfileSize + 1) {
                p1 = maxProfile.getProfileSubsetCopy(String.valueOf(i) + "-" + (i + minProfileSize - 1));
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy("0-" + (minProfileSize - 1)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                }
                ++i;
            }
            i = 0;
            while (i < minProfileSize - 1) {
                p1 = maxProfile.getProfileSubsetCopy(String.valueOf(maxProfileSize - minProfileSize + i + 1) + "-" + (maxProfileSize - 1));
                distance = ProteinProfileDistance.calculateWeightedDistributionDistance(p1, p2 = minProfile.getProfileSubsetCopy("0-" + (minProfileSize - i - 2)), profileLengthSum - p1.getNumColumns(), grouping);
                if (distance < minDistance) {
                    minDistance = distance;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return minDistance;
    }

    public static double calculateWeightedDistributionDistance(ProteinProfile profile1, ProteinProfile profile2, int maxColumns, String grouping) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        double distance = 0.0;
        if (grouping != null) {
            String[] groupingArray = grouping.split("[, ]");
            double[][] groupedWeightMatrix1 = ProteinProfileDistance.convertWeightMatrixToGroupWeightMatrix(groupingArray, profile1.getWeightMatrix(), alphabet);
            double[][] groupedWeightMatrix2 = ProteinProfileDistance.convertWeightMatrixToGroupWeightMatrix(groupingArray, profile2.getWeightMatrix(), alphabet);
            int j = 0;
            while (j < groupedWeightMatrix1.length) {
                double[] column1 = groupedWeightMatrix1[j];
                double[] column2 = groupedWeightMatrix2[j];
                double weightSum = 0.0;
                int k = 0;
                while (k < column1.length) {
                    weightSum += Math.pow(column1[k] - column2[k], 2.0);
                    ++k;
                }
                weightSum = Math.sqrt(weightSum) / Math.sqrt(2.0);
                distance += weightSum;
                ++j;
            }
        } else {
            SimpleWeightMatrix wm1 = profile1.getWeightMatrix();
            SimpleWeightMatrix wm2 = profile2.getWeightMatrix();
            try {
                int i = 0;
                while (i < wm1.columns()) {
                    Distribution d1 = wm1.getColumn(i);
                    Distribution d2 = wm2.getColumn(i);
                    Iterator l = alphabet.iterator();
                    double weightSum = 0.0;
                    while (l.hasNext()) {
                        Symbol symbol = (Symbol)l.next();
                        weightSum += Math.pow(d1.getWeight(symbol) - d2.getWeight(symbol), 2.0);
                    }
                    weightSum = Math.sqrt(weightSum) / Math.sqrt(2.0);
                    distance += weightSum;
                    ++i;
                }
            }
            catch (IllegalSymbolException e) {
                e.printStackTrace();
            }
        }
        double penalty = 1.0 - (double)profile1.getNumColumns() / (double)maxColumns;
        return Math.min(1.0, (distance /= (double)profile1.getNumColumns()) + penalty);
    }

    public static double calculateDistributionDistance(ProteinProfile profile1, ProteinProfile profile2) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        double distance = 0.0;
        SimpleWeightMatrix wm1 = profile1.getWeightMatrix();
        SimpleWeightMatrix wm2 = profile2.getWeightMatrix();
        try {
            int i = 0;
            while (i < wm1.columns()) {
                Distribution d1 = wm1.getColumn(i);
                Distribution d2 = wm2.getColumn(i);
                Iterator l = alphabet.iterator();
                double weightSum = 0.0;
                while (l.hasNext()) {
                    Symbol symbol = (Symbol)l.next();
                    weightSum += Math.pow(d1.getWeight(symbol) - d2.getWeight(symbol), 2.0);
                }
                weightSum = Math.sqrt(weightSum) / Math.sqrt(2.0);
                distance += weightSum;
                ++i;
            }
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        return distance /= (double)profile1.getNumColumns();
    }

    private static int getGroupIndexForSymbol(String[] grouping, Symbol s) {
        int index = 0;
        String symbol = null;
        try {
            symbol = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(s);
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < grouping.length) {
            String group = grouping[i];
            if (group.indexOf(symbol) >= 0) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private static double[][] convertWeightMatrixToGroupWeightMatrix(String[] grouping, WeightMatrix profile, ArrayList alphabet) {
        double[][] groupedWeightMatrix = new double[profile.columns()][grouping.length];
        try {
            int j = 0;
            while (j < profile.columns()) {
                Distribution d1 = profile.getColumn(j);
                for (Symbol symbol : alphabet) {
                    double[] dArray = groupedWeightMatrix[j];
                    int n = ProteinProfileDistance.getGroupIndexForSymbol(grouping, symbol);
                    dArray[n] = dArray[n] + d1.getWeight(symbol);
                }
                ++j;
            }
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        return groupedWeightMatrix;
    }

    public static double calculateAAGroupedDistributionDistance(ProteinProfile profile1, ProteinProfile profile2, String grouping) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        String[] groupingArray = grouping.split("[, ]");
        double[][] groupedWeightMatrix1 = ProteinProfileDistance.convertWeightMatrixToGroupWeightMatrix(groupingArray, profile1.getWeightMatrix(), alphabet);
        double[][] groupedWeightMatrix2 = ProteinProfileDistance.convertWeightMatrixToGroupWeightMatrix(groupingArray, profile2.getWeightMatrix(), alphabet);
        double distance = 0.0;
        int j = 0;
        while (j < groupedWeightMatrix1.length) {
            double[] column1 = groupedWeightMatrix1[j];
            double[] column2 = groupedWeightMatrix2[j];
            double weightSum = 0.0;
            int k = 0;
            while (k < column1.length) {
                weightSum += Math.pow(column1[k] - column2[k], 2.0);
                ++k;
            }
            distance += (weightSum /= 2.0);
            ++j;
        }
        return distance /= (double)profile1.getNumColumns();
    }

    private static double[] convertDistributionToGroupColumn(String[] grouping, Distribution distribution, ArrayList alphabet) {
        double[] groupedColumn = new double[grouping.length];
        try {
            for (Symbol symbol : alphabet) {
                int n = ProteinProfileDistance.getGroupIndexForSymbol(grouping, symbol);
                groupedColumn[n] = groupedColumn[n] + distribution.getWeight(symbol);
            }
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        return groupedColumn;
    }

    public static double calculateAAGroupedByPositionDistributionDistance(ProteinProfile profile1, ProteinProfile profile2, String[] groupingByPosition) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        SimpleWeightMatrix weightMatrix1 = profile1.getWeightMatrix();
        SimpleWeightMatrix weightMatrix2 = profile2.getWeightMatrix();
        double distance = 0.0;
        int j = 0;
        while (j < weightMatrix1.columns()) {
            Distribution distribution1 = weightMatrix1.getColumn(j);
            String[] groupingArray = groupingByPosition[j].split("[, ]");
            double[] column1 = ProteinProfileDistance.convertDistributionToGroupColumn(groupingArray, distribution1, alphabet);
            Distribution distribution2 = weightMatrix2.getColumn(j);
            double[] column2 = ProteinProfileDistance.convertDistributionToGroupColumn(groupingArray, distribution2, alphabet);
            double weightSum = 0.0;
            int k = 0;
            while (k < column1.length) {
                weightSum += Math.pow(column1[k] - column2[k], 2.0);
                ++k;
            }
            distance += (weightSum /= 2.0);
            ++j;
        }
        return distance /= (double)profile1.getNumColumns();
    }

    public static double calculateLogAverageDistance(ProteinProfile profile1, ProteinProfile profile2) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        double distance = 0.0;
        SimpleWeightMatrix wm1 = profile1.getWeightMatrix();
        SimpleWeightMatrix wm2 = profile2.getWeightMatrix();
        SimilarityMatrix simMatrix = new SimilarityMatrix(1);
        try {
            double weightSum = 0.0;
            int i = 0;
            while (i < wm1.columns()) {
                Distribution d1 = wm1.getColumn(i);
                Distribution d2 = wm2.getColumn(i);
                int j = 0;
                while (j < alphabet.size()) {
                    int k = 0;
                    while (k < alphabet.size()) {
                        double weight = d1.getWeight((Symbol)alphabet.get(j)) * d2.getWeight((Symbol)alphabet.get(k));
                        weightSum += weight * simMatrix.getRawSimilarityScore((Symbol)alphabet.get(j), (Symbol)alphabet.get(k));
                        ++k;
                    }
                    ++j;
                }
                distance += Math.log(weightSum);
                ++i;
            }
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        return distance;
    }

    private static double calcEuclidDistance(double[] vectorA, double[] vectorB) {
        double distance = 0.0;
        int j = 0;
        while (j < vectorA.length) {
            double a = vectorA[j];
            double b = vectorB[j];
            distance += Math.pow(a - b, 2.0);
            ++j;
        }
        return Math.sqrt(distance);
    }

    public static double calculateDrukeDistance(ProteinProfile profile1, ProteinProfile profile2) {
        if (profile1.getNumColumns() != profile2.getNumColumns()) {
            throw new IllegalArgumentException("Profiles to be compared must be the same length.");
        }
        ArrayList alphabet = ProteinProfileDistance.get20aaAlphabet();
        double distance = 0.0;
        SimpleWeightMatrix wm1 = profile1.getWeightMatrix();
        SimpleWeightMatrix wm2 = profile2.getWeightMatrix();
        SimilarityMatrix simMatrix = new SimilarityMatrix(100);
        try {
            int i = 0;
            while (i < wm1.columns()) {
                Distribution d1 = wm1.getColumn(i);
                Distribution d2 = wm2.getColumn(i);
                int j = 0;
                while (j < alphabet.size()) {
                    double weight1 = d1.getWeight((Symbol)alphabet.get(j));
                    double weight2 = d2.getWeight((Symbol)alphabet.get(j));
                    double[] factor = simMatrix.getDrukeFactor((Symbol)alphabet.get(j));
                    double[] factor1 = new double[5];
                    System.arraycopy(factor, 0, factor1, 0, factor.length);
                    int l = 0;
                    while (l < factor1.length) {
                        factor1[l] = factor1[l] * weight1;
                        ++l;
                    }
                    double[] factor2 = new double[5];
                    System.arraycopy(factor, 0, factor2, 0, factor.length);
                    int l2 = 0;
                    while (l2 < factor2.length) {
                        factor2[l2] = factor2[l2] * weight2;
                        ++l2;
                    }
                    distance += ProteinProfileDistance.calcEuclidDistance(factor1, factor2);
                    ++j;
                }
                ++i;
            }
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        return distance;
    }
}

