/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class FeatureLabelRenderer
extends AbstractChangeable
implements FeatureRenderer {
    public static final ChangeType LABEL_MAKER = new ChangeType("The label maker has changed", "org.biojava.bio.gui.sequence.FeatureLabelRenderer", "LABEL_MAKER", SequenceRenderContext.REPAINT);
    private static FontRenderContext FRC = new FontRenderContext(new AffineTransform(), false, true);
    private LabelMaker labelMaker;

    public FeatureLabelRenderer() {
    }

    public FeatureLabelRenderer(LabelMaker labelMaker) {
        try {
            this.setLabelMaker(labelMaker);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion Failure: could not set label maker", cve);
        }
    }

    public LabelMaker getLabelMaker() {
        return this.labelMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelMaker(LabelMaker labelMaker) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport(LABEL_MAKER);
            ChangeEvent ce = new ChangeEvent(this, LABEL_MAKER, labelMaker, this.labelMaker);
            ChangeSupport changeSupport = cs;
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.labelMaker = labelMaker;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.labelMaker = labelMaker;
        }
    }

    public double getDepth(SequenceRenderContext src) {
        return src.getFont().getMaxCharBounds(FRC).getHeight();
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    public void renderFeature(Graphics2D g, Feature feat, SequenceRenderContext src) {
        Location loc = feat.getLocation();
        String label = this.labelMaker.makeLabel(feat);
        g.setPaint(Color.black);
        int min = Math.max(loc.getMin(), src.getRange().getMin());
        int max = Math.min(loc.getMax(), src.getRange().getMax());
        int mid = (min + max) / 2;
        g.drawString(label, (float)src.sequenceToGraphics(mid), (float)(this.getDepth(src) - 2.0));
    }

    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }

    public static class AnnotationLabelMaker
    implements LabelMaker {
        private Object key;

        public AnnotationLabelMaker() {
        }

        public AnnotationLabelMaker(Object key) {
            this.setKey(key);
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public String makeLabel(Feature feat) {
            Annotation ann = feat.getAnnotation();
            if (ann.containsProperty(this.key)) {
                return ann.getProperty(this.key).toString();
            }
            return "";
        }
    }

    public static class TypeLabelMaker
    implements LabelMaker {
        public String makeLabel(Feature f) {
            return f.getType();
        }
    }

    public static class SourceLabelMaker
    implements LabelMaker {
        public String makeLabel(Feature f) {
            return f.getSource();
        }
    }

    public static interface LabelMaker {
        public String makeLabel(Feature var1);
    }
}

