/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.AnnotationParser;
import BiNGO.BinomialTestCalculate;
import BiNGO.BinomialTestCalculateUnder;
import BiNGO.CalculateTestTask;
import BiNGO.ChooseAnnotationPanel;
import BiNGO.ChooseOntologyPanel;
import BiNGO.CreateBiNGOFile;
import BiNGO.DisplayBiNGOWindow;
import BiNGO.DistributionCount;
import BiNGO.HypergeometricTestCalculate;
import BiNGO.HypergeometricTestCalculateUnder;
import BiNGO.IndeterminateJobCalculator;
import BiNGO.MultipleTestingCorrection;
import BiNGO.OverUnderPanel;
import BiNGO.SettingsPanel;
import BiNGO.SettingsSavePanel;
import BiNGO.TestCalculator;
import BiNGO.TextOrGraphPanel;
import BiNGO.TypeOfIdentifierPanel;
import BiNGO.VizPanel;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.readers.TextFileReader;
import giny.model.Node;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SettingsPanelActionListener
implements ActionListener {
    private TextOrGraphPanel textOrGraphPanel;
    private JComboBox testBox;
    private JComboBox correctionBox;
    private JComboBox categoriesBox;
    private JComboBox clusterVsBox;
    private JTextField alphaField;
    private JTextField nameField;
    private OverUnderPanel overUnderPanel;
    private VizPanel vizPanel;
    private TypeOfIdentifierPanel typeOfIdentifierPanel;
    private ChooseAnnotationPanel annotationPanel;
    private ChooseOntologyPanel ontologyPanel;
    private SettingsPanel settingsPanel;
    private SettingsSavePanel dataPanel;
    private Annotation annotation;
    private Ontology ontology;
    private HashMap synonymHash;
    private String networkName;
    private final String NONE = "---";
    private final String HYPERGEOMETRIC = "Hypergeometric test";
    private final String BINOMIAL = "Binomial test";
    private final String BENJAMINI_HOCHBERG_FDR = "Benjamini & Hochberg False Discovery Rate (FDR) correction";
    private final String BONFERRONI = "Bonferroni Family-Wise Error Rate (FWER) correction";
    private final String LOADCORRECT = "LOADCORRECT";
    private final String CATEGORY_ALL = "All categories";
    private final String CATEGORY_BEFORE_CORRECTION = "Overrepresented categories before correction";
    private final String CATEGORY_CORRECTION = "Overrepresented categories after correction";
    private final String GRAPH = "Test cluster versus network";
    private final String GENOME = "Test cluster versus whole annotation";
    private final String OVERSTRING = "Overrepresentation";
    private final String UNDERSTRING = "Underrepresentation";
    private static String VIZSTRING = "Visualization";
    private static String NOVIZSTRING = "No Visualization";
    private CalculateTestTask test;
    private JProgressBar progressBar;
    private JFrame frame;
    private JPanel panel;
    private AnnotationParser annParser;
    private String bingoDir;

    public SettingsPanelActionListener(SettingsPanel settingsPanel) {
        this.settingsPanel = settingsPanel;
        this.textOrGraphPanel = settingsPanel.getTextOrGraphPanel();
        this.typeOfIdentifierPanel = settingsPanel.getTypeOfIdentifierPanel();
        this.overUnderPanel = settingsPanel.getOverUnderPanel();
        this.vizPanel = settingsPanel.getVizPanel();
        this.testBox = settingsPanel.getTestBox();
        this.correctionBox = settingsPanel.getCorrectionBox();
        this.alphaField = settingsPanel.getAlphaField();
        this.categoriesBox = settingsPanel.getCategoriesBox();
        this.clusterVsBox = settingsPanel.getClusterVsBox();
        this.annotationPanel = settingsPanel.getAnnotationPanel();
        this.ontologyPanel = settingsPanel.getOntologyPanel();
        this.dataPanel = settingsPanel.getDataPanel();
        this.nameField = settingsPanel.getNameField();
        this.bingoDir = settingsPanel.getBingoDir();
    }

    public void actionPerformed(ActionEvent event) {
        String status2 = "OK";
        if (this.nameField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this.settingsPanel, "Please choose a cluster name ");
            status2 = "FALSE";
        } else {
            Set networkSet = Cytoscape.getNetworkSet();
            Iterator it = networkSet.iterator();
            while (it.hasNext()) {
                CyNetwork c = (CyNetwork)it.next();
                if (!this.nameField.getText().trim().equals(c.getTitle())) continue;
                JOptionPane.showMessageDialog(this.settingsPanel, "A network with this name already exists in Cytoscape. Please choose another cluster name ");
                status2 = "FALSE";
            }
        }
        if (status2.equals("OK")) {
            Vector canonicalNameVector;
            if (this.textOrGraphPanel.graphButtonChecked()) {
                CyNetwork network = Cytoscape.getCurrentNetwork();
                if (network == null) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "Please load a network.");
                    status2 = "FALSE";
                } else if (network.getFlaggedNodes().size() == 0) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "Please select one or more nodes.");
                    status2 = "FALSE";
                }
            } else if (!this.textOrGraphPanel.graphButtonChecked() && !this.nameField.getText().trim().equals("batch") && (canonicalNameVector = this.getSelectedCanonicalNamesFromTextArea()).size() == 0) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please paste one or more genes in the text field.");
                status2 = "FALSE";
            }
        }
        if (status2.equals("OK")) {
            if (this.testBox.getSelectedItem().equals("---")) {
                if (!this.correctionBox.getSelectedItem().equals("---")) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "Multiple testing correction not possible without test selection...");
                    status2 = "FALSE";
                }
            } else {
                boolean alphaIncorrect = false;
                try {
                    if (new BigDecimal(this.alphaField.getText()).compareTo(new BigDecimal("1")) >= 0 || new BigDecimal(this.alphaField.getText()).compareTo(new BigDecimal("0")) <= 0) {
                        alphaIncorrect = true;
                    }
                }
                catch (Exception ex) {
                    alphaIncorrect = true;
                }
                if (alphaIncorrect) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "Please input a valid significance level (i.e. a decimal number between 0 and 1).");
                    status2 = "FALSE";
                }
            }
        }
        if (status2.equals("OK")) {
            CyNetwork network;
            if (this.categoriesBox.getSelectedItem().equals("---")) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please select what categories should be visualized.");
                status2 = "FALSE";
            } else if (this.categoriesBox.getSelectedItem().equals("Overrepresented categories after correction") && this.correctionBox.getSelectedItem().equals("---")) {
                JOptionPane.showMessageDialog(this.settingsPanel, "The option 'Overrepresented categories after correction'\nat the category box requires the selection of a\ncorrection in the correction box.");
                status2 = "FALSE";
            } else if (this.categoriesBox.getSelectedItem().equals("Overrepresented categories before correction") && this.testBox.getSelectedItem().equals("---")) {
                JOptionPane.showMessageDialog(this.settingsPanel, "The option 'Overrepresented categories before correction'\nat the category box requires at least the selection of a\ntest in the test box.");
                status2 = "FALSE";
            } else if (this.clusterVsBox.getSelectedItem().equals("---")) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please select against what reference the cluster must be tested.");
                status2 = "FALSE";
            } else if (this.clusterVsBox.getSelectedItem().equals("Test cluster versus network") && !this.textOrGraphPanel.graphButtonChecked() && (network = Cytoscape.getCurrentNetwork()) == null) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please load a network.");
                status2 = "FALSE";
            }
        }
        if (status2.equals("OK")) {
            if (this.annotationPanel.getFile() == null) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please select an annotation file.");
                status2 = "FALSE";
            } else if (this.ontologyPanel.getFile() == null) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Please select an ontology file.");
                status2 = "FALSE";
            } else {
                this.annParser = new AnnotationParser(this.annotationPanel, this.ontologyPanel, this.typeOfIdentifierPanel.getCheckedButton(), this.settingsPanel, this.bingoDir);
                IndeterminateJobCalculator tc = new IndeterminateJobCalculator(this.annParser);
                tc.run();
                if (!this.annParser.getStatus()) {
                    status2 = "FALSE";
                } else {
                    this.annotation = this.annParser.getAnnotation();
                    this.ontology = this.annParser.getOntology();
                }
                if (this.annParser.getOrphans()) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "WARNING : Some category labels in the annotation file\nare not defined in the ontology. Please check the compatibility of\nthese files. For now, these labels will be ignored and calculations\nwill proceed.");
                }
            }
        }
        if (status2.equals("OK") && this.dataPanel.checked()) {
            String saveDataFileString;
            int choice;
            File sel = new File(this.dataPanel.getFileDir(), this.nameField.getText().trim() + ".bgo");
            if (sel.exists() && (choice = JOptionPane.showConfirmDialog(this.settingsPanel, "File " + this.nameField.getText().trim() + ".bgo already exists. Overwrite (y/n)?\nIf not, choose a different cluster name.", "confirm", 0)) != 0) {
                this.dataPanel.reset();
                status2 = "FALSE";
            }
            if (!(saveDataFileString = this.dataPanel.isFileNameLegal(this.nameField.getText().trim() + ".bgo")).equals("LOADCORRECT")) {
                JOptionPane.showMessageDialog(this.settingsPanel, "Data File: " + saveDataFileString);
                status2 = "FALSE";
            }
        }
        if (status2.equals("OK")) {
            Vector allNodes;
            boolean consistencyCheck = true;
            if (this.textOrGraphPanel.graphButtonChecked()) {
                CyNetwork network = Cytoscape.getCurrentNetwork();
                Vector selectedNodes = this.getSelectedCanonicalNamesFromNetwork(network);
                allNodes = this.clusterVsBox.getSelectedItem().equals("Test cluster versus network") ? this.getAllCanonicalNamesFromNetwork(network) : (this.clusterVsBox.getSelectedItem().equals("Test cluster versus whole annotation") ? this.getAllCanonicalNamesFromAnnotation() : this.getAllCanonicalNamesFromAnnotation());
                if (consistencyCheck) {
                    int[] testData = this.getClassificationsFromVector(selectedNodes);
                    boolean noElementsInTestData = false;
                    try {
                        int firstElement = testData[0];
                    }
                    catch (Exception ex) {
                        noElementsInTestData = true;
                    }
                    if (!noElementsInTestData) {
                        this.networkName = this.nameField.getText().trim();
                        this.performCalculations(selectedNodes, allNodes);
                    } else {
                        JOptionPane.showMessageDialog(this.settingsPanel, "The selected annotation does not produce any\nclassifications for the selected nodes.\nMaybe you chose the wrong type of gene identifier ?");
                    }
                }
            } else if (!this.nameField.getText().trim().equals("batch")) {
                Vector selectedNodes = this.getSelectedCanonicalNamesFromTextArea();
                if (this.clusterVsBox.getSelectedItem().equals("Test cluster versus network")) {
                    CyNetwork network = Cytoscape.getCurrentNetwork();
                    allNodes = this.getAllCanonicalNamesFromNetwork(network);
                    if (!allNodes.containsAll(selectedNodes)) {
                        consistencyCheck = false;
                        JOptionPane.showMessageDialog(this.settingsPanel, "Some nodes in the text input panel do not exist in the network.\nOption 'Test Cluster versus Graph' is not allowed.");
                    }
                } else {
                    allNodes = this.clusterVsBox.getSelectedItem().equals("Test cluster versus whole annotation") ? this.getAllCanonicalNamesFromAnnotation() : this.getAllCanonicalNamesFromAnnotation();
                }
                if (consistencyCheck) {
                    int[] testData = this.getClassificationsFromVector(selectedNodes);
                    boolean noElementsInTestData = false;
                    try {
                        int firstElement = testData[0];
                    }
                    catch (Exception ex) {
                        noElementsInTestData = true;
                    }
                    if (!noElementsInTestData) {
                        this.networkName = this.nameField.getText().trim();
                        this.performCalculations(selectedNodes, allNodes);
                    } else {
                        JOptionPane.showMessageDialog(this.settingsPanel, "The selected annotation does not produce any\nclassifications for the selected nodes.\nMaybe you chose the wrong type of gene identifier ?");
                    }
                }
            } else {
                String textNodes = this.textOrGraphPanel.getInputText();
                String[] clusters = textNodes.split("batch");
                if (clusters.length == 0) {
                    JOptionPane.showMessageDialog(this.settingsPanel, "Please separate your clusters \nwith the 'batch' keyword.\n");
                } else {
                    for (int i = 0; i < clusters.length; ++i) {
                        consistencyCheck = true;
                        Vector selectedNodes = this.getBatchClusterFromTextArea(clusters[i]);
                        if (this.clusterVsBox.getSelectedItem().equals("Test cluster versus network")) {
                            CyNetwork network = Cytoscape.getCurrentNetwork();
                            allNodes = this.getAllCanonicalNamesFromNetwork(network);
                            if (!allNodes.containsAll(selectedNodes)) {
                                consistencyCheck = false;
                                JOptionPane.showMessageDialog(this.settingsPanel, "Some nodes in the text input panel do not exist in the network.\nOption 'Test Cluster versus Graph' is not allowed.");
                            }
                        } else {
                            allNodes = this.clusterVsBox.getSelectedItem().equals("Test cluster versus whole annotation") ? this.getAllCanonicalNamesFromAnnotation() : this.getAllCanonicalNamesFromAnnotation();
                        }
                        if (!consistencyCheck) continue;
                        int[] testData = this.getClassificationsFromVector(selectedNodes);
                        boolean noElementsInTestData = false;
                        try {
                            int firstElement = testData[0];
                        }
                        catch (Exception ex) {
                            noElementsInTestData = true;
                        }
                        if (!noElementsInTestData) {
                            this.performCalculations(selectedNodes, allNodes);
                            continue;
                        }
                        JOptionPane.showMessageDialog(this.settingsPanel, "The selected annotation does not produce any\nclassifications for the selected nodes.\nMaybe you chose the wrong type of gene identifier ?");
                    }
                }
            }
        }
    }

    public Vector getSelectedCanonicalNamesFromNetwork(CyNetwork network) {
        Vector<String> canonicalNameVector = new Vector<String>();
        Iterator i = network.getFlaggedNodes().iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            String canonicalName = node.getIdentifier().toUpperCase();
            if (canonicalName == null || canonicalName.length() == 0) continue;
            canonicalNameVector.add(canonicalName);
        }
        return canonicalNameVector;
    }

    public Vector getSelectedCanonicalNamesFromTextArea() {
        String textNodes = this.textOrGraphPanel.getInputText();
        String[] nodes = textNodes.split("\\s+");
        Vector<String> canonicalNameVector = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].length() == 0 || canonicalNameVector.contains(nodes[i].toUpperCase())) continue;
            canonicalNameVector.add(nodes[i].toUpperCase());
        }
        return canonicalNameVector;
    }

    public Vector getBatchClusterFromTextArea(String textNodes) {
        String[] nodes = textNodes.split("\\s+");
        Vector<String> canonicalNameVector = new Vector<String>();
        int j = 0;
        while (nodes[j].equals("")) {
            ++j;
        }
        this.networkName = nodes[j];
        for (int i = j; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].length() == 0 || canonicalNameVector.contains(nodes[i].toUpperCase())) continue;
            canonicalNameVector.add(nodes[i].toUpperCase());
        }
        return canonicalNameVector;
    }

    public Vector getAllCanonicalNamesFromNetwork(CyNetwork network) {
        Vector<String> canonicalNameVector = new Vector<String>();
        Iterator i = network.nodesIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            String canonicalName = node.getIdentifier().toUpperCase();
            if (canonicalName == null || canonicalName.length() == 0) continue;
            canonicalNameVector.add(canonicalName);
        }
        return canonicalNameVector;
    }

    public Vector getAllCanonicalNamesFromAnnotation() {
        String[] nodes = this.annotation.getNames();
        Vector<String> canonicalNameVector = new Vector<String>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || nodes[i].length() == 0) continue;
            canonicalNameVector.add(nodes[i].toUpperCase());
        }
        return canonicalNameVector;
    }

    public int[] getClassificationsFromVector(Vector canonicalNameVector) {
        Vector<String> classificationsVector = new Vector<String>();
        for (int i = 0; i < canonicalNameVector.size(); ++i) {
            int[] goLabelsName = this.annotation.getClassifications(canonicalNameVector.get(i) + "");
            for (int t = 0; t < goLabelsName.length; ++t) {
                classificationsVector.add(goLabelsName[t] + "");
            }
        }
        int[] classifications = new int[classificationsVector.size()];
        for (int i = 0; i < classifications.length; ++i) {
            classifications[i] = Integer.parseInt(classificationsVector.get(i).toString());
        }
        return classifications;
    }

    public void performCalculations(Vector selectedNodes, Vector allNodes) {
        HashMap testMap = null;
        HashMap correctionMap = null;
        HashMap mapSmallX = null;
        HashMap mapSmallN = null;
        int bigX = 0;
        int bigN = 0;
        if (this.testBox.getSelectedItem().equals("---")) {
            DistributionCount dc = new DistributionCount(this.annotation, this.ontology, selectedNodes, allNodes);
            dc.countSmallN();
            dc.countSmallX();
            dc.countBigN();
            dc.countBigX();
            mapSmallN = dc.getHashMapSmallN();
            mapSmallX = dc.getHashMapSmallX();
            bigN = dc.getBigN();
            bigX = dc.getBigX();
        } else {
            if (this.testBox.getSelectedItem().equals("Hypergeometric test")) {
                this.test = this.overUnderPanel.getCheckedButton().equals("Overrepresentation") ? new HypergeometricTestCalculate(selectedNodes, allNodes, this.annotation, this.ontology) : new HypergeometricTestCalculateUnder(selectedNodes, allNodes, this.annotation, this.ontology);
            } else if (this.testBox.getSelectedItem().equals("Binomial test")) {
                this.test = this.overUnderPanel.getCheckedButton().equals("Overrepresentation") ? new BinomialTestCalculate(selectedNodes, allNodes, this.annotation, this.ontology) : new BinomialTestCalculateUnder(selectedNodes, allNodes, this.annotation, this.ontology);
            }
            TestCalculator tc = new TestCalculator(this.test);
            tc.run();
            testMap = this.test.getTestMap();
            mapSmallX = this.test.getMapSmallX();
            mapSmallN = this.test.getMapSmallN();
            bigX = this.test.getBigX();
            bigN = this.test.getBigN();
            MultipleTestingCorrection mtc = new MultipleTestingCorrection(this.alphaField.getText(), testMap, this.correctionBox.getSelectedItem().toString());
            mtc.calculate();
            correctionMap = mtc.getCorrectionMap();
        }
        if (this.vizPanel.getCheckedButton().equals(VIZSTRING)) {
            DisplayBiNGOWindow display = new DisplayBiNGOWindow(testMap, correctionMap, mapSmallX, mapSmallN, bigX, bigN, this.alphaField.getText(), this.ontology, this.networkName, this.dataPanel, this.categoriesBox.getSelectedItem() + "");
            display.makeWindow();
        }
        if (this.dataPanel.checked()) {
            CreateBiNGOFile file = new CreateBiNGOFile(testMap, correctionMap, mapSmallX, mapSmallN, bigX, bigN, this.alphaField.getText(), this.annotation, this.ontology, this.annotationPanel.getFile().toString(), this.ontologyPanel.getFile().toString(), this.testBox.getSelectedItem() + "", this.correctionBox.getSelectedItem() + "", this.overUnderPanel.getCheckedButton() + "", this.dataPanel.getFileDir(), this.networkName + ".bgo", this.clusterVsBox.getSelectedItem() + "", this.categoriesBox.getSelectedItem() + "", selectedNodes);
            file.makeFile();
            File f = new File(this.dataPanel.getFileDir(), this.networkName + ".bgo");
            String fileName = f.getAbsolutePath();
            TextFileReader reader = new TextFileReader(fileName);
            reader.read();
            String fullText = reader.getText();
            JTextArea textArea = new JTextArea(20, 60);
            JScrollPane scrollPane = new JScrollPane(textArea, 22, 32);
            textArea.setEditable(false);
            textArea.append(fullText);
            textArea.setCaretPosition(0);
            JFrame window = new JFrame(this.networkName + " BiNGO Results");
            window.getContentPane().add(new JPanel().add(scrollPane));
            window.pack();
            window.setDefaultCloseOperation(2);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            window.setLocation(screenSize.width - window.getWidth(), 0);
            window.setVisible(true);
            window.setResizable(true);
        }
    }
}

