/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.data.readers.XGMMLException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

class OpenSessionTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;

    OpenSessionTask(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.taskMonitor.setStatus("Opening Session File.\n\nIt may take a while.\nPlease wait...");
        this.taskMonitor.setPercentCompleted(-1);
        Cytoscape.getDesktop().getNetworkPanel().getTreeTable().setVisible(false);
        try {
            CytoscapeSessionReader sr = new CytoscapeSessionReader(this.fileName);
            sr.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.taskMonitor.setException(e, "Cannot open the session file: " + e.getMessage());
        }
        catch (JAXBException e) {
            e.printStackTrace();
            this.taskMonitor.setException(e, "Cannot unmarshall document: " + e.getMessage());
        }
        catch (XGMMLException e) {
            e.printStackTrace();
            this.taskMonitor.setException(e, e.getMessage());
        }
        finally {
            Object sr = null;
            Cytoscape.getDesktop().getNetworkPanel().getTreeTable().setVisible(true);
            System.gc();
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Session file " + this.fileName + " successfully loaded.");
        Cytoscape.setCurrentSessionFileName(this.fileName);
        File sessionFile = new File(this.fileName);
        Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session: " + sessionFile.getName() + ")");
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return "Opening Session File";
    }
}

