/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.CytoscapeInit;
import cytoscape.cruft.obo.BiologicalProcessAnnotationReader;
import cytoscape.cruft.obo.CellularComponentAnnotationReader;
import cytoscape.cruft.obo.MolecularFunctionAnnotationReader;
import cytoscape.cruft.obo.OboOntologyReader;
import cytoscape.cruft.obo.OboOntologyReader2;
import cytoscape.cruft.obo.SynonymReader;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.AnnotationXmlReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.servers.BioDataServerRmi;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import cytoscape.util.BioDataServerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.rmi.Naming;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BioDataServer {
    private static String GENE_ASSOCIATION_FILE = "gene_association";
    private static String OBO_FILE = "obo";
    protected BioDataServerInterface server;
    private boolean flip;
    private static final String TAXON_RESOURCE_FILE = "/cytoscape/resources/tax_report.txt";
    String taxonName;
    String taxonNumber;
    String absPath;
    String taxonFileName;
    File taxonFile;
    File start;
    Thesaurus thesaurus;
    HashMap attributeMap;
    HashMap ontologyTypeMap;
    BioDataServerUtil bdsu;
    BufferedReader taxonFileReader;

    public BioDataServer(String serverName) throws Exception {
        this.attributeMap = new HashMap();
        this.ontologyTypeMap = new HashMap();
        this.bdsu = new BioDataServerUtil();
        this.taxonFileReader = null;
        this.flip = false;
        this.thesaurus = new Thesaurus(CytoscapeInit.getProperty("defaultSpeciesName"));
        this.taxonName = null;
        this.taxonNumber = null;
        this.start = CytoscapeInit.getMRUD();
        if (serverName.indexOf("rmi://") >= 0) {
            this.server = (BioDataServerInterface)Naming.lookup(serverName);
        } else {
            this.server = new BioDataServerRmi();
            File fileTester = new File(serverName);
            if (serverName.startsWith("jar://") || serverName.startsWith("http://") || !fileTester.isDirectory() && fileTester.canRead()) {
                boolean fileFlag = false;
                BufferedReader manFileIn = new BufferedReader(new FileReader(serverName));
                fileFlag = this.checkFileType(manFileIn);
                if (fileFlag) {
                    String[] flags = this.parseLoadFile(serverName, "flip");
                    if (flags[0].endsWith("true")) {
                        this.flip = true;
                        System.out.println("Cannonical and common names will be fliped...");
                    } else {
                        this.flip = false;
                    }
                    String[] oboFile = this.parseLoadFile(serverName, OBO_FILE);
                    String[] geneAssociationFile = this.parseLoadFile(serverName, GENE_ASSOCIATION_FILE);
                    try {
                        this.loadObo(geneAssociationFile, oboFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        throw e;
                    }
                } else {
                    String[] thesaurusFilenames = this.parseLoadFile(serverName, "synonyms");
                    this.loadThesaurusFiles(thesaurusFilenames);
                    String[] ontologyFiles = this.parseLoadFile(serverName, "ontology");
                    String[] annotationFilenames = this.parseLoadFile(serverName, "annotation");
                    this.loadAnnotationFiles(annotationFilenames, ontologyFiles);
                }
            } else {
                System.err.println("Could not read BioDataServer load file '" + serverName + "'");
            }
        }
    }

    protected boolean checkFileType(BufferedReader br) throws IOException {
        String curLine = null;
        while (null != (curLine = br.readLine())) {
            if (!curLine.startsWith(OBO_FILE) && !curLine.startsWith(GENE_ASSOCIATION_FILE)) continue;
            br.close();
            return true;
        }
        br.close();
        return false;
    }

    protected String[] parseLoadFile(String filename, String key) {
        String rawText;
        File absoluteDirectory = null;
        String httpUrlPrefix = null;
        boolean readingFromFileSystem = false;
        boolean readingFromWeb = false;
        try {
            Object reader;
            if (filename.trim().startsWith("jar://")) {
                reader = new TextJarReader(filename);
                ((TextJarReader)reader).read();
                rawText = ((TextJarReader)reader).getText();
            } else if (filename.trim().startsWith("http://")) {
                reader = new TextHttpReader(filename);
                ((TextHttpReader)reader).read();
                rawText = ((TextHttpReader)reader).getText();
                readingFromWeb = true;
                try {
                    URL url = new URL(filename);
                    String fullUrlString = url.toString();
                    httpUrlPrefix = fullUrlString.substring(0, fullUrlString.lastIndexOf("/"));
                }
                catch (Exception e) {
                    httpUrlPrefix = "url parsing error!";
                }
            } else {
                File file = new File(filename);
                readingFromFileSystem = true;
                absoluteDirectory = file.getAbsoluteFile().getParentFile();
                TextFileReader reader2 = new TextFileReader(filename);
                reader2.read();
                rawText = reader2.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading annotation server load file " + filename);
            System.err.println(e0.getMessage());
            return new String[0];
        }
        String[] lines = rawText.split("\n");
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.trim().startsWith("#") || !line.startsWith(key)) continue;
            String fileToRead = line.substring(line.indexOf("=") + 1);
            if (readingFromFileSystem) {
                fileToRead = new File(absoluteDirectory, fileToRead).getPath();
            } else if (readingFromWeb) {
                fileToRead = httpUrlPrefix + "/" + fileToRead;
            }
            list.add(fileToRead);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public BioDataServer() throws Exception {
        this.server = new BioDataServerRmi();
    }

    public Ontology[] readOntologyFlatFiles(String[] ontologyFilenames) throws Exception {
        Vector<Ontology> list = new Vector<Ontology>();
        for (int i = 0; i < ontologyFilenames.length; ++i) {
            String filename = ontologyFilenames[i];
            if (filename.endsWith(".xml")) continue;
            OntologyFlatFileReader reader = new OntologyFlatFileReader(filename);
            list.add(reader.getOntology());
        }
        return list.toArray(new Ontology[0]);
    }

    public Ontology[] readOntologyFlatFiles2(String[] ontologyFilenames) throws Exception {
        Vector<Ontology> list = new Vector<Ontology>();
        for (int i = 0; i < ontologyFilenames.length; ++i) {
            String line;
            String filename = ontologyFilenames[i];
            BufferedReader oboReader = new BufferedReader((Reader)new OboOntologyReader((Reader)new FileReader(filename)));
            OntologyFlatFileReader reader = new OntologyFlatFileReader(oboReader);
            list.add(reader.getOntology());
            oboReader.close();
            BufferedReader oboReader2 = new BufferedReader((Reader)new OboOntologyReader2((Reader)new FileReader(filename)));
            String[] parts = null;
            while ((line = oboReader2.readLine()) != null) {
                parts = line.split("=");
                if (parts.length != 2) continue;
                if (parts[1].equals("biological_process")) {
                    this.ontologyTypeMap.put(parts[0], "P");
                    continue;
                }
                if (parts[1].equals("molecular_function")) {
                    this.ontologyTypeMap.put(parts[0], "F");
                    continue;
                }
                if (!parts[1].equals("cellular_component")) continue;
                this.ontologyTypeMap.put(parts[0], "C");
            }
            oboReader2.close();
        }
        return list.toArray(new Ontology[0]);
    }

    protected Ontology pickOntology(Ontology[] ontologies, Annotation annotation) {
        for (int i = 0; i < ontologies.length; ++i) {
            if (!ontologies[i].getCurator().equalsIgnoreCase(annotation.getCurator())) continue;
            return ontologies[i];
        }
        return null;
    }

    public void loadObo(String[] annotationFilenames, String[] ontologyFilenames) throws Exception {
        BufferedReader[] oboReaders = new BufferedReader[ontologyFilenames.length];
        for (int i = 0; i < ontologyFilenames.length; ++i) {
            oboReaders[i] = new BufferedReader((Reader)new OboOntologyReader((Reader)new FileReader(ontologyFilenames[i])));
        }
        Ontology[] ontologies = this.readOntologyFlatFiles2(ontologyFilenames);
        for (int i = 0; i < annotationFilenames.length; ++i) {
            String filename = annotationFilenames[i];
            String[] thFileName = new String[]{annotationFilenames[i]};
            BufferedReader gaFileReader = new BufferedReader(new FileReader(filename));
            URL taxURL = this.getClass().getResource(TAXON_RESOURCE_FILE);
            this.taxonFileReader = new BufferedReader(new InputStreamReader(taxURL.openStream()));
            this.taxonName = this.bdsu.checkSpecies(gaFileReader, this.taxonFileReader);
            this.loadThesaurusFiles2(thFileName);
            System.out.println("Loading: " + annotationFilenames[i] + " (Species = " + this.taxonName + ")");
            BufferedReader bpRd = new BufferedReader((Reader)new BiologicalProcessAnnotationReader(this.taxonName, (Map)this.ontologyTypeMap, (Reader)new FileReader(filename)));
            BufferedReader ccRd = new BufferedReader((Reader)new CellularComponentAnnotationReader(this.taxonName, (Map)this.ontologyTypeMap, (Reader)new FileReader(filename)));
            BufferedReader mfRd = new BufferedReader((Reader)new MolecularFunctionAnnotationReader(this.taxonName, (Map)this.ontologyTypeMap, (Reader)new FileReader(filename)));
            AnnotationFlatFileReader bpReader = new AnnotationFlatFileReader(bpRd, this.thesaurus, this.flip);
            AnnotationFlatFileReader ccReader = new AnnotationFlatFileReader(ccRd, this.thesaurus, this.flip);
            AnnotationFlatFileReader mfReader = new AnnotationFlatFileReader(mfRd, this.thesaurus, this.flip);
            Annotation bpAnnotation = bpReader.getAnnotation();
            Annotation ccAnnotation = ccReader.getAnnotation();
            Annotation mfAnnotation = mfReader.getAnnotation();
            bpAnnotation.setOntology(this.pickOntology(ontologies, bpAnnotation));
            ccAnnotation.setOntology(this.pickOntology(ontologies, ccAnnotation));
            mfAnnotation.setOntology(this.pickOntology(ontologies, mfAnnotation));
            this.server.addAnnotation(bpAnnotation);
            this.server.addAnnotation(ccAnnotation);
            this.server.addAnnotation(mfAnnotation);
            bpRd.close();
            ccRd.close();
            mfRd.close();
        }
    }

    public void loadAnnotationFiles(String[] annotationFilenames, String[] ontologyFilenames) throws Exception {
        Ontology[] ontologies = this.readOntologyFlatFiles(ontologyFilenames);
        for (int i = 0; i < annotationFilenames.length; ++i) {
            Annotation annotation;
            String filename = annotationFilenames[i];
            if (!filename.endsWith(".xml")) {
                AnnotationFlatFileReader reader = new AnnotationFlatFileReader(filename, this.thesaurus);
                annotation = reader.getAnnotation();
                annotation.setOntology(this.pickOntology(ontologies, annotation));
            } else {
                File xmlFile = new File(annotationFilenames[i]);
                AnnotationXmlReader reader = new AnnotationXmlReader(xmlFile);
                annotation = reader.getAnnotation();
            }
            this.server.addAnnotation(annotation);
        }
    }

    public void loadThesaurusFiles(String[] thesaurusFilenames) throws Exception {
        for (int i = 0; i < thesaurusFilenames.length; ++i) {
            String filename = thesaurusFilenames[i];
            ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(filename);
            this.thesaurus = reader.getThesaurus();
            this.server.addThesaurus(this.thesaurus.getSpecies(), this.thesaurus);
        }
    }

    public void loadThesaurusFiles2(String[] thesaurusFilenames) throws Exception {
        for (int i = 0; i < thesaurusFilenames.length; ++i) {
            String filename = thesaurusFilenames[i];
            BufferedReader thRd = new BufferedReader((Reader)new SynonymReader(this.taxonName, (Reader)new FileReader(filename)));
            ThesaurusFlatFileReader reader = new ThesaurusFlatFileReader(thRd, this.flip);
            this.thesaurus = reader.getThesaurus();
            this.server.addThesaurus(this.thesaurus.getSpecies(), this.thesaurus);
            thRd.close();
        }
    }

    public void clear() {
        try {
            this.server.clear();
        }
        catch (Exception e) {
            System.err.println("Error!  failed to clear");
            e.printStackTrace();
        }
    }

    public void addAnnotation(Annotation annotation) {
        try {
            this.server.addAnnotation(annotation);
        }
        catch (Exception e) {
            System.err.println("Error!  failed to add annotation " + annotation);
            e.printStackTrace();
        }
    }

    public int getAnnotationCount() {
        try {
            int count = this.server.getAnnotationCount();
            return count;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        try {
            return this.server.getAnnotationDescriptions();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(String species, String curator, String type) {
        try {
            return this.server.getAnnotation(species, curator, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Annotation getAnnotation(AnnotationDescription description) {
        try {
            return this.server.getAnnotation(description);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(String species, String curator, String type, String entity) {
        try {
            return this.server.getClassifications(species, curator, type, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getClassifications(AnnotationDescription description, String entity) {
        try {
            return this.server.getClassifications(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[][] getAllAnnotations(AnnotationDescription description, String entity) {
        try {
            return this.server.getAllAnnotations(description, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String describe() {
        try {
            return this.server.describe();
        }
        catch (Exception e) {
            return "error connecting to data server";
        }
    }

    public void addThesaurus(String species, Thesaurus thesaurus) {
        try {
            this.server.addThesaurus(species, thesaurus);
        }
        catch (Exception e) {
            return;
        }
    }

    public String getCanonicalName(String species, String commonName) {
        try {
            return this.server.getCanonicalName(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getAllCommonNames(String species, String commonName) {
        try {
            return this.server.getAllCommonNames(species, commonName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getCommonName(String species, String canonicalName) {
        try {
            return this.server.getCommonName(species, canonicalName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

