/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import cytoscape.CytoscapeInit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;

public class SpeciesPanel
extends JPanel {
    private static final String TAXON_RESOURCE_FILE = "/cytoscape/resources/tax_report.txt";
    private String currentSpeciesName = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
    private JComboBox overwriteComboBox;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JCheckBox overwriteCheckBox;
    private JEditorPane messageEditorPane;
    private JScrollPane messageScrollPane;

    public SpeciesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteComboBox = new JComboBox();
        this.messageScrollPane = new JScrollPane();
        this.messageEditorPane = new JEditorPane();
        this.setTaxonomyTable();
        this.overwriteComboBox.setEditable(false);
        this.overwriteComboBox.setEnabled(false);
        this.overwriteComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpeciesPanel.this.overwriteComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 1, 14));
        this.jLabel1.setText("Default Species Name");
        this.overwriteCheckBox.setFont(new Font("Dialog", 1, 10));
        this.overwriteCheckBox.setText("Overwrite default species name with:");
        this.overwriteCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.overwriteCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.overwriteCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpeciesPanel.this.overwriteCheckBoxActionPerformed(evt);
            }
        });
        this.messageScrollPane.setHorizontalScrollBarPolicy(31);
        this.messageEditorPane.setEditable(false);
        this.messageEditorPane.setContentType("text/html");
        this.messageEditorPane.setText("<html><body><strong><u>Note</u></strong><br>The property <strong><i>defaultSpeciesName</i></strong> will be used <br>only when a node does not have an attribute <strong><i>species</i></strong>.<br><br>If you select a species name from this list, the value<br>will be used as the <strong><i>defaultSpeciesname</i></strong>.</body></html>");
        this.messageScrollPane.setViewportView(this.messageEditorPane);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.overwriteCheckBox, -1, 338, Short.MAX_VALUE).add(36, 36, 36)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jSeparator1, -1, 362, Short.MAX_VALUE).add(1, (Component)this.overwriteComboBox, 0, 362, Short.MAX_VALUE).add(1, (Component)this.messageScrollPane, -1, 362, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 362, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.overwriteCheckBox, -2, 13, -2).addPreferredGap(0).add((Component)this.overwriteComboBox, -2, 25, -2).addPreferredGap(0).add((Component)this.messageScrollPane, -1, 103, Short.MAX_VALUE).addContainerGap()));
    }

    private void overwriteCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.overwriteComboBox.isEnabled()) {
            this.overwriteComboBox.setEnabled(true);
            CytoscapeInit.getProperties().setProperty("defaultSpeciesName", (String)this.overwriteComboBox.getSelectedItem());
        } else {
            this.overwriteComboBox.setEnabled(false);
            CytoscapeInit.getProperties().setProperty("defaultSpeciesName", this.currentSpeciesName);
        }
    }

    private void overwriteComboBoxActionPerformed(ActionEvent evt) {
        String species = (String)this.overwriteComboBox.getSelectedItem();
        CytoscapeInit.getProperties().setProperty("defaultSpeciesName", species);
    }

    private void setTaxonomyTable() {
        BufferedReader spListReader = null;
        try {
            URL taxURL = this.getClass().getResource(TAXON_RESOURCE_FILE);
            spListReader = new BufferedReader(new InputStreamReader(taxURL.openStream()));
            System.out.println("Taxonomy table found in jar file...");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.setSpList(spListReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setSpList(BufferedReader rd) throws IOException {
        String curLine = null;
        String name1 = null;
        curLine = rd.readLine();
        while ((curLine = rd.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(curLine, "|");
            st.nextToken();
            name1 = st.nextToken().trim();
            this.overwriteComboBox.addItem(name1);
        }
    }
}

