/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.FileUtil;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.TestNodeView;
import giny.model.Node;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NodeAppearanceCalculatorTest
extends TestCase {
    CyNetwork cyNet;
    CyNode a;
    CyNode b;
    CyNode c;
    CyEdge ab;
    CalculatorCatalog catalog;
    Properties props;

    public NodeAppearanceCalculatorTest(String name) {
        super(name);
    }

    public void setUp() {
        System.out.println("setup begin");
        this.cyNet = Cytoscape.createNetworkFromFile("testData/small.sif");
        this.a = Cytoscape.getCyNode("a");
        this.b = Cytoscape.getCyNode("b");
        this.c = Cytoscape.getCyNode("c");
        this.ab = Cytoscape.getCyEdge(this.a, this.b, "interaction", "pp", false);
        this.props = new Properties();
        try {
            CyAttributesReader.loadAttributes(Cytoscape.getNodeAttributes(), new FileReader("testData/small.nodeAttr"));
            this.props.load(FileUtil.getInputStream("testData/small.vizmap.props"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators(this.props, this.catalog, true);
        System.out.println("setup end");
    }

    public void testDefaultAppearance() {
        System.out.println("begin NodeAppearanceCalculatorTest.testDefaultAppearance()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        NodeAppearance na = nac.calculateNodeAppearance(this.a, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue((String)("a color  " + na.getFillColor() + " expect " + Color.WHITE.toString()), (boolean)na.getFillColor().equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue((String)("a border color  " + na.getBorderColor() + " expect " + Color.BLACK.toString()), (boolean)na.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"a lineType  ", (Object)LineType.LINE_1, (Object)na.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"a shape  ", (byte)0, (byte)na.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"a width  ", (Object)35.0, (Object)na.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"a height  ", (Object)35.0, (Object)na.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"a size  ", (Object)35.0, (Object)na.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"a label  ", (String)"", (String)na.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"a tooltip  ", (String)"", (String)na.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"a font size  ", (int)12, (int)na.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"a font style  ", (int)0, (int)na.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("a label color  " + na.getLabelColor() + " expect " + Color.BLACK), (boolean)na.getLabelColor().equals(Color.BLACK));
        NodeAppearance nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue((String)("b color  " + nb.getFillColor() + " expect " + Color.WHITE.toString()), (boolean)nb.getFillColor().equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue((String)("b border color  " + nb.getBorderColor() + " expect " + Color.BLACK.toString()), (boolean)nb.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"b lineType  ", (Object)LineType.LINE_1, (Object)nb.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"b shape  ", (byte)0, (byte)nb.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"b width  ", (Object)35.0, (Object)nb.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"b height  ", (Object)35.0, (Object)nb.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"b size  ", (Object)35.0, (Object)nb.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"b label  ", (String)"", (String)nb.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"b tooltip  ", (String)"", (String)nb.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"b font size  ", (int)12, (int)nb.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"b font style  ", (int)0, (int)nb.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("b label color  " + nb.getLabelColor() + " expect " + Color.BLACK), (boolean)nb.getLabelColor().equals(Color.BLACK));
        nac.setNodeSizeLocked(false);
        NodeAppearance nc = nac.calculateNodeAppearance(this.c, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue((String)("c color  " + nc.getFillColor() + " expect " + Color.WHITE.toString()), (boolean)nc.getFillColor().equals(Color.WHITE));
        NodeAppearanceCalculatorTest.assertTrue((String)("c border color  " + nc.getBorderColor() + " expect " + Color.BLACK.toString()), (boolean)nc.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"c lineType  ", (Object)LineType.LINE_1, (Object)nc.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"c shape  ", (byte)0, (byte)nc.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"c width  ", (Object)70.0, (Object)nc.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"c height  ", (Object)30.0, (Object)nc.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"c size  ", (Object)35.0, (Object)nc.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"c label  ", (String)"", (String)nc.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"c tooltip  ", (String)"", (String)nc.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"c font size  ", (int)12, (int)nc.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"c font style  ", (int)0, (int)nc.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("c label color  " + nc.getLabelColor() + " expect " + Color.BLACK), (boolean)nc.getLabelColor().equals(Color.BLACK));
        NodeAppearance def = nac.getDefaultAppearance();
        def.setFillColor(Color.GREEN);
        def.setBorderColor(Color.BLUE);
        def.setWidth(47.0);
        def.setHeight(23.0);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue((String)("color  " + na.getFillColor() + " expect " + Color.GREEN.toString()), (boolean)na.getFillColor().equals(Color.GREEN));
        NodeAppearanceCalculatorTest.assertTrue((String)("border color  " + na.getBorderColor() + " expect " + Color.BLUE.toString()), (boolean)na.getBorderColor().equals(Color.BLUE));
        NodeAppearanceCalculatorTest.assertEquals((String)"width  ", (Object)47.0, (Object)na.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"height  ", (Object)23.0, (Object)na.getHeight());
        nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        NodeAppearanceCalculatorTest.assertTrue((String)("color  " + nb.getFillColor() + " expect " + Color.GREEN.toString()), (boolean)nb.getFillColor().equals(Color.GREEN));
        NodeAppearanceCalculatorTest.assertTrue((String)("border color  " + nb.getBorderColor() + " expect " + Color.BLUE.toString()), (boolean)nb.getBorderColor().equals(Color.BLUE));
        NodeAppearanceCalculatorTest.assertEquals((String)"width  ", (Object)47.0, (Object)nb.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"height  ", (Object)23.0, (Object)nb.getHeight());
        System.out.println("end NodeAppearanceCalculatorTest.testDefaultAppearance()");
    }

    public void testApplyProperties() {
        System.out.println("begin NodeAppearanceCalculatorTest.testApplyProperties()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        nac.applyProperties("homer", this.props, "nodeAppearanceCalculator.homer", this.catalog);
        System.out.println(nac.getDescription());
        nac.setNodeSizeLocked(false);
        NodeAppearance na = nac.calculateNodeAppearance(this.a, this.cyNet);
        System.out.println("NodeAppearance a\n" + na.getDescription());
        Color ca = new Color(246, 242, 103);
        NodeAppearanceCalculatorTest.assertTrue((String)("a color  " + na.getFillColor() + " expect " + ca.toString()), (boolean)na.getFillColor().equals(ca));
        NodeAppearanceCalculatorTest.assertTrue((String)("a border color  " + na.getBorderColor() + " expect " + Color.BLACK.toString()), (boolean)na.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"a lineType  ", (Object)LineType.LINE_1, (Object)na.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"a shape  ", (byte)0, (byte)na.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"a width  ", (Object)70.0, (Object)na.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"a height  ", (Object)10.0, (Object)na.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"a size  ", (Object)35.0, (Object)na.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"a label  ", (String)"a", (String)na.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"a tooltip  ", (String)"", (String)na.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"a font size  ", (int)12, (int)na.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"a font style  ", (int)0, (int)na.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("a label color  " + na.getLabelColor() + " expect " + Color.BLACK), (boolean)na.getLabelColor().equals(Color.BLACK));
        NodeAppearance nb = nac.calculateNodeAppearance(this.b, this.cyNet);
        System.out.println("NodeAppearance b\n" + nb.getDescription());
        Color cb = new Color(87, 25, 230);
        NodeAppearanceCalculatorTest.assertTrue((String)("b color  " + nb.getFillColor() + " expect " + cb.toString()), (boolean)nb.getFillColor().equals(cb));
        NodeAppearanceCalculatorTest.assertTrue((String)("b border color  " + nb.getBorderColor() + " expect " + Color.BLACK), (boolean)nb.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"b lineType  ", (Object)LineType.LINE_5, (Object)nb.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"b shape  ", (byte)0, (byte)nb.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"b width  ", (Object)70.0, (Object)nb.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"b height  ", (Object)30.0, (Object)nb.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"b size  ", (Object)35.0, (Object)nb.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"b label  ", (String)"b", (String)nb.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"b tooltip  ", (String)"", (String)nb.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"b font size  ", (int)12, (int)nb.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"b font style  ", (int)0, (int)nb.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("b label color  " + nb.getLabelColor() + " expect " + Color.BLACK.toString()), (boolean)nb.getLabelColor().equals(Color.BLACK));
        nac.setNodeSizeLocked(true);
        NodeAppearance nc = nac.calculateNodeAppearance(this.c, this.cyNet);
        System.out.println("NodeAppearance c\n" + nc.getDescription());
        Color cc = new Color(209, 205, 254);
        NodeAppearanceCalculatorTest.assertTrue((String)("c color  " + nc.getFillColor() + " expect " + cc.toString()), (boolean)nc.getFillColor().equals(cc));
        NodeAppearanceCalculatorTest.assertTrue((String)("c border color  " + nc.getBorderColor() + " expect " + Color.BLACK), (boolean)nc.getBorderColor().equals(Color.BLACK));
        NodeAppearanceCalculatorTest.assertEquals((String)"c lineType  ", (Object)LineType.DASHED_1, (Object)nc.getBorderLineType());
        NodeAppearanceCalculatorTest.assertEquals((String)"c shape  ", (byte)0, (byte)nc.getShape());
        NodeAppearanceCalculatorTest.assertEquals((String)"c width  ", (Object)35.0, (Object)nc.getWidth());
        NodeAppearanceCalculatorTest.assertEquals((String)"c height  ", (Object)35.0, (Object)nc.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"c size  ", (Object)35.0, (Object)nc.getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"c label  ", (String)"c", (String)nc.getLabel());
        NodeAppearanceCalculatorTest.assertEquals((String)"c tooltip  ", (String)"", (String)nc.getToolTip());
        NodeAppearanceCalculatorTest.assertEquals((String)"c font size  ", (int)12, (int)nc.getFont().getSize());
        NodeAppearanceCalculatorTest.assertEquals((String)"c font style  ", (int)0, (int)nc.getFont().getStyle());
        NodeAppearanceCalculatorTest.assertTrue((String)("c label color  " + nc.getLabelColor() + " expect " + Color.BLACK.toString()), (boolean)nc.getLabelColor().equals(Color.BLACK));
        System.out.println("end NodeAppearanceCalculatorTest.testApplyProperties()");
    }

    public void testNodeSizeLock() {
        System.out.println("begin NodeAppearanceCalculatorTest.testNodeSizeLock()");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        System.out.println(nac.getDescription());
        TestNodeView view = new TestNodeView();
        NodeAppearance na = null;
        nac.setNodeSizeLocked(false);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view);
        NodeAppearanceCalculatorTest.assertEquals((String)"height", (Object)30.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"width", (Object)70.0, (Object)view.getWidth());
        nac.setNodeSizeLocked(true);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view);
        NodeAppearanceCalculatorTest.assertEquals((String)"height", (Object)35.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"width", (Object)35.0, (Object)view.getWidth());
        nac.applyProperties("homer", this.props, "nodeAppearanceCalculator.homer", this.catalog);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view);
        NodeAppearanceCalculatorTest.assertEquals((String)"height", (Object)35.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"width", (Object)35.0, (Object)view.getWidth());
        nac.setNodeSizeLocked(false);
        na = nac.calculateNodeAppearance(this.a, this.cyNet);
        na.applyAppearance(view);
        NodeAppearanceCalculatorTest.assertEquals((String)"height", (Object)10.0, (Object)view.getHeight());
        NodeAppearanceCalculatorTest.assertEquals((String)"width", (Object)70.0, (Object)view.getWidth());
        System.out.println("end NodeAppearanceCalculatorTest.testNodeSizeLock()");
    }

    public void testBypass() throws Exception {
        Color fillColor = new Color(63, 128, 255);
        Color borderColor = new Color(100, 100, 50);
        String fillColorString = "63,128,255";
        String borderColorString = "100,100,50";
        LineType lineType = LineType.DASHED_3;
        String lineTypeString = "DASHED_3";
        byte shape = 7;
        double width = 49.0;
        double height = 79.0;
        String label = "testLabel";
        String toolTip = "testToolTip";
        Font font = new Font("SansSerif", 2, 10);
        String fontString = "SansSerif,italic,10";
        CytoscapeRootGraph graph = Cytoscape.getRootGraph();
        int index1 = graph.createNode();
        Node first = graph.getNode(index1);
        int index2 = graph.createNode();
        Node second = graph.getNode(index2);
        CyNetwork network2 = Cytoscape.createNetwork(Cytoscape.getRootGraph().getNodeIndicesArray(), Cytoscape.getRootGraph().getEdgeIndicesArray(), null);
        CyAttributes secondNodeAttr = Cytoscape.getNodeAttributes();
        String secondName = second.getIdentifier();
        secondNodeAttr.setAttribute(secondName, "node.fillColor", "63,128,255");
        secondNodeAttr.setAttribute(secondName, "node.borderColor", "100,100,50");
        secondNodeAttr.setAttribute(secondName, "node.lineType", "dashed3");
        secondNodeAttr.setAttribute(secondName, "node.shape", "diamond");
        secondNodeAttr.setAttribute(secondName, "node.width", "49.0");
        secondNodeAttr.setAttribute(secondName, "node.height", "79.0");
        secondNodeAttr.setAttribute(secondName, "node.size", "32.0");
        secondNodeAttr.setAttribute(secondName, "node.label", "testLabel");
        secondNodeAttr.setAttribute(secondName, "node.toolTip", "testToolTip");
        secondNodeAttr.setAttribute(secondName, "node.font", "SansSerif,italic,10");
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator();
        nac.setNodeSizeLocked(false);
        NodeAppearance secondApp = nac.calculateNodeAppearance(second, network2);
        System.out.println("secondApp\n" + secondApp.getDescription());
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getFillColor().equals(fillColor));
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getBorderColor().equals(borderColor));
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getBorderLineType().equals(lineType));
        NodeAppearanceCalculatorTest.assertTrue((secondApp.getShape() == shape ? 1 : 0) != 0);
        NodeAppearanceCalculatorTest.assertEquals((String)"width ", (double)secondApp.getWidth(), (double)width, (double)1.0E-4);
        NodeAppearanceCalculatorTest.assertEquals((String)"height ", (double)secondApp.getHeight(), (double)height, (double)1.0E-4);
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getLabel().equals(label));
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getToolTip().equals(toolTip));
        NodeAppearanceCalculatorTest.assertTrue((boolean)secondApp.getFont().equals(font));
        nac.setNodeSizeLocked(true);
        nac.calculateNodeAppearance(secondApp, second, network2);
        NodeAppearanceCalculatorTest.assertEquals((String)"width", (double)secondApp.getWidth(), (double)32.0, (double)1.0E-4);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(NodeAppearanceCalculatorTest.class));
    }
}

