/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PopupIconChooser {
    private String title;
    private String objectName;
    private ImageIcon currentIcon;
    private JDialog mainDialog;
    private Dialog parentDialog;
    private Frame parentFrame;
    private Component parent;
    private JPanel mainPanel;
    private JList iconList;
    private boolean alreadyConstructed = false;

    public PopupIconChooser(String title, String objectName, ImageIcon[] icons, ImageIcon startIconObject, Frame parentFrame) {
        this.parentDialog = null;
        this.parentFrame = parentFrame;
        this.parent = parentFrame;
        this.commonInit(title, objectName, icons, startIconObject);
    }

    public PopupIconChooser(String title, String objectName, ImageIcon[] icons, ImageIcon startIconObject, Dialog parentDialog) {
        this.parentDialog = parentDialog;
        this.parentFrame = null;
        this.parent = parentDialog;
        this.commonInit(title, objectName, icons, startIconObject);
    }

    private void commonInit(String title, String objectName, ImageIcon[] icons, ImageIcon startIconObject) {
        this.title = title;
        this.objectName = objectName;
        this.iconList = new JList<ImageIcon>(icons);
        this.currentIcon = startIconObject != null ? startIconObject : (ImageIcon)this.iconList.getModel().getElementAt(0);
    }

    public ImageIcon showDialog() {
        if (!this.alreadyConstructed) {
            if (this.parentFrame != null) {
                this.mainDialog = new JDialog(this.parentFrame, this.title, true);
            } else if (this.parentDialog != null) {
                this.mainDialog = new JDialog(this.parentDialog, this.title, true);
            } else {
                return null;
            }
            JPanel mainPanel = new JPanel(new GridLayout(0, 1));
            final JButton setButton = new JButton("Apply");
            JButton cancelButton = new JButton("Cancel");
            setButton.addActionListener(new ApplyIconAction());
            cancelButton.addActionListener(new CancelIconAction());
            this.iconList.setLayoutOrientation(2);
            this.iconList.setVisibleRowCount(1);
            this.iconList.setBackground(Color.WHITE);
            this.iconList.setSelectionBackground(Color.RED);
            this.iconList.setSelectionForeground(Color.RED);
            this.iconList.setSelectionMode(0);
            this.iconList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        setButton.doClick();
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.iconList);
            listScroller.setPreferredSize(new Dimension(150, 52));
            listScroller.setMinimumSize(new Dimension(150, 52));
            listScroller.setAlignmentX(0.0f);
            listScroller.setAlignmentY(1.0f);
            this.iconList.ensureIndexIsVisible(this.iconList.getSelectedIndex());
            JPanel listPane = new JPanel();
            listPane.setLayout(new BoxLayout(listPane, 1));
            JLabel label = new JLabel("Set " + this.objectName);
            label.setLabelFor(this.iconList);
            listPane.add(label);
            listPane.add(Box.createRigidArea(new Dimension(0, 5)));
            listPane.add(listScroller);
            listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonPane.add(setButton);
            buttonPane.add(cancelButton);
            mainPanel.add((Component)listPane, "Center");
            mainPanel.add((Component)buttonPane, "South");
            this.mainDialog.setContentPane(mainPanel);
            this.alreadyConstructed = true;
        }
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(this.parent);
        this.mainDialog.setVisible(true);
        return this.currentIcon;
    }

    public class CancelIconAction
    extends AbstractAction {
        CancelIconAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            PopupIconChooser.this.currentIcon = null;
            PopupIconChooser.this.mainDialog.dispose();
        }
    }

    public class ApplyIconAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            ImageIcon icon = (ImageIcon)PopupIconChooser.this.iconList.getSelectedValue();
            PopupIconChooser.this.currentIcon = icon;
            PopupIconChooser.this.mainDialog.dispose();
        }
    }
}

