/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.List;
import org.baderlab.brain.DistanceMatrix;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinProfileDistance;

public class AlignmentMatrix
extends DistanceMatrix {
    private int[] alignmentPositionMatrix = null;
    private int matrixDim = 0;

    public AlignmentMatrix(int matrixDim) {
        super(matrixDim);
        this.matrixDim = matrixDim;
        this.alignmentPositionMatrix = new int[matrixDim * matrixDim];
    }

    public void setAlignmentValue(int i, int j, int value) {
        this.alignmentPositionMatrix[i * this.matrixDim + j] = value;
    }

    public int getAlignmentValue(int i, int j) {
        if (i == j) {
            return 0;
        }
        return this.alignmentPositionMatrix[i * this.matrixDim + j];
    }

    public void calcAlignment(List proteinProfileList, String grouping) {
        int i = 0;
        while (i < proteinProfileList.size()) {
            ProteinProfile profile1 = (ProteinProfile)proteinProfileList.get(i);
            int j = 0;
            while (j < proteinProfileList.size()) {
                ProteinProfile profile2 = (ProteinProfile)proteinProfileList.get(j);
                this.setAlignmentValue(i, j, ProteinProfileDistance.calculateOptimalAlignedPosition(profile1, profile2, grouping));
                ++j;
            }
            ++i;
        }
    }

    public AlignmentMatrix copyAlignment() {
        AlignmentMatrix dm = new AlignmentMatrix(this.getMatrixDimension());
        System.arraycopy(this.alignmentPositionMatrix, 0, dm.alignmentPositionMatrix, 0, this.alignmentPositionMatrix.length);
        dm.setLabels(this.getLabels());
        return dm;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        int i = 0;
        while (i < this.getLabels().size()) {
            sb.append("\t" + (String)this.getLabels().get(i));
            ++i;
        }
        sb.append(lineSep);
        i = 0;
        while (i < this.getMatrixDimension()) {
            sb.append(this.getLabels().get(i) + "\t");
            int j = 0;
            while (j < this.getMatrixDimension()) {
                sb.append(String.valueOf(this.getValue(i, j)) + "[" + this.getAlignmentValue(i, j) + "]");
                sb.append("\t");
                ++j;
            }
            sb.append(lineSep);
            ++i;
        }
        return sb.toString();
    }
}

