/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.baderlab.brain.ChargedProteinLogoStyle;
import org.baderlab.brain.HydrophobicBySizeProteinLogoStyle;
import org.baderlab.brain.HydroxylProteinLogoStyle;
import org.baderlab.brain.PDZProteinLogoStyle;
import org.baderlab.brain.WebLogoProteinStyle;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.Symbol;

public class AminoAcidGrouping {
    public static final String GROUPING_NO_GROUPING = "No Grouping";
    public static final String GROUPING_POLAR_CHARGED = "Polar-Hydrophobic";
    public static final String GROUPING_HYDROPHOBIC = "Hydrophobic-Size";
    public static final String GROUPING_HYDROXYL = "Hydroxyl+";
    public static final String GROUPING_PDZ = "PDZ";
    public static final String GROUPING_WEBLOGO = "WebLogo";
    public static final String GROUPING_DEFAULT = "No Grouping";
    public static final String COLORING_POLAR_CHARGED = "Polar-Hydrophobic";
    public static final String COLORING_HYDROPHOBIC = "Hydrophobic-Size";
    public static final String COLORING_HYDROXYL = "Hydroxyl+";
    public static final String COLORING_PDZ = "PDZ";
    public static final String COLORING_WEBLOGO = "WebLogo";
    public static final String COLORING_DEFAULT = "WebLogo";
    public static final String DESCRIPTION_NO_GROUPING = "No amino acid grouping applied";
    public static final String DESCRIPTION_POLAR_CHARGED = "Grouped by polarity and charge; hydrophobic residues are grouped separately";
    public static final String DESCRIPTION_HYDROPHOBIC = "Grouped by hydrophobicity and size";
    public static final String DESCRIPTION_HYDROXYL = "Grouped by common physico-chemical properties";
    public static final String DESCRIPTION_WEBLOGO = "WebLogo default grouping scheme";
    public static final String DESCRIPTION_PDZ = "Grouping based on PDZ 2007 meeting";
    public static final String[] GROUPING_METHODS = new String[]{"No Grouping", "Polar-Hydrophobic", "Hydrophobic-Size", "Hydroxyl+", "PDZ", "WebLogo"};
    public static final String[] COLORING_METHODS = new String[]{"Polar-Hydrophobic", "Hydrophobic-Size", "Hydroxyl+", "PDZ", "WebLogo"};
    private static final int[][] RGB_POLAR_CHARGED;
    private static final int[][] RGB_HYDROPHOBIC;
    private static final int[][] RGB_HYDROXYL;
    private static final int[][] RGB_PDZ;
    private static final int[][] RGB_WEBLOGO;
    private static final String[] GROUPS_POLAR_CHARGED;
    private static final String[] GROUPS_HYDROPHOBIC;
    private static final String[] GROUPS_HYDROXYL;
    private static final String[] GROUPS_PDZ;
    private static final String[] GROUPS_WEBLOGO;
    private static final String[] COLORS_POLAR_CHARGED;
    private static final String[] COLORS_HYDROPHOBIC;
    private static final String[] COLORS_HYDROXYL;
    private static final String[] COLORS_PDZ;
    private static final String[] COLORS_WEBLOGO;
    private static final String[] COLOR_CATEGORIES_POLAR_CHARGED;
    private static final String[] COLOR_CATEGORIES_HYDROPHOBIC;
    private static final String[] COLOR_CATEGORIES_HYDROXYL;
    private static final String[] COLOR_CATEGORIES_PDZ;
    private static final String[] COLOR_CATEGORIES_WEBLOGO;
    private static final String[] GROUP_CATEGORIES_POLAR_CHARGED;
    private static final String[] GROUP_CATEGORIES_HYDROPHOBIC;
    private static final String[] GROUP_CATEGORIES_HYDROXYL;
    private static final String[] GROUP_CATEGORIES_PDZ;
    private static final String[] GROUP_CATEGORIES_WEBLOGO;
    private String selectedGrouping;
    private String selectedColoring;
    private String selectedDescription;
    private String selectedGroups;
    private ArrayList<Color> colorList = new ArrayList();
    private ArrayList<String> colorSymbolList = new ArrayList();
    private ArrayList<String> colorCategoryList = new ArrayList();
    private ArrayList<String> groupList = new ArrayList();
    private ArrayList<String> groupCategoryList = new ArrayList();
    private SymbolStyle proteinLogoStyle;
    private int numberOfGroups = 0;
    private int numberOfColors = 0;

    static {
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{255, 4, 255};
        nArrayArray[1] = new int[]{204, 2, 4};
        nArrayArray[2] = new int[]{4, 2, 204};
        nArrayArray[3] = new int[]{91, 91, 91};
        int[] nArray = new int[3];
        nArray[0] = 102;
        nArray[2] = 102;
        nArrayArray[4] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        nArray2[1] = 170;
        nArrayArray[5] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 102;
        nArray3[1] = 51;
        nArrayArray[6] = nArray3;
        nArrayArray[7] = new int[3];
        RGB_POLAR_CHARGED = nArrayArray;
        RGB_HYDROPHOBIC = new int[][]{{200, 200, 200}, {4, 2, 255}, {4, 2, 204}, {50, 50, 255}, {60, 80, 255}, {150, 150, 150}, {91, 91, 91}, new int[3]};
        RGB_HYDROXYL = new int[][]{{255, 4, 255}, {4, 2, 204}, {204, 2, 4}, {91, 91, 91}, new int[3]};
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[]{4, 206, 4};
        nArrayArray2[1] = new int[]{204, 2, 4};
        nArrayArray2[2] = new int[]{4, 2, 204};
        int[] nArray4 = new int[3];
        nArray4[0] = 102;
        nArray4[2] = 102;
        nArrayArray2[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 255;
        nArray5[1] = 170;
        nArrayArray2[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 102;
        nArray6[1] = 51;
        nArrayArray2[5] = nArray6;
        nArrayArray2[6] = new int[3];
        RGB_PDZ = nArrayArray2;
        RGB_WEBLOGO = new int[][]{{4, 206, 4}, {204, 2, 4}, {4, 2, 204}, new int[3]};
        GROUPS_POLAR_CHARGED = new String[]{"STQN", "KRH", "DE", "C", "P", "G", "LAMIVFWY"};
        GROUPS_HYDROPHOBIC = new String[]{"ST", "KRH", "DEQN", "G", "P", "VAC", "ILM", "FWY"};
        GROUPS_HYDROXYL = new String[]{"ST", "KRH", "DEQN", "G", "FLAMPWIVCY"};
        GROUPS_PDZ = new String[]{"STQN", "DE", "KRH", "G", "C", "P", "AVLIMFYW"};
        GROUPS_WEBLOGO = new String[]{"GSTYCQN", "DE", "KRH", "AVLIPWFM"};
        COLORS_POLAR_CHARGED = GROUPS_POLAR_CHARGED;
        COLORS_HYDROPHOBIC = GROUPS_HYDROPHOBIC;
        COLORS_HYDROXYL = GROUPS_HYDROXYL;
        COLORS_PDZ = GROUPS_PDZ;
        COLORS_WEBLOGO = GROUPS_WEBLOGO;
        COLOR_CATEGORIES_POLAR_CHARGED = new String[]{"Polar Neutral", "Polar Positive", "Polar Negative", "Non-Polar Tiny", "Non-Polar Small", "Non-Polar Small", "Hydrophobic"};
        COLOR_CATEGORIES_HYDROPHOBIC = new String[]{"Hydrophobic-Small", "Hydrophilic-Large", "Hydrophilic-Small", "Hydrophilic-Tiny", "Small", "Hydrophobic-Small (Polar)", "Hydrophobic-Medium (Non-polar)", "Hydrophobic-Large"};
        COLOR_CATEGORIES_HYDROXYL = new String[]{"Hydroxyl-Polar", "Basic", "Polar-Acidic", "Hydrophilic-Nonpolar", "Hydrophobic"};
        COLOR_CATEGORIES_PDZ = new String[]{"Polar", "Acidic", "Basic", "Tiny", "Small", "Small", "Hydrophobic"};
        COLOR_CATEGORIES_WEBLOGO = new String[]{"Polar", "Acidic", "Basic", "Hydrophobic"};
        GROUP_CATEGORIES_POLAR_CHARGED = COLOR_CATEGORIES_POLAR_CHARGED;
        GROUP_CATEGORIES_HYDROPHOBIC = COLOR_CATEGORIES_HYDROPHOBIC;
        GROUP_CATEGORIES_HYDROXYL = COLOR_CATEGORIES_HYDROXYL;
        GROUP_CATEGORIES_PDZ = COLOR_CATEGORIES_PDZ;
        GROUP_CATEGORIES_WEBLOGO = COLOR_CATEGORIES_WEBLOGO;
    }

    public AminoAcidGrouping() {
        this.setGrouping("No Grouping");
        this.setColoring("WebLogo");
    }

    public void setColoring(String colorType) {
        this.selectedColoring = colorType;
        this.colorList.clear();
        this.colorSymbolList.clear();
        this.colorCategoryList.clear();
        if (colorType == "Polar-Hydrophobic") {
            this.proteinLogoStyle = new ChargedProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_POLAR_CHARGED.length;
            this.selectedDescription = DESCRIPTION_POLAR_CHARGED;
            int i = 0;
            while (i < this.numberOfColors) {
                this.colorList.add(new Color(RGB_POLAR_CHARGED[i][0], RGB_POLAR_CHARGED[i][1], RGB_POLAR_CHARGED[i][2]));
                this.colorSymbolList.add(COLORS_POLAR_CHARGED[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_POLAR_CHARGED[i]);
                ++i;
            }
        } else if (colorType == "Hydrophobic-Size") {
            this.proteinLogoStyle = new HydrophobicBySizeProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_HYDROPHOBIC.length;
            this.selectedDescription = DESCRIPTION_HYDROPHOBIC;
            int i = 0;
            while (i < this.numberOfColors) {
                this.colorList.add(new Color(RGB_HYDROPHOBIC[i][0], RGB_HYDROPHOBIC[i][1], RGB_HYDROPHOBIC[i][2]));
                this.colorSymbolList.add(COLORS_HYDROPHOBIC[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_HYDROPHOBIC[i]);
                ++i;
            }
        } else if (colorType == "Hydroxyl+") {
            this.proteinLogoStyle = new HydroxylProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_HYDROXYL.length;
            this.selectedDescription = DESCRIPTION_HYDROXYL;
            int i = 0;
            while (i < this.numberOfColors) {
                this.colorList.add(new Color(RGB_HYDROXYL[i][0], RGB_HYDROXYL[i][1], RGB_HYDROXYL[i][2]));
                this.colorSymbolList.add(COLORS_HYDROXYL[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_HYDROXYL[i]);
                ++i;
            }
        } else if (colorType == "PDZ") {
            this.proteinLogoStyle = new PDZProteinLogoStyle(this.colorList);
            this.numberOfColors = COLORS_PDZ.length;
            this.selectedDescription = DESCRIPTION_PDZ;
            int i = 0;
            while (i < this.numberOfColors) {
                this.colorList.add(new Color(RGB_PDZ[i][0], RGB_PDZ[i][1], RGB_PDZ[i][2]));
                this.colorSymbolList.add(COLORS_PDZ[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_PDZ[i]);
                ++i;
            }
        } else if (colorType == "WebLogo") {
            this.proteinLogoStyle = new WebLogoProteinStyle(this);
            this.numberOfColors = COLORS_WEBLOGO.length;
            this.selectedDescription = DESCRIPTION_WEBLOGO;
            int i = 0;
            while (i < this.numberOfColors) {
                this.colorList.add(new Color(RGB_WEBLOGO[i][0], RGB_WEBLOGO[i][1], RGB_WEBLOGO[i][2]));
                this.colorSymbolList.add(COLORS_WEBLOGO[i]);
                this.colorCategoryList.add(COLOR_CATEGORIES_WEBLOGO[i]);
                ++i;
            }
        } else {
            throw new IllegalStateException("'" + colorType + "' is not a recognized color scheme.");
        }
    }

    public void setGrouping(String groupType) {
        block6: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                this.selectedGrouping = groupType;
                                this.groupList.clear();
                                this.groupCategoryList.clear();
                                if (groupType != "No Grouping") break block5;
                                this.selectedDescription = DESCRIPTION_NO_GROUPING;
                                this.selectedGroups = null;
                                this.numberOfGroups = 0;
                                break block6;
                            }
                            if (groupType != "Polar-Hydrophobic") break block7;
                            this.selectedDescription = DESCRIPTION_POLAR_CHARGED;
                            this.selectedGroups = Arrays.toString(GROUPS_POLAR_CHARGED);
                            this.numberOfGroups = GROUPS_POLAR_CHARGED.length;
                            int i = 0;
                            while (i < this.numberOfGroups) {
                                this.groupList.add(GROUPS_POLAR_CHARGED[i]);
                                this.groupCategoryList.add(GROUP_CATEGORIES_POLAR_CHARGED[i]);
                                ++i;
                            }
                            break block6;
                        }
                        if (groupType != "Hydrophobic-Size") break block8;
                        this.selectedDescription = DESCRIPTION_HYDROPHOBIC;
                        this.selectedGroups = Arrays.toString(GROUPS_HYDROPHOBIC);
                        this.numberOfGroups = GROUPS_HYDROPHOBIC.length;
                        int i = 0;
                        while (i < this.numberOfGroups) {
                            this.groupList.add(GROUPS_HYDROPHOBIC[i]);
                            this.groupCategoryList.add(GROUP_CATEGORIES_HYDROPHOBIC[i]);
                            ++i;
                        }
                        break block6;
                    }
                    if (groupType != "Hydroxyl+") break block9;
                    this.selectedDescription = DESCRIPTION_HYDROXYL;
                    this.selectedGroups = Arrays.toString(GROUPS_HYDROXYL);
                    this.numberOfGroups = GROUPS_HYDROXYL.length;
                    int i = 0;
                    while (i < this.numberOfGroups) {
                        this.groupList.add(GROUPS_HYDROXYL[i]);
                        this.groupCategoryList.add(GROUP_CATEGORIES_HYDROXYL[i]);
                        ++i;
                    }
                    break block6;
                }
                if (groupType != "PDZ") break block10;
                this.selectedDescription = DESCRIPTION_PDZ;
                this.selectedGroups = Arrays.toString(GROUPS_PDZ);
                this.numberOfGroups = GROUPS_PDZ.length;
                int i = 0;
                while (i < this.numberOfGroups) {
                    this.groupList.add(GROUPS_PDZ[i]);
                    this.groupCategoryList.add(GROUP_CATEGORIES_PDZ[i]);
                    ++i;
                }
                break block6;
            }
            if (groupType != "WebLogo") break block6;
            this.selectedDescription = DESCRIPTION_WEBLOGO;
            this.selectedGroups = Arrays.toString(GROUPS_WEBLOGO);
            this.numberOfGroups = GROUPS_WEBLOGO.length;
            int i = 0;
            while (i < this.numberOfGroups) {
                this.groupList.add(GROUPS_WEBLOGO[i]);
                this.groupCategoryList.add(GROUP_CATEGORIES_WEBLOGO[i]);
                ++i;
            }
        }
    }

    public ArrayList getColorList() {
        return this.colorList;
    }

    public ArrayList getColorSymbolList() {
        return this.colorSymbolList;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public ArrayList getColorCategoryList() {
        return this.colorCategoryList;
    }

    public ArrayList getGroupCategoryList() {
        return this.groupCategoryList;
    }

    public SymbolStyle getProteinLogoStyle() {
        return new WebLogoProteinStyle(this);
    }

    public int getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public int getNumberOfColors() {
        return this.numberOfColors;
    }

    public String getSelectedColoring() {
        return this.selectedColoring;
    }

    public String getSelectedGrouping() {
        return this.selectedGrouping;
    }

    public String getSelectedDescription() {
        return this.selectedDescription;
    }

    public String getSelectedGroups() {
        return this.selectedGroups;
    }

    public void addColor(Color color, String symbols, String category) {
        this.colorList.add(color);
        this.colorSymbolList.add(symbols);
        this.colorCategoryList.add(category);
        ++this.numberOfColors;
    }

    public void removeColor(int index) {
        this.colorList.remove(index);
        this.colorSymbolList.remove(index);
        this.colorCategoryList.remove(index);
        --this.numberOfColors;
    }

    public void setColorSymbols(int index, String symbols) {
        if (symbols == null) {
            throw new IllegalArgumentException("Symbol parameter must be non-null.");
        }
        if (index > this.colorSymbolList.size() - 1) {
            throw new IllegalArgumentException("Index parameter is out of range.");
        }
        this.colorSymbolList.set(index, symbols);
    }

    public void setColor(int index, Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color parameter must be non-null.");
        }
        if (index > this.colorList.size() - 1) {
            throw new IllegalArgumentException("Index parameter is out of range.");
        }
        this.colorList.set(index, color);
    }

    public Color getColor(Symbol symbol) {
        String residue = this.getSymbolString(symbol);
        Color color = null;
        int i = 0;
        while (i < this.colorSymbolList.size()) {
            String symbols = this.colorSymbolList.get(i);
            if (symbols == null) {
                System.out.println("This should not happen!!");
            }
            if (residue == null) {
                System.out.println("This should also not happen!!!");
            }
            if (symbols.contains(residue)) {
                color = this.colorList.get(i);
            }
            ++i;
        }
        return color;
    }

    private String getSymbolString(Symbol s) {
        if (s.equals(ProteinTools.a())) {
            return "A";
        }
        if (s.equals(ProteinTools.c())) {
            return "C";
        }
        if (s.equals(ProteinTools.d())) {
            return "D";
        }
        if (s.equals(ProteinTools.e())) {
            return "E";
        }
        if (s.equals(ProteinTools.f())) {
            return "F";
        }
        if (s.equals(ProteinTools.g())) {
            return "G";
        }
        if (s.equals(ProteinTools.h())) {
            return "h";
        }
        if (s.equals(ProteinTools.i())) {
            return "I";
        }
        if (s.equals(ProteinTools.k())) {
            return "K";
        }
        if (s.equals(ProteinTools.l())) {
            return "L";
        }
        if (s.equals(ProteinTools.m())) {
            return "M";
        }
        if (s.equals(ProteinTools.n())) {
            return "N";
        }
        if (s.equals(ProteinTools.p())) {
            return "P";
        }
        if (s.equals(ProteinTools.q())) {
            return "Q";
        }
        if (s.equals(ProteinTools.r())) {
            return "R";
        }
        if (s.equals(ProteinTools.s())) {
            return "S";
        }
        if (s.equals(ProteinTools.t())) {
            return "T";
        }
        if (s.equals(ProteinTools.u())) {
            return "U";
        }
        if (s.equals(ProteinTools.v())) {
            return "V";
        }
        if (s.equals(ProteinTools.w())) {
            return "W";
        }
        if (s.equals(ProteinTools.y())) {
            return "Y";
        }
        if (s.equals(ProteinTools.ter())) {
            return "*";
        }
        return null;
    }

    public static String getHydroxylBasicAcidicpolarHydrophobeGrouping() {
        return Arrays.toString(GROUPS_HYDROXYL);
    }

    public static String getPolarChargedHydrophobeGrouping() {
        return Arrays.toString(GROUPS_POLAR_CHARGED);
    }

    public static String getGroupingHydrophobeBySize() {
        return Arrays.toString(GROUPS_HYDROPHOBIC);
    }

    public static String getWebLogo() {
        return Arrays.toString(GROUPS_WEBLOGO);
    }

    public static String getPDZ() {
        return Arrays.toString(GROUPS_PDZ);
    }

    public static String[] getPositionSpecificPDZGrouping() {
        String[] groupingByPosition = new String[]{"ST, KRH, DEQN, FLAMPWIVCY, G", "ST, KRH, DEQN, MPVCYFWLIA, G", "ST, KRH, DEQN, FLAMPIVCY, G, W", "ST, KRH, DEQN, G, P, VAC, ILM, FWY"};
        return groupingByPosition;
    }
}

