/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class HierarchicalClusteringResultTree {
    public HierarchicalClusteringResultTree left;
    public HierarchicalClusteringResultTree right;
    public int nodeIndex;
    public double distance;
    public double leafOrderIndex;
    public boolean leaf;
    public int numberOfLeaves;
    public String leafLabel;
    public List flatLeftChildrenLeaves;
    public List flatRightChildrenLeaves;
    public HierarchicalClusteringResultTree leftLeaf;
    public HierarchicalClusteringResultTree rightLeaf;

    public HierarchicalClusteringResultTree(int leafIndex, int leafOrderIndex, String label) {
        this.nodeIndex = leafIndex;
        this.distance = 0.0;
        this.leafOrderIndex = leafOrderIndex;
        this.leaf = true;
        this.numberOfLeaves = 1;
        this.leafLabel = label;
    }

    public HierarchicalClusteringResultTree(HierarchicalClusteringResultTree left, HierarchicalClusteringResultTree right, int nodeNum, double distance) {
        if (left == null || right == null) {
            throw new RuntimeException("Null passed to tree constructor");
        }
        this.left = left;
        this.right = right;
        this.nodeIndex = nodeNum;
        this.distance = distance;
        this.leafOrderIndex = (left.leafOrderIndex + right.leafOrderIndex) / 2.0;
        this.leaf = false;
        this.numberOfLeaves += left.numberOfLeaves + right.numberOfLeaves;
        this.flatLeftChildrenLeaves = new ArrayList();
        this.getListOfChildrenLeaves(left, this.flatLeftChildrenLeaves);
        this.flatRightChildrenLeaves = new ArrayList();
        this.getListOfChildrenLeaves(right, this.flatRightChildrenLeaves);
    }

    public HierarchicalClusteringResultTree(HierarchicalClusteringResultTree left, HierarchicalClusteringResultTree right, int nodeNum, double distance, HierarchicalClusteringResultTree leftLeaf, HierarchicalClusteringResultTree rightLeaf) {
        if (left == null || right == null) {
            throw new RuntimeException("Null passed to tree constructor");
        }
        this.left = left;
        this.right = right;
        this.nodeIndex = nodeNum;
        this.distance = distance;
        this.leftLeaf = leftLeaf;
        this.rightLeaf = rightLeaf;
        this.leafOrderIndex = (left.leafOrderIndex + right.leafOrderIndex) / 2.0;
        this.leaf = false;
        this.numberOfLeaves += left.numberOfLeaves + right.numberOfLeaves;
        this.flatLeftChildrenLeaves = new ArrayList();
        this.getListOfChildrenLeaves(left, this.flatLeftChildrenLeaves);
        this.flatRightChildrenLeaves = new ArrayList();
        this.getListOfChildrenLeaves(right, this.flatRightChildrenLeaves);
    }

    private void getListOfChildrenLeaves(HierarchicalClusteringResultTree child, List leafList) {
        if (child.leaf) {
            leafList.add(child);
        } else {
            leafList.addAll(child.flatLeftChildrenLeaves);
            leafList.addAll(child.flatRightChildrenLeaves);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HierarchicalClusteringResultTree)) {
            return false;
        }
        HierarchicalClusteringResultTree that = (HierarchicalClusteringResultTree)obj;
        List objLeftChildren = that.flatLeftChildrenLeaves;
        List objRightChildren = that.flatRightChildrenLeaves;
        if (this.leaf && that.leaf) {
            if (this.leafLabel == null || that.leafLabel == null) {
                throw new RuntimeException("Labels must be defined for the cluster results in order to determine equality.");
            }
            return this.leafLabel.equalsIgnoreCase(that.leafLabel);
        }
        if (!this.leaf && !that.leaf) {
            boolean leftEqual = false;
            boolean rightEqual = false;
            if (this.flatLeftChildrenLeaves.containsAll(objLeftChildren) && objLeftChildren.containsAll(this.flatLeftChildrenLeaves)) {
                leftEqual = true;
            } else if (this.flatLeftChildrenLeaves.containsAll(objRightChildren) && objRightChildren.containsAll(this.flatLeftChildrenLeaves)) {
                leftEqual = true;
            }
            if (this.flatRightChildrenLeaves.containsAll(objLeftChildren) && objLeftChildren.containsAll(this.flatRightChildrenLeaves)) {
                rightEqual = true;
            } else if (this.flatRightChildrenLeaves.containsAll(objRightChildren) && objRightChildren.containsAll(this.flatRightChildrenLeaves)) {
                rightEqual = true;
            }
            if (leftEqual && rightEqual) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        String concatenatedLeafLabelsLeft = this.concatenateLeafLabelsInOrder(this.flatLeftChildrenLeaves);
        String concatenatedLeafLabelsRight = this.concatenateLeafLabelsInOrder(this.flatRightChildrenLeaves);
        int result = concatenatedLeafLabelsLeft != null ? concatenatedLeafLabelsLeft.hashCode() : 0;
        result = 31 * result + (concatenatedLeafLabelsRight != null ? concatenatedLeafLabelsRight.hashCode() : 0);
        return result;
    }

    private String concatenateLeafLabelsInOrder(List childrenLeaves) {
        TreeSet<String> sortedLabels = new TreeSet<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < childrenLeaves.size()) {
            HierarchicalClusteringResultTree node = (HierarchicalClusteringResultTree)childrenLeaves.get(i);
            sortedLabels.add(node.leafLabel);
            ++i;
        }
        for (String leafLabel : sortedLabels) {
            sb.append(leafLabel);
        }
        return sb.toString();
    }
}

