/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardFileFilter
implements FileFilter {
    private Pattern pattern;

    public StandardFileFilter(String template) {
        if (template.indexOf("/") < 0) {
            template = "*/" + template;
        }
        StringBuffer s = new StringBuffer();
        block13: for (int i = 0; i < template.length(); ++i) {
            char ch = template.charAt(i);
            switch (ch) {
                case '?': {
                    s.append(".");
                    continue block13;
                }
                case '*': {
                    s.append(".*");
                    continue block13;
                }
                case '\\': {
                    s.append("\\");
                    s.append(template.charAt(++i));
                    continue block13;
                }
                case '.': {
                    s.append("\\.");
                    continue block13;
                }
                case '^': {
                    s.append("\\^");
                    continue block13;
                }
                case '+': {
                    s.append("\\+");
                    continue block13;
                }
                case '$': {
                    s.append("\\$");
                    continue block13;
                }
                case '{': {
                    s.append("\\{");
                    continue block13;
                }
                case '(': {
                    s.append("\\(");
                    continue block13;
                }
                case '[': {
                    s.append("\\[");
                    continue block13;
                }
                case '|': {
                    s.append("\\|");
                    continue block13;
                }
                default: {
                    s.append(ch);
                }
            }
        }
        this.pattern = Pattern.compile(s.toString());
    }

    public boolean accept(File pathname) {
        String name = pathname.getPath().replaceAll("\\" + File.separator, "/");
        Matcher matcher = this.pattern.matcher(name);
        return matcher.matches();
    }
}

