/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.baderlab.brain.BindingPWM;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.brain.ProteinProfile;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.FiniteAlphabet;

public class PWMToProfileReader {
    public static List readPWMsAsProfiles(File projectFile, File codonBiasFile) {
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        ArrayList<ProteinProfile> profileList = new ArrayList<ProteinProfile>();
        if (projectFile == null) {
            throw new RuntimeException("Project file must be specified.");
        }
        Iterator files = null;
        try {
            if (profileProjectFile.isProjectFile(projectFile.toString())) {
                profileProjectFile.read(projectFile.toString());
                files = profileProjectFile.getFileNames();
            } else {
                ArrayList<String> fileList = new ArrayList<String>(1);
                fileList.add(projectFile.toString());
                files = fileList.iterator();
            }
            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            while (files.hasNext()) {
                String pwmFileName = (String)files.next();
                System.out.println("Loading PWM from " + pwmFileName);
                BindingPWM pwm = new BindingPWM();
                pwm.read(new File(pwmFileName), alpha);
                ProteinProfile profile = new ProteinProfile(pwm.getWeightMatrix(), pwm.getName());
                if (codonBiasFile != null) {
                    profile.reWeightByCodonBias(codonBiasFile);
                }
                profileList.add(profile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return profileList;
    }
}

