/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology;

import cytoscape.data.ontology.GeneOntology;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.ontology.readers.OBOFlatFileReader;
import cytoscape.data.ontology.readers.OBOHeaderTags;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.data.readers.MetadataParser;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class OntologyFactory {
    private MetadataParser mdp;

    public Ontology createBasicOntology(URL dataSource, String name, String description) throws IOException, URISyntaxException {
        OBOFlatFileReader reader = new OBOFlatFileReader(dataSource, name);
        reader.readOntology();
        Ontology onto = new Ontology(name, "General Ontology", description, reader.getDag());
        Map<String, String> header = reader.getHeader();
        if (header != null && header.get(OBOHeaderTags.DATE.toString()) != null) {
            this.mdp = new MetadataParser(reader.getDag());
            this.mdp.setMetadata(MetadataEntries.DATE, header.get(OBOHeaderTags.DATE.toString()).toString());
        }
        return onto;
    }

    public GeneOntology createGeneOntology(URL dataSource, String name, String description) throws IOException, URISyntaxException {
        OBOFlatFileReader reader = new OBOFlatFileReader(dataSource, name);
        reader.readOntology();
        GeneOntology go = new GeneOntology(name, "GO", description, reader.getDag());
        Map<String, String> header = reader.getHeader();
        this.mdp = new MetadataParser(reader.getDag());
        this.mdp.setMetadata(MetadataEntries.DATE, header.get(OBOHeaderTags.DATE.toString()).toString());
        return go;
    }
}

