/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.ding.CyGraphLOD;
import cytoscape.ding.DingNetworkView;
import cytoscape.generated.Child;
import cytoscape.generated.Cysession;
import cytoscape.generated.Edge;
import cytoscape.generated.HiddenEdges;
import cytoscape.generated.HiddenNodes;
import cytoscape.generated.Network;
import cytoscape.generated.NetworkFrame;
import cytoscape.generated.Node;
import cytoscape.generated.SelectedEdges;
import cytoscape.generated.SelectedNodes;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class CytoscapeSessionReader {
    public static final String PACKAGE_NAME = "cytoscape.generated";
    public static final String BOOKMARK_PACKAGE_NAME = "cytoscape.bookmarks";
    public static final String CYSESSION = "cysession.xml";
    public static final String VIZMAP_PROPS = "vizmap.props";
    public static final String CY_PROPS = "cytoscape.props";
    public static final String XGMML_EXT = ".xgmml";
    private static final String BOOKMARKS_FILE = "session_bookmarks.xml";
    private static final String NETWORK_ROOT = "Network Root";
    private URL sourceURL;
    private HashMap networkURLs = null;
    private URL cysessionFileURL = null;
    private URL vizmapFileURL = null;
    private URL cytoscapePropsURL = null;
    private URL bookmarksFileURL = null;
    private HashMap<String, Network> netMap;
    private String sessionID;
    private Cysession session;
    private List networkList;
    private HashMap vsMap;
    private HashMap vsMapByName;
    private Bookmarks bookmarks = null;
    private HashMap<String, List<File>> pluginFileListMap;
    private HashMap<String, List<String>> theURLstrMap = new HashMap();

    public CytoscapeSessionReader(URL sourceName) throws IOException {
        this.sourceURL = sourceName;
        this.networkList = new ArrayList();
        this.vsMap = new HashMap();
        this.vsMapByName = new HashMap();
        this.bookmarks = new Bookmarks();
        this.pluginFileListMap = new HashMap();
    }

    public CytoscapeSessionReader(String fileName) throws IOException {
        this(new File(fileName).toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry() throws IOException {
        URLConnection juc = this.sourceURL.openConnection();
        juc.setDefaultUseCaches(false);
        ZipInputStream zis = new ZipInputStream(juc.getInputStream());
        this.networkURLs = new HashMap();
        ZipEntry zen = null;
        String entryName = null;
        while ((zen = zis.getNextEntry()) != null) {
            entryName = zen.getName();
            if (entryName.contains("/plugins/")) {
                this.extractPluginEntry(entryName);
                continue;
            }
            if (entryName.endsWith(CYSESSION)) {
                this.cysessionFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(VIZMAP_PROPS)) {
                this.vizmapFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(CY_PROPS)) {
                this.cytoscapePropsURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(XGMML_EXT)) {
                URL networkURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                this.networkURLs.put(entryName, networkURL);
                continue;
            }
            if (entryName.endsWith(BOOKMARKS_FILE)) {
                this.bookmarksFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            System.out.println("Unknown entry found in session zip file!\n" + entryName);
        }
        if (zis != null) {
            try {
                zis.close();
            }
            finally {
                zis = null;
            }
        }
    }

    private void extractPluginEntry(String entryName) {
        String[] items = entryName.split("/");
        String pluginName = items[2];
        String URLstr = "jar:" + this.sourceURL.toString() + "!/" + entryName;
        if (this.theURLstrMap.containsKey(pluginName)) {
            List<String> theURLstrList = this.theURLstrMap.get(pluginName);
            theURLstrList.add(URLstr);
        } else {
            ArrayList<String> theURLstrList = new ArrayList<String>();
            theURLstrList.add(URLstr);
            this.theURLstrMap.put(pluginName, theURLstrList);
        }
    }

    public void read() throws IOException, JAXBException {
        long start = System.currentTimeMillis();
        this.unzipSessionFromURL();
        if (this.session.getSessionState().getDesktop() != null) {
            this.restoreDesktopState();
        }
        if (this.session.getSessionState().getServer() != null) {
            this.restoreOntologyServerStatus();
        }
        Cytoscape.firePropertyChange(Cytoscape.SESSION_LOADED, null, this.networkList);
        Cytoscape.firePropertyChange(Cytoscape.ATTRIBUTES_CHANGED, null, null);
        Cytoscape.firePropertyChange("NETWORK_LOADED", null, null);
        Cytoscape.firePropertyChange("RESTORE_PLUGIN_STATE", this.pluginFileListMap, null);
        this.deleteTmpPluginFiles();
        System.out.println("Session loaded in " + (System.currentTimeMillis() - start) + " msec.");
    }

    private void deleteTmpPluginFiles() {
        if (this.pluginFileListMap == null || this.pluginFileListMap.size() == 0) {
            return;
        }
        Set<String> pluginSet = this.pluginFileListMap.keySet();
        for (String plugin : pluginSet) {
            List<File> theFileList = this.pluginFileListMap.get(plugin);
            for (File theFile : theFileList) {
                if (theFile == null) continue;
                theFile.delete();
            }
        }
    }

    private void unzipSessionFromURL() throws IOException, JAXBException {
        this.extractEntry();
        if (this.cysessionFileURL == null || this.vizmapFileURL == null || this.cytoscapePropsURL == null) {
            IOException e = new IOException("Session file is broken or this is not a session file.");
            throw e;
        }
        Cytoscape.firePropertyChange(Cytoscape.VIZMAP_RESTORED, null, this.vizmapFileURL);
        if (this.bookmarksFileURL != null) {
            this.bookmarks = this.getBookmarksFromZip(this.bookmarksFileURL);
            Cytoscape.setBookmarks(this.bookmarks);
        }
        CytoscapeInit.getProperties().load(this.cytoscapePropsURL.openStream());
        this.loadCySession();
        this.restorePlugnStateFilesFromZip();
    }

    private void restorePlugnStateFilesFromZip() {
        if (this.theURLstrMap == null || this.theURLstrMap.size() == 0) {
            return;
        }
        Set<String> pluginSet = this.theURLstrMap.keySet();
        for (String pluginName : pluginSet) {
            List<String> URLstrList = this.theURLstrMap.get(pluginName);
            if (URLstrList == null || URLstrList.size() == 0) continue;
            File theFile = null;
            for (String URLstr : URLstrList) {
                List<Object> fileList;
                int index = URLstr.lastIndexOf("/");
                String fileName = pluginName + "_" + URLstr.substring(index + 1);
                theFile = new File(fileName);
                try {
                    String inputLine;
                    URL theURL = new URL(URLstr);
                    InputStream is = theURL.openStream();
                    BufferedWriter out = null;
                    BufferedReader in = null;
                    in = new BufferedReader(new InputStreamReader(is));
                    out = new BufferedWriter(new FileWriter(theFile));
                    while ((inputLine = in.readLine()) != null) {
                        out.write(inputLine);
                        out.newLine();
                    }
                    in.close();
                    out.close();
                }
                catch (IOException e) {
                    theFile = null;
                    System.out.println("\nError: read from zip: " + URLstr);
                }
                if (theFile == null) continue;
                if (!this.pluginFileListMap.containsKey(pluginName)) {
                    fileList = new ArrayList<File>();
                    fileList.add(theFile);
                    this.pluginFileListMap.put(pluginName, fileList);
                    continue;
                }
                fileList = this.pluginFileListMap.get(pluginName);
                fileList.add(theFile);
            }
        }
    }

    private Bookmarks getBookmarksFromZip(URL pBookmarksFileURL) {
        Bookmarks theBookmark = null;
        try {
            InputStream is = pBookmarksFileURL.openStream();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)BOOKMARK_PACKAGE_NAME, (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            theBookmark = (Bookmarks)unmarshaller.unmarshal(is);
            if (is != null) {
                is.close();
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (JAXBException e3) {
            e3.printStackTrace();
        }
        return theBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCySession() throws JAXBException, IOException {
        InputStream is = this.cysessionFileURL.openStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((String)PACKAGE_NAME, (ClassLoader)this.getClass().getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        this.session = (Cysession)unmarshaller.unmarshal(is);
        if (is != null) {
            try {
                is.close();
            }
            finally {
                is = null;
            }
        }
        this.sessionID = this.session.getId();
        this.netMap = new HashMap();
        for (Network curNet : this.session.getNetworkTree().getNetwork()) {
            this.netMap.put(curNet.getId(), curNet);
        }
        this.walkTree(this.netMap.get(NETWORK_ROOT), null, this.cysessionFileURL);
        String currentNetworkID2 = null;
        for (String currentNetworkID2 : this.vsMap.keySet()) {
            CyNetworkView targetView = Cytoscape.getNetworkView(currentNetworkID2);
            if (targetView == Cytoscape.getNullNetworkView()) continue;
            targetView.setVisualStyle((String)this.vsMap.get(currentNetworkID2));
            targetView.applyVizmapper(targetView.getVisualStyle());
        }
    }

    private void restoreDesktopState() {
        Cytoscape.getDesktop().setSize(this.session.getSessionState().getDesktop().getDesktopSize().getWidth().intValue(), this.session.getSessionState().getDesktop().getDesktopSize().getHeight().intValue());
        Iterator<NetworkFrame> frameIt = this.session.getSessionState().getDesktop().getNetworkFrames().getNetworkFrame().iterator();
        HashMap<String, NetworkFrame> frameMap = new HashMap<String, NetworkFrame>();
        while (frameIt.hasNext()) {
            NetworkFrame netFrame = frameIt.next();
            frameMap.put(netFrame.getFrameID(), netFrame);
        }
        Component[] frames = Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().getComponents();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = (JInternalFrame)frames[i];
            NetworkFrame nFrame = (NetworkFrame)frameMap.get(frame.getTitle());
            if (nFrame == null) continue;
            frame.setSize(nFrame.getWidth().intValue(), nFrame.getHeight().intValue());
            frame.setLocation(nFrame.getX().intValue(), nFrame.getY().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkTree(Network currentNetwork, CyNetwork parent, Object sessionSource) throws JAXBException, IOException {
        List<Child> children = currentNetwork.getChild();
        for (int i = 0; i < children.size(); ++i) {
            Child child = children.get(i);
            Network childNet = this.netMap.get(child.getId());
            String vsName = childNet.getVisualStyle();
            if (vsName == null) {
                vsName = "default";
            }
            this.vsMapByName.put(child.getId(), vsName);
            URL targetNetworkURL = (URL)this.networkURLs.get(this.sessionID + "/" + childNet.getFilename());
            JarURLConnection jarConnection = (JarURLConnection)targetNetworkURL.openConnection();
            InputStream networkStream = (InputStream)jarConnection.getContent();
            CyNetwork new_network = this.createNetwork(parent, networkStream, childNet.isViewAvailable());
            CyNetworkView curNetView = Cytoscape.getNetworkView(new_network.getIdentifier());
            if (networkStream != null) {
                try {
                    networkStream.close();
                }
                finally {
                    networkStream = null;
                }
            }
            this.vsMap.put(new_network.getIdentifier(), vsName);
            this.networkList.add(new_network.getIdentifier());
            if (curNetView != Cytoscape.getNullNetworkView()) {
                this.setHiddenNodes(curNetView, childNet.getHiddenNodes());
                this.setHiddenEdges(curNetView, childNet.getHiddenEdges());
            }
            this.setSelectedNodes(new_network, childNet.getSelectedNodes());
            this.setSelectedEdges(new_network, childNet.getSelectedEdges());
            if (childNet.getChild().size() == 0) continue;
            this.walkTree(childNet, new_network, sessionSource);
        }
    }

    private void setSelectedNodes(CyNetwork network, SelectedNodes selected) {
        if (selected == null) {
            return;
        }
        ArrayList<CyNode> selectedNodeList = new ArrayList<CyNode>();
        for (Node selectedNode : selected.getNode()) {
            selectedNodeList.add(Cytoscape.getCyNode(selectedNode.getId(), false));
        }
        network.setSelectedNodeState(selectedNodeList, true);
    }

    private void setHiddenNodes(CyNetworkView view, HiddenNodes hidden) {
        if (hidden == null) {
            return;
        }
        for (Node hiddenNodeObject : hidden.getNode()) {
            CyNode hiddenNode = Cytoscape.getCyNode(hiddenNodeObject.getId(), false);
            view.hideGraphObject(view.getNodeView(hiddenNode));
        }
    }

    private void setHiddenEdges(CyNetworkView view, HiddenEdges hidden) {
        if (hidden == null) {
            return;
        }
        for (Edge hiddenEdgeObject : hidden.getEdge()) {
            CyEdge hiddenEdge = this.getCyEdge(hiddenEdgeObject);
            if (hiddenEdge == null) continue;
            view.hideGraphObject(view.getEdgeView(hiddenEdge));
        }
    }

    private void setSelectedEdges(CyNetwork network, SelectedEdges selected) {
        if (selected == null) {
            return;
        }
        CyEdge targetEdge = null;
        ArrayList<CyEdge> selectedEdgeList = new ArrayList<CyEdge>();
        for (Edge selectedEdge : selected.getEdge()) {
            targetEdge = this.getCyEdge(selectedEdge);
            if (targetEdge == null) continue;
            selectedEdgeList.add(targetEdge);
        }
        network.setSelectedEdgeState(selectedEdgeList, true);
    }

    private CyEdge getCyEdge(Edge edge) {
        String[] parts;
        CyEdge targetEdge = null;
        String sourceString = edge.getSource();
        String targetString = edge.getTarget();
        CyNode source = null;
        CyNode target = null;
        String interaction = edge.getInteraction();
        if (sourceString != null && targetString != null) {
            source = Cytoscape.getCyNode(sourceString);
            target = Cytoscape.getCyNode(targetString);
        }
        if (source != null & target != null && interaction != null) {
            targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
        }
        if (targetEdge == null && (parts = edge.getId().split(" ")).length == 3) {
            source = Cytoscape.getCyNode(parts[0], false);
            target = Cytoscape.getCyNode(parts[2], false);
            interaction = parts[1].substring(1, parts[1].length() - 1);
            if (source != null && target != null && interaction != null) {
                targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
            }
        }
        return targetEdge;
    }

    private CyNetwork createNetwork(CyNetwork parent, InputStream is, boolean viewAvailable) throws IOException, JAXBException {
        XGMMLReader reader = new XGMMLReader(is);
        reader.read();
        int realThreshold = Integer.valueOf(CytoscapeInit.getProperties().getProperty("viewThreshold"));
        CytoscapeInit.getProperties().setProperty("viewThreshold", Integer.toString(0));
        CyNetwork network = parent == null ? Cytoscape.createNetwork(reader.getNodeIndicesArray(), reader.getEdgeIndicesArray(), reader.getNetworkID()) : Cytoscape.createNetwork(reader.getNodeIndicesArray(), reader.getEdgeIndicesArray(), reader.getNetworkID(), parent);
        reader.setNetworkAttributes(network);
        CytoscapeInit.getProperties().setProperty("viewThreshold", Integer.toString(realThreshold));
        if (viewAvailable) {
            Point2D center;
            this.createCyNetworkView(network);
            final CyNetworkView curView = Cytoscape.getNetworkView(network.getIdentifier());
            if (curView != Cytoscape.getNullNetworkView()) {
                ((DingNetworkView)curView).getCanvas().setVisible(false);
                reader.layout(curView);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((DingNetworkView)curView).setGraphLOD(new CyGraphLOD());
                }
            });
            String curVS = (String)this.vsMapByName.get(network.getTitle());
            if (curVS != null) {
                curView.setVisualStyle(curVS);
                Cytoscape.getDesktop().getVizMapUI().getStyleSelector().resetStyles(curVS);
                Cytoscape.getVisualMappingManager().setVisualStyle(curVS);
                Cytoscape.getDesktop().getVizMapUI().visualStyleChanged();
            } else {
                curView.setVisualStyle(Cytoscape.getVisualMappingManager().getVisualStyle().getName());
            }
            Double zoomLevel = reader.getGraphViewZoomLevel();
            if (zoomLevel != null) {
                curView.setZoom(zoomLevel);
            }
            if ((center = reader.getGraphViewCenter()) != null) {
                ((DGraphView)curView).setCenter(center.getX(), center.getY());
            }
            ((DingNetworkView)curView).getCanvas().setVisible(true);
        }
        reader.doPostProcessing(network);
        reader = null;
        return network;
    }

    private void createCyNetworkView(CyNetwork cyNetwork) {
        DingNetworkView view = new DingNetworkView(cyNetwork, cyNetwork.getTitle());
        view.getCanvas().setVisible(false);
        view.setIdentifier(cyNetwork.getIdentifier());
        Cytoscape.getNetworkViewMap().put(cyNetwork.getIdentifier(), view);
        view.setTitle(cyNetwork.getTitle());
        Cytoscape.setSelectionMode(Cytoscape.getSelectionMode(), view);
        Cytoscape.firePropertyChange("NETWORK_VIEW_CREATED", null, view);
    }

    public String getCysessionNote() {
        return this.session.getSessionNote();
    }

    private void restoreOntologyServerStatus() throws MalformedURLException {
        HashMap<String, URL> newMap = new HashMap<String, URL>();
        List<cytoscape.generated.Ontology> servers = this.session.getSessionState().getServer().getOntologyServer().getOntology();
        String targetCyNetworkID = null;
        String curator = null;
        String description = null;
        for (cytoscape.generated.Ontology server : servers) {
            newMap.put(server.getName(), new URL(server.getHref()));
            targetCyNetworkID = this.getNetworkIdFromTitle(server.getName());
            Ontology onto = new Ontology(server.getName(), curator, description, Cytoscape.getNetwork(targetCyNetworkID));
            Cytoscape.getOntologyServer().addOntology(onto);
        }
        Cytoscape.getOntologyServer().setOntologySources(newMap);
    }

    private String getNetworkIdFromTitle(String title) {
        Set networks = Cytoscape.getNetworkSet();
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals(title)) continue;
            return net.getIdentifier();
        }
        return null;
    }
}

