/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeFontFaceCalculator;
import cytoscape.visual.calculators.GenericEdgeFontSizeCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelCalculator;
import cytoscape.visual.calculators.GenericEdgeLabelColorCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeToolTipCalculator;
import cytoscape.visual.calculators.GenericNodeBorderColorCalculator;
import cytoscape.visual.calculators.GenericNodeFillColorCalculator;
import cytoscape.visual.calculators.GenericNodeFontFaceCalculator;
import cytoscape.visual.calculators.GenericNodeFontSizeCalculator;
import cytoscape.visual.calculators.GenericNodeHeightCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLabelColorCalculator;
import cytoscape.visual.calculators.GenericNodeLabelPositionCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeToolTipCalculator;
import cytoscape.visual.calculators.GenericNodeUniformSizeCalculator;
import cytoscape.visual.calculators.GenericNodeWidthCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CalculatorFactory {
    private static List<Calculator> calcs = new ArrayList<Calculator>();

    public static Calculator newCalculator(String name, Properties calcProps, String baseKey, String intClassName) {
        return CalculatorFactory.newCalculator(name, calcProps, baseKey);
    }

    public static Calculator newCalculator(String name, Properties calcProps, String baseKey) {
        String className = calcProps.getProperty(baseKey + ".class");
        if (className == null) {
            return null;
        }
        String errString = "CalculatorFactory: error processing baseKey " + baseKey;
        Class<?> realClass = null;
        try {
            realClass = Class.forName(className);
        }
        catch (Exception e) {
            System.err.println(errString + " class not found: " + className);
            return null;
        }
        Class<Calculator> calcClass = Calculator.class;
        if (!calcClass.isAssignableFrom(realClass)) {
            System.err.println(errString + " requested class " + className + " does not implement the Calculator interface");
            return null;
        }
        Class[] parameterTypes = new Class[]{String.class, Properties.class, String.class};
        Constructor constructor = CalculatorFactory.getConstructor(realClass, parameterTypes, className);
        if (constructor == null) {
            System.err.println(errString + " requested constructor for " + className + " could not be created");
            return null;
        }
        Object[] params = new Object[]{name, calcProps, baseKey};
        Calculator calculator = CalculatorFactory.getCalculator(constructor, params, className);
        if (calculator == null) {
            System.err.println(errString + " requested calculator for " + className + " could not be created");
        }
        return calculator;
    }

    public static Calculator newDefaultCalculator(byte type, String calcName, ObjectMapping mapper) {
        Calculator calc = null;
        for (Calculator c : calcs) {
            if (c.getType() != type) continue;
            Class<?> realClass = c.getClass();
            Class[] paramTypes = new Class[]{String.class, ObjectMapping.class};
            Constructor constructor = CalculatorFactory.getConstructor(realClass, paramTypes, c.getPropertyLabel());
            if (constructor == null) {
                return null;
            }
            Object[] params = new Object[]{calcName, mapper};
            calc = CalculatorFactory.getCalculator(constructor, params, c.getPropertyLabel());
            return calc;
        }
        return calc;
    }

    public static String getTypeName(byte type) {
        for (Calculator c : calcs) {
            if (c.getType() != type) continue;
            return c.getTypeName();
        }
        return null;
    }

    public static String getPropertyLabel(byte type) {
        for (Calculator c : calcs) {
            if (c.getType() != type) continue;
            return c.getPropertyLabel();
        }
        return null;
    }

    private static Constructor getConstructor(Class realClass, Class[] parameterTypes, String className) {
        Constructor constructor = null;
        try {
            constructor = realClass.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            String s = "no suitable constructor found in class " + className;
            System.err.println(s);
            nsme.printStackTrace();
            return null;
        }
        catch (SecurityException se) {
            String s = "could not access constructors for class " + className;
            System.err.println(s);
            se.printStackTrace();
            return null;
        }
        return constructor;
    }

    private static Calculator getCalculator(Constructor constructor, Object[] params, String className) {
        Calculator calculator = null;
        try {
            calculator = (Calculator)constructor.newInstance(params);
        }
        catch (Exception e) {
            String s = "unable to construct an instance of class " + className;
            System.err.println(s);
            e.printStackTrace();
            return null;
        }
        return calculator;
    }

    static {
        calcs.add(new GenericEdgeColorCalculator());
        calcs.add(new GenericEdgeFontFaceCalculator());
        calcs.add(new GenericEdgeFontSizeCalculator());
        calcs.add(new GenericEdgeLabelCalculator());
        calcs.add(new GenericEdgeLineTypeCalculator());
        calcs.add(new GenericEdgeSourceArrowCalculator());
        calcs.add(new GenericEdgeTargetArrowCalculator());
        calcs.add(new GenericEdgeToolTipCalculator());
        calcs.add(new GenericEdgeLabelColorCalculator());
        calcs.add(new GenericNodeBorderColorCalculator());
        calcs.add(new GenericNodeFillColorCalculator());
        calcs.add(new GenericNodeFontFaceCalculator());
        calcs.add(new GenericNodeFontSizeCalculator());
        calcs.add(new GenericNodeHeightCalculator());
        calcs.add(new GenericNodeLabelCalculator());
        calcs.add(new GenericNodeLabelColorCalculator());
        calcs.add(new GenericNodeLabelPositionCalculator());
        calcs.add(new GenericNodeLineTypeCalculator());
        calcs.add(new GenericNodeShapeCalculator());
        calcs.add(new GenericNodeToolTipCalculator());
        calcs.add(new GenericNodeUniformSizeCalculator());
        calcs.add(new GenericNodeWidthCalculator());
    }
}

