/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.program.tagvalue.LineSplitParser;
import org.biojava.bio.program.tagvalue.ParserListener;
import org.biojava.bio.program.tagvalue.RegexFieldFinder;
import org.biojava.bio.program.tagvalue.RegexSplitter;
import org.biojava.bio.program.tagvalue.SimpleTagValueWrapper;
import org.biojava.bio.program.tagvalue.TagDelegator;
import org.biojava.bio.program.tagvalue.TagValue;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.TagValueParser;
import org.biojava.bio.program.tagvalue.ValueChanger;
import org.biojava.utils.ParserException;

public class Formats {
    public static final AnnotationType EMBL_TYPE;
    public static final AnnotationType EMBL_GENBANK_FEATURE_TABLE_TYPE;
    public static final AnnotationType SWISSPROT_TYPE;

    public static final ParserListener createEmblParserListener(TagValueListener listener) {
        RegexSplitter semiColonSplitter = new RegexSplitter(Pattern.compile("(\\w+)[;.]"), 1);
        ValueChanger semiColonChanger = new ValueChanger(listener);
        semiColonChanger.setDefaultSplitter(semiColonSplitter);
        LineSplitParser lsp = LineSplitParser.EMBL;
        TagDelegator td = new TagDelegator(listener);
        LineSplitParser ftParser = new LineSplitParser();
        ftParser.setSplitOffset(15);
        ftParser.setTrimTag(true);
        ftParser.setTrimValue(true);
        ftParser.setContinueOnEmptyTag(true);
        ftParser.setMergeSameTag(false);
        FeatureTableListener ftListener = new FeatureTableListener(listener);
        td.setParserListener("FT", ftParser, ftListener);
        td.setListener("ID", new RegexFieldFinder(listener, Pattern.compile("(\\w+)\\s+(\\w+);\\s+(.*?);\\s+(\\w+);\\s+(\\d+)\\s+BP\\."), new String[]{"ID", "TYPE", "MOLECULE", "DIVISION", "SIZE"}, true));
        td.setListener("AC", semiColonChanger);
        td.setListener("KW", semiColonChanger);
        td.setListener("OC", semiColonChanger);
        return new ParserListener(lsp, td);
    }

    public static final ParserListener createSwissprotParserListener(TagValueListener listener) {
        RegexSplitter semiColonSplitter = new RegexSplitter(Pattern.compile("(\\w+)[;.]"), 1);
        ValueChanger semiColonChanger = new ValueChanger(listener);
        semiColonChanger.setDefaultSplitter(semiColonSplitter);
        LineSplitParser ftParser = new LineSplitParser();
        ftParser.setSplitOffset(29);
        ftParser.setTrimTag(true);
        ftParser.setTrimValue(true);
        ftParser.setContinueOnEmptyTag(true);
        ftParser.setMergeSameTag(false);
        SPFeatureTableListener ftListener = new SPFeatureTableListener(listener);
        LineSplitParser lsp = LineSplitParser.EMBL;
        TagDelegator td = new TagDelegator(listener);
        td.setListener("ID", new RegexFieldFinder(listener, Pattern.compile("(\\w+)\\s+(\\w+);\\s+(\\w+);\\s+(\\d+)"), new String[]{"ID", "TYPE", "MOLECULE", "LENGTH"}, true));
        td.setListener("AC", semiColonChanger);
        td.setListener("KW", semiColonChanger);
        td.setListener("OC", semiColonChanger);
        td.setListener("RC", semiColonChanger);
        td.setListener("RX", semiColonChanger);
        td.setParserListener("FT", ftParser, ftListener);
        return new ParserListener(lsp, td);
    }

    static {
        PropertyConstraint.ByClass prop_string = new PropertyConstraint.ByClass(String.class);
        CollectionConstraint.AllValuesIn prop_stringList = new CollectionConstraint.AllValuesIn(prop_string, CardinalityConstraint.ANY);
        EMBL_GENBANK_FEATURE_TABLE_TYPE = new AnnotationType.Impl();
        EMBL_GENBANK_FEATURE_TABLE_TYPE.setDefaultConstraint(prop_stringList);
        PropertyConstraint.ByAnnotationType prop_featureTable = new PropertyConstraint.ByAnnotationType(EMBL_GENBANK_FEATURE_TABLE_TYPE);
        EMBL_TYPE = new AnnotationType.Impl();
        EMBL_TYPE.setDefaultConstraint(prop_stringList);
        EMBL_TYPE.setConstraints("FT", prop_featureTable, CardinalityConstraint.ZERO_OR_ONE);
        SWISSPROT_TYPE = new AnnotationType.Impl();
        SWISSPROT_TYPE.setDefaultConstraint(prop_stringList);
    }

    private static class SPFeatureTableListener
    extends SimpleTagValueWrapper {
        private Pattern pat = Pattern.compile("(\\w+)\\s+(\\d+)\\s+(\\d+)");
        private int depth = 0;
        private Object tag;

        public SPFeatureTableListener(TagValueListener delegate) {
            super(delegate);
        }

        public void startRecord() throws ParserException {
            ++this.depth;
            super.startRecord();
        }

        public void endRecord() throws ParserException {
            super.endRecord();
            --this.depth;
        }

        public void startTag(Object tag) throws ParserException {
            if (this.depth == 1) {
                this.tag = tag;
            } else {
                super.startTag(tag);
            }
        }

        public void endTag(Object tag) throws ParserException {
            if (this.depth == 1) {
                // empty if block
            }
            super.endTag();
        }

        public void value(TagValueContext ctxt, Object val) throws ParserException {
            System.out.println(this.depth + " " + this.tag + " " + val);
            if (this.depth == 1) {
                if (this.tag != null) {
                    try {
                        Matcher m = this.pat.matcher(this.tag.toString());
                        m.find();
                        super.startTag("TYPE");
                        super.value(ctxt, m.group(1));
                        super.endTag();
                        super.startTag("START");
                        super.value(ctxt, m.group(2));
                        super.endTag();
                        super.startTag("END");
                        super.value(ctxt, m.group(3));
                        super.endTag();
                        super.startTag("DESCRIPTION");
                        super.value(ctxt, val);
                        this.tag = null;
                    }
                    catch (IllegalStateException ise) {
                        throw new ParserException("Couldn't match: " + this.pat.pattern() + " " + this.tag, ise);
                    }
                } else {
                    super.value(ctxt, val);
                }
            } else {
                super.value(ctxt, val);
            }
        }
    }

    private static class TopRecordDropper
    extends SimpleTagValueWrapper {
        private int depth = 0;

        public TopRecordDropper(TagValueListener delegate) {
            super(delegate);
        }

        public void startRecord() throws ParserException {
            if (this.depth > 0) {
                super.startRecord();
            }
            ++this.depth;
        }

        public void endRecord() throws ParserException {
            --this.depth;
            if (this.depth > 0) {
                super.endRecord();
            }
        }
    }

    private static class FeaturePropertyParser
    implements TagValueParser {
        private FeaturePropertyParser() {
        }

        public TagValue parse(Object value) throws ParserException {
            String line = (String)value;
            if (line.startsWith("/")) {
                int eq = line.indexOf("=");
                if (eq < 0) {
                    return new TagValue(line.substring(1), "", true);
                }
                String ourTag = line.substring(1, eq);
                String ourValue = line.substring(eq + 1);
                return new TagValue(ourTag, ourValue, true);
            }
            return new TagValue(null, value, false);
        }
    }

    private static class FeatureTableListener
    extends SimpleTagValueWrapper {
        private TagValueParser featurePropertyParser = new FeaturePropertyParser();
        private int depth = 0;
        private TagValueListener childListener;
        private boolean inLocation;

        public FeatureTableListener() {
        }

        public FeatureTableListener(TagValueListener delegate) {
            super(delegate);
        }

        public void startRecord() throws ParserException {
            this.inLocation = false;
            super.startRecord();
        }

        public void endRecord() throws ParserException {
            if (this.inLocation) {
                super.endTag();
            }
            super.endRecord();
        }

        public void startTag(Object tag) throws ParserException {
            super.startTag(tag);
            if (this.depth == 0) {
                super.startRecord();
            }
            ++this.depth;
        }

        public void endTag() throws ParserException {
            --this.depth;
            if (this.depth == 0) {
                super.endRecord();
            }
            super.endTag();
        }

        public void value(TagValueContext tvc, Object value) throws ParserException {
            String line = (String)value;
            if (line.startsWith("/")) {
                if (this.inLocation) {
                    super.endTag();
                    this.inLocation = false;
                }
                tvc.pushParser(this.featurePropertyParser, new TopRecordDropper(this.getDelegate()));
            } else {
                if (!this.inLocation) {
                    super.startTag("LOCATION");
                    this.inLocation = true;
                }
                super.value(tvc, value);
            }
        }
    }
}

