/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.Arrays;
import java.util.HashMap;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;

public class ProteinSequenceUtil {
    public static String filterSequenceByColumns(Sequence sequence, String filter) {
        String sequenceString = sequence.seqString();
        return ProteinSequenceUtil.filterSequenceStringByColumns(sequenceString, filter);
    }

    private static String filterSequenceStringByColumns(String sequenceString, String filter) {
        StringBuffer sb = new StringBuffer();
        String[] positions = filter.split(",");
        for (int i = 0; i < positions.length; ++i) {
            String position = positions[i];
            if (position.indexOf("-") > 0) {
                String[] startEnd = position.split("-");
                int start = Integer.parseInt(startEnd[0]);
                int end = Integer.parseInt(startEnd[1]);
                sb.append(sequenceString.substring(start - 1, end));
                continue;
            }
            int point = Integer.parseInt(position);
            sb.append(sequenceString.charAt(point - 1));
        }
        return sb.toString();
    }

    public static int countLengthOfFilteredStringResult(String filter) {
        String[] positions = filter.split("[,-]");
        int lastPosition = Integer.parseInt(positions[positions.length - 1]);
        char[] letters = new char[lastPosition + 1];
        Arrays.fill(letters, 'a');
        String dummyString = new String(letters);
        String newDummyString = ProteinSequenceUtil.filterSequenceStringByColumns(dummyString, filter);
        return newDummyString.length();
    }

    public static HashMap get20aaAlphabet() {
        HashMap<String, Symbol> alphabet = new HashMap<String, Symbol>(20);
        FiniteAlphabet symbols = ProteinTools.getAlphabet();
        for (Symbol symbol : symbols) {
            String symbolString = null;
            try {
                symbolString = symbols.getTokenization("token").tokenizeSymbol(symbol);
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            if (symbolString.equals("U")) continue;
            alphabet.put(symbolString, symbol);
        }
        return alphabet;
    }
}

