/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    public static final byte[] PLAIN = "\\plain".getBytes();
    public static final byte[] IN_TABLE = "\\intbl".getBytes();
    public static final byte[] LINE_SPACING = "\\sl".getBytes();
    protected ArrayList chunks = new ArrayList();
    private int lineLeading = 0;

    protected RtfPhrase(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    public RtfPhrase(RtfDocument rtfDocument, Phrase phrase) {
        super(rtfDocument);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.leadingDefined() ? (int)((double)phrase.leading() * 20.0) : 0;
        RtfFont rtfFont = new RtfFont(null, phrase.font());
        for (int i = 0; i < phrase.size(); ++i) {
            Element element = (Element)phrase.get(i);
            if (element instanceof Chunk) {
                ((Chunk)element).setFont(rtfFont.difference(((Chunk)element).font()));
            }
            try {
                this.chunks.add(rtfDocument.getMapper().mapElement(element));
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            byteArrayOutputStream.write(PLAIN);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            if (this.lineLeading > 0) {
                byteArrayOutputStream.write(LINE_SPACING);
                byteArrayOutputStream.write(this.intToByteArray(this.lineLeading));
            }
            for (int i = 0; i < this.chunks.size(); ++i) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setInTable(boolean bl) {
        super.setInTable(bl);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(bl);
        }
    }

    public void setInHeader(boolean bl) {
        super.setInHeader(bl);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(bl);
        }
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
        }
    }
}

