/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.CyFileFilter;
import java.util.Set;
import junit.framework.TestCase;

public class CyFileFilterTest
extends TestCase {
    String EXT1 = "goo";
    String EXT2 = "sif";
    String EXT3 = "doc";
    String DESC1 = "If google had a file type";
    String DESC2 = "Interactions file type";
    String DESC3 = "Microsoft Word file Type";
    String DESC4 = "All file types";
    String DUMMY_NATURE = "Human Designed";
    String[] FILTERS = new String[]{this.EXT1, this.EXT2};
    CyFileFilter cff1;
    CyFileFilter cff2;
    CyFileFilter cff3;
    CyFileFilter cff4;
    CyFileFilter cff5;
    CyFileFilter cff6;
    CyFileFilter cff7;

    public void setUp() throws Exception {
        this.cff1 = new CyFileFilter();
        this.cff2 = new CyFileFilter(this.EXT1);
        this.cff3 = new CyFileFilter(this.EXT1, this.DESC1);
        this.cff4 = new CyFileFilter(this.FILTERS);
        this.cff5 = new CyFileFilter(this.FILTERS, this.DESC4);
        this.cff6 = new CyFileFilter(this.EXT1, this.DESC1, this.DUMMY_NATURE);
        this.cff7 = new CyFileFilter(this.FILTERS, this.DESC4, this.DUMMY_NATURE);
    }

    public void tearDown() throws Exception {
        Object cff1 = null;
        Object cff2 = null;
        Object cff3 = null;
        Object cff4 = null;
        Object cff5 = null;
        Object cff6 = null;
        Object cff7 = null;
    }

    public void testGetExtension() throws Exception {
        String test = this.cff1.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff2.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff3.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff4.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff5.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff6.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        test = this.cff7.getExtension("Google.goo");
        CyFileFilterTest.assertEquals((String)this.EXT1, (String)test);
        boolean exists = this.cff1.isExtensionListInDescription();
        CyFileFilterTest.assertTrue((boolean)exists);
        this.cff1.setExtensionListInDescription(false);
        exists = this.cff1.isExtensionListInDescription();
        CyFileFilterTest.assertFalse((boolean)exists);
    }

    public void testConstructors() {
        boolean exists = this.cff1.accept("hi." + this.EXT2);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff1.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        String description = this.cff1.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)"(*.*)");
        String nature = this.cff1.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        exists = this.cff2.accept("hi." + this.EXT2);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff2.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        description = this.cff2.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)"(*.goo)");
        nature = this.cff2.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        exists = this.cff3.accept("hi." + this.EXT2);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff3.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        this.cff3.setExtensionListInDescription(false);
        description = this.cff3.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)this.DESC1);
        nature = this.cff3.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        exists = this.cff4.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff4.accept("hi." + this.EXT2);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff4.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        Set extensions = this.cff4.getExtensionSet();
        int size = extensions.size();
        CyFileFilterTest.assertEquals((int)2, (int)size);
        description = this.cff4.getDescription();
        CyFileFilterTest.assertEquals((String)"(*.goo, *.sif)", (String)description);
        nature = this.cff4.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        exists = this.cff5.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff5.accept("hi." + this.EXT2);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff5.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        extensions = this.cff5.getExtensionSet();
        size = extensions.size();
        CyFileFilterTest.assertEquals((int)2, (int)size);
        this.cff5.setExtensionListInDescription(false);
        description = this.cff5.getDescription();
        this.cff5.setExtensionListInDescription(false);
        CyFileFilterTest.assertEquals((String)description, (String)this.DESC4);
        nature = this.cff5.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        exists = this.cff6.accept("hi." + this.EXT2);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff6.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        this.cff6.setExtensionListInDescription(false);
        description = this.cff6.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)this.DESC1);
        nature = this.cff6.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)this.DUMMY_NATURE);
        exists = this.cff7.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        exists = this.cff7.accept("hi." + this.EXT2);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff7.accept("hi." + this.EXT1);
        CyFileFilterTest.assertTrue((boolean)exists);
        extensions = this.cff7.getExtensionSet();
        size = extensions.size();
        CyFileFilterTest.assertEquals((int)2, (int)size);
        this.cff7.setExtensionListInDescription(false);
        description = this.cff7.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)this.DESC4);
        nature = this.cff7.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)this.DUMMY_NATURE);
    }

    public void testAddExtension() {
        this.cff1.addExtension(this.EXT3);
        boolean exists = this.cff1.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff2.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff2.addExtension(this.EXT3);
        exists = this.cff2.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff3.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff3.addExtension(this.EXT3);
        exists = this.cff3.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff4.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff4.addExtension(this.EXT3);
        exists = this.cff4.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff5.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff5.addExtension(this.EXT3);
        exists = this.cff5.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff6.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff6.addExtension(this.EXT3);
        exists = this.cff6.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
        exists = this.cff7.accept("hi." + this.EXT3);
        CyFileFilterTest.assertFalse((boolean)exists);
        this.cff7.addExtension(this.EXT3);
        exists = this.cff7.accept("hi." + this.EXT3);
        CyFileFilterTest.assertTrue((boolean)exists);
    }

    public void testSets() {
        String description = this.cff1.getDescription();
        CyFileFilterTest.assertEquals((String)description, (String)"(*.*)");
        String nature = this.cff1.getFileNature();
        CyFileFilterTest.assertEquals((String)nature, (String)"UNKNOWN");
        this.cff1.setDescription(this.DESC1);
        this.cff1.setExtensionListInDescription(false);
        this.cff1.setFileNature(this.DUMMY_NATURE);
        description = this.cff1.getDescription();
        CyFileFilterTest.assertEquals((String)this.DESC1, (String)description);
        nature = this.cff1.getFileNature();
        CyFileFilterTest.assertEquals((String)this.DUMMY_NATURE, (String)nature);
    }
}

