/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;

public class SwissprotFileFormer
extends AbstractGenEmblFileFormer
implements SeqFileFormer {
    private StringBuffer sq = new StringBuffer();
    private StringBuffer qb = new StringBuffer();
    private StringBuffer ub = new StringBuffer();
    private StringBuffer idb = null;
    private StringBuffer acb = null;
    private StringBuffer dtb = null;
    private StringBuffer deb = null;
    private StringBuffer svb = null;
    private StringBuffer kwb = null;
    private StringBuffer osb = null;
    private StringBuffer ocb = null;
    private StringBuffer ccb = null;
    private StringBuffer ftb = new StringBuffer();
    private SymbolTokenization proteinTokenization;
    static int LOCATION_WIDTH = 6;
    PrintStream mStream;

    protected SwissprotFileFormer() {
        try {
            this.proteinTokenization = ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (Exception ex) {
            throw new BioError("Couldn't initialize tokenizer for the DNA alphabet", ex);
        }
        this.mStream = System.out;
    }

    protected SwissprotFileFormer(PrintStream theStream) {
        try {
            this.proteinTokenization = ProteinTools.getTAlphabet().getTokenization("token");
        }
        catch (Exception ex) {
            throw new BioError("Couldn't initialize tokenizer for the DNA alphabet", ex);
        }
        this.mStream = theStream;
    }

    public void startSequence() throws ParseException {
    }

    public void endSequence() throws ParseException {
    }

    public void setName(String theName) throws ParseException {
        this.idb = new StringBuffer("ID   " + theName);
    }

    public void setURI(String theURI) throws ParseException {
    }

    public void addSymbols(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        PrintStream stream = this.getPrintStream();
        if (this.idb != null) {
            stream.println(this.idb);
            stream.println("XX");
        }
        if (this.acb != null) {
            stream.println(this.acb);
            stream.println("XX");
        }
        if (this.svb != null) {
            stream.println(this.svb);
            stream.println("XX");
        }
        if (this.dtb != null) {
            stream.println(this.dtb);
            stream.println("XX");
        }
        if (this.deb != null) {
            stream.println(this.deb);
            stream.println("XX");
        }
        if (this.kwb != null) {
            stream.println(this.kwb);
            stream.println("XX");
        }
        if (this.osb != null) {
            stream.println(this.osb);
        }
        if (this.ocb != null) {
            stream.println(this.ocb);
            stream.println("XX");
        }
        if (this.ccb != null) {
            stream.println(this.ccb);
            stream.println("XX");
        }
        if (this.ftb.length() != 0) {
            stream.print(this.ftb);
        }
        this.printOutSequenceHeaderLine(theAlphabet, theSymbols, theStart, theLength);
        List brokenLines = this.breakSymbolArray(theAlphabet, theSymbols, theStart, theLength);
        Iterator iterator = brokenLines.iterator();
        String leader = "     ";
        while (iterator.hasNext()) {
            stream.print(leader + iterator.next() + this.nl);
        }
        stream.println("//");
    }

    private String sequenceBufferCreator(Object key, Object value) {
        StringBuffer temp = new StringBuffer();
        if (value == null) {
            temp.append((String)key);
        } else if (value instanceof ArrayList) {
            Iterator iter = ((ArrayList)value).iterator();
            while (iter.hasNext()) {
                temp.append((String)key + "   " + iter.next());
                if (!iter.hasNext()) continue;
                temp.append(this.nl);
            }
        } else {
            StringTokenizer valueToke = new StringTokenizer((String)value, " ");
            int fullline = 80;
            int length = 0;
            String token = valueToke.nextToken();
            while (true) {
                temp.append((String)key + "  ");
                length = temp.length() % (fullline + 1) + token.length() + 1;
                if (temp.length() % (fullline + 1) == 0) {
                    length = 81 + token.length();
                }
                while (length <= fullline && valueToke.hasMoreTokens()) {
                    temp.append(" " + token);
                    token = valueToke.nextToken();
                    length = temp.length() % (fullline + 1) + token.length() + 1;
                    if (temp.length() % (fullline + 1) != 0) continue;
                    length = 81 + token.length();
                }
                if (!valueToke.hasMoreTokens()) break;
                for (int i = length - token.length(); i < fullline; ++i) {
                    temp.append(" ");
                }
                temp.append(this.nl);
            }
            if (length <= fullline) {
                temp.append(" " + token);
            } else {
                temp.append(this.nl);
                temp.append((String)key + "   " + token);
            }
        }
        return temp.toString();
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if (key.equals("ID")) {
            this.idb.setLength(0);
            this.idb.append("ID   " + (String)value);
        } else if (key.equals("DT") || key.equals("MDAT")) {
            this.dtb = new StringBuffer(this.sequenceBufferCreator("DT", value));
        } else if (key.equals("DE") || key.equals("DEFINITION")) {
            this.deb = new StringBuffer(this.sequenceBufferCreator("DE", value));
        } else if (key.equals("SV") || key.equals("VERSION")) {
            this.svb = new StringBuffer(this.sequenceBufferCreator("SV", value));
        } else if (key.equals("KW") || key.equals("KEYWORDS")) {
            this.kwb = new StringBuffer(this.sequenceBufferCreator("KW", value));
        } else if (key.equals("OS") || key.equals("SOURCE")) {
            this.osb = new StringBuffer(this.sequenceBufferCreator("OS", value));
        } else if (key.equals("OC") || key.equals("ORGANISM")) {
            this.ocb = new StringBuffer(this.sequenceBufferCreator("OC", value));
        } else if (key.equals("CC") || key.equals("COMMENT")) {
            this.ccb = new StringBuffer(this.sequenceBufferCreator("CC", value));
        } else if (key.equals("swissprot.accessions")) {
            this.acb = new StringBuffer();
            this.acb.append("AC   ");
            Iterator ai = ((List)value).iterator();
            while (ai.hasNext()) {
                this.acb.append((String)ai.next());
                this.acb.append(";");
            }
        }
    }

    public void startFeature(Feature.Template templ) throws ParseException {
        String leader = "FT                   ";
        int strand = 0;
        if (templ instanceof StrandedFeature.Template) {
            strand = ((StrandedFeature.Template)templ).strand.getValue();
        }
        this.ub.setLength(0);
        this.ub.append(leader);
        StringBuffer lb = this.formatLocation(this.ub, templ.location);
        lb.replace(5, 5 + templ.type.length(), templ.type);
        this.ftb.append(lb + this.nl);
    }

    public void endFeature() throws ParseException {
    }

    public void addFeatureProperty(Object key, Object value) throws ParseException {
        String leader = "FT                   ";
        if (key.equals("internal_data")) {
            return;
        }
        if (Collection.class.isInstance(value)) {
            Iterator vi = ((Collection)value).iterator();
            while (vi.hasNext()) {
                this.qb.setLength(0);
                this.ub.setLength(0);
                StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, vi.next()).toString(), leader, 80);
                this.ftb.append(fb + this.nl);
            }
        } else {
            this.qb.setLength(0);
            this.ub.setLength(0);
            StringBuffer fb = this.formatQualifierBlock(this.qb, this.formatQualifier(this.ub, key, value).toString(), leader, 80);
            this.ftb.append(fb + this.nl);
        }
    }

    public PrintStream getPrintStream() {
        return this.mStream;
    }

    public void setPrintStream(PrintStream theStream) {
        this.mStream = theStream;
    }

    public StringBuffer formatLocation(StringBuffer theBuffer, Location theLocation, StrandedFeature.Strand theStrand) {
        return this.formatLocation(theBuffer, theLocation);
    }

    public String formatLocation(Feature theFeature) {
        StringBuffer toReturn = this.formatLocation(new StringBuffer(), theFeature.getLocation());
        return toReturn.toString();
    }

    public StringBuffer formatLocation(StringBuffer theBuffer, Location theLocation) {
        StringBuffer startPoint = new StringBuffer(LOCATION_WIDTH);
        StringBuffer endPoint = new StringBuffer(LOCATION_WIDTH);
        if (theLocation instanceof PointLocation || theLocation instanceof RangeLocation) {
            startPoint = this.formatPoint(theLocation.getMin(), theLocation.getMin(), false);
            endPoint = this.formatPoint(theLocation.getMax(), theLocation.getMax(), false);
        } else if (theLocation instanceof FuzzyLocation) {
            FuzzyLocation tempLocation = (FuzzyLocation)theLocation;
            startPoint = this.formatPoint(tempLocation.getOuterMin(), tempLocation.getInnerMin(), tempLocation.isMinFuzzy());
            endPoint = this.formatPoint(tempLocation.getInnerMax(), tempLocation.getOuterMax(), tempLocation.isMaxFuzzy());
        }
        return new StringBuffer(startPoint.toString() + " " + endPoint.toString());
    }

    protected void printOutSequenceHeaderLine(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        this.getPrintStream().println("SQ   SEQUENCE   " + theLength + " AA;   ");
    }

    protected List breakSymbolArray(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        SymbolTokenization tokenization;
        ArrayList<String> returnList = new ArrayList<String>(theLength / 60 + 1);
        int blockCount = 0;
        int blockIndex = 0;
        StringBuffer tempString = new StringBuffer();
        try {
            tokenization = theAlphabet.getTokenization("token");
        }
        catch (Exception ex) {
            throw new IllegalAlphabetException(ex, "Couldn't get tokenization for this alphabet");
        }
        for (int i = theStart; i < theStart + theLength; ++i) {
            try {
                theAlphabet.validate(theSymbols[i]);
            }
            catch (IllegalSymbolException e) {
                throw new IllegalAlphabetException(e);
            }
            if (blockIndex == 10) {
                tempString.append(' ');
                blockIndex = 0;
                ++blockCount;
            }
            if (blockCount == 6) {
                returnList.add(tempString.substring(0));
                tempString.setLength(0);
                blockCount = 0;
                blockIndex = 0;
            }
            try {
                tempString.append(tokenization.tokenizeSymbol(theSymbols[i]));
            }
            catch (IllegalSymbolException ex) {
                throw new IllegalAlphabetException(ex, "Couldn't tokenize symbols");
            }
            ++blockIndex;
        }
        if (tempString.length() != 0) {
            returnList.add(tempString.substring(0));
        }
        return returnList;
    }

    protected void fillBuffer(StringBuffer theBuffer, int theLength) {
        for (int i = 0; i < theLength; ++i) {
            theBuffer.append(' ');
        }
    }

    protected StringBuffer formatPoint(int theMinIndex, int theMaxIndex, boolean isFuzzy) {
        StringBuffer bufferToReturn = new StringBuffer(LOCATION_WIDTH);
        if (!isFuzzy) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length();
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append(tempString);
        } else if (theMinIndex == Integer.MIN_VALUE && theMaxIndex == Integer.MAX_VALUE) {
            int offset = LOCATION_WIDTH - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('?');
        } else if (theMinIndex == Integer.MIN_VALUE) {
            String tempString = Integer.toString(theMaxIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('<');
            bufferToReturn.append(tempString);
        } else if (theMaxIndex == Integer.MAX_VALUE) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('>');
            bufferToReturn.append(tempString);
        } else if (theMinIndex == theMaxIndex) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('?');
            bufferToReturn.append(tempString);
        } else {
            System.out.println("Error in formatPoint");
            System.out.println("\tInner: " + theMinIndex);
            System.out.println("\tOuter: " + theMaxIndex);
            System.out.println("\tFuzzy: " + isFuzzy);
        }
        return bufferToReturn;
    }
}

