/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class BrowserCommandLexer {
    private static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    private static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0002\u0002\u0001\u0000\u0002\u0002\u0012\u0000\u0001\u0002\u0001\u0000\u0001\u0003\u001e\u0000\u0001\u0000\u001a\u0000\u0001\u0001\uffa3\u0000";
    private static final char[] ZZ_CMAP = BrowserCommandLexer.zzUnpackCMap("\t\u0000\u0002\u0002\u0001\u0000\u0002\u0002\u0012\u0000\u0001\u0002\u0001\u0000\u0001\u0003\u001e\u0000\u0001\u0000\u001a\u0000\u0001\u0001\uffa3\u0000");
    private static final int[] ZZ_ACTION = BrowserCommandLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0001\u0002\u0002\u0001\u0001\u0003\u0000\u0001\u0003\u0001\u0001\u0001\u0003\u0001\u0000\u0002\u0003";
    private static final int[] ZZ_ROWMAP = BrowserCommandLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0004\u0000\b\u0000\f\u0000\u0010\u0000\b\u0000\u0014\u0000\u0018\u0000\u0004\u0000\u001c\u0000\u0010\u0000 \u0000\f\u0000\u0018";
    private static final int[] ZZ_TRANS = BrowserCommandLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0002\u0001\u0006\u0001\u0000\u0005\u0002\u0004\u0000\u0001\u0005\u0001\u0007\u0001\b\u0001\t\u0001\u0005\u0001\n\u0001\u0005\u0001\u000b\u0001\b\u0001\f\u0001\b\u0001\r\u0001\u0005\u0001\u0007\u0001\b\u0001\u000b\u0001\b\u0001\f\u0001\b\u0001\u000e";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = BrowserCommandLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0001\u0001\t\u0001\u0001\u0003\u0000\u0003\u0001\u0001\u0000\u0001\t\u0001\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;

    private static int[] zzUnpackAction() {
        int[] result = new int[14];
        int offset = 0;
        offset = BrowserCommandLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[14];
        int offset = 0;
        offset = BrowserCommandLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[36];
        int offset = 0;
        offset = BrowserCommandLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[14];
        int offset = 0;
        offset = BrowserCommandLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            BrowserCommandLexer shredder = new BrowserCommandLexer(in);
            while ((t = shredder.getNextToken()) != null) {
                System.out.println(t);
            }
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public String getNextToken() throws IOException {
        return this.getToken();
    }

    private static String unescape(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\' && i < s.length()) {
                ++i;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    BrowserCommandLexer(Reader in) {
        this.zzReader = in;
    }

    BrowserCommandLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 26) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    private final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    private final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    private final int yystate() {
        return this.zzLexicalState;
    }

    private final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    private final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    private final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    private final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    private void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private String getToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block7: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 3: {
                    return BrowserCommandLexer.unescape(this.yytext().substring(1, this.yytext().length() - 1));
                }
                case 4: {
                    continue block7;
                }
                case 2: 
                case 5: {
                    continue block7;
                }
                case 1: {
                    return BrowserCommandLexer.unescape(this.yytext());
                }
                case 6: {
                    continue block7;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

