/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.Ontology;
import java.io.Serializable;
import java.util.Vector;

public class OntologyTerm
implements Serializable {
    String name;
    int id;
    Vector parents;
    Vector containers;

    public OntologyTerm(String name, int id) {
        this.name = name;
        this.id = id;
        this.parents = new Vector();
        this.containers = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public void addParent(int newParent) {
        this.parents.addElement(new Integer(newParent));
    }

    public void addContainer(int newContainer) {
        this.containers.addElement(new Integer(newContainer));
    }

    public int numberOfParentsAndContainers() {
        return this.numberOfParents() + this.numberOfContainers();
    }

    public int numberOfParents() {
        return this.parents.size();
    }

    public int numberOfContainers() {
        return this.containers.size();
    }

    public int[] getParents() {
        int size = this.numberOfParents();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)this.parents.elementAt(i);
            result[i] = tmp;
        }
        return result;
    }

    public int[] getContainers() {
        int size = this.numberOfContainers();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)this.containers.elementAt(i);
            result[i] = tmp;
        }
        return result;
    }

    public int[] getParentsAndContainers() {
        int i;
        int size = this.numberOfParents() + this.numberOfContainers();
        int[] result = new int[size];
        int[] parents = this.getParents();
        int[] containers = this.getContainers();
        for (i = 0; i < parents.length; ++i) {
            result[i] = parents[i];
        }
        for (i = 0; i < containers.length; ++i) {
            result[i + parents.length] = containers[i];
        }
        return result;
    }

    public boolean isParentOf(OntologyTerm other) {
        int[] otherParents = other.getParents();
        for (int i = 0; i < otherParents.length; ++i) {
            if (this.id != otherParents[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Ontology ontology, OntologyTerm other) {
        if (this.isParentOrContainerOf(other)) {
            return true;
        }
        int[] myParents = this.getParentsAndContainers();
        for (int i = 0; i < myParents.length; ++i) {
            OntologyTerm parentTerm = ontology.getTerm(myParents[i]);
            if (parentTerm == null || !parentTerm.isAncestorOf(ontology, other)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(OntologyTerm other) {
        int otherId = other.getId();
        int[] myParents = this.getParents();
        for (int i = 0; i < myParents.length; ++i) {
            if (myParents[i] != otherId) continue;
            return true;
        }
        return false;
    }

    public boolean isContainerOf(OntologyTerm other) {
        int[] otherContainers = other.getContainers();
        for (int i = 0; i < otherContainers.length; ++i) {
            if (this.id != otherContainers[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedIn(OntologyTerm other) {
        int[] myContainers = this.getContainers();
        int otherID = other.getId();
        for (int i = 0; i < myContainers.length; ++i) {
            if (myContainers[i] != otherID) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOfOrContainedIn(OntologyTerm other) {
        int otherID = other.getId();
        int[] myParentsAndContainers = this.getParentsAndContainers();
        for (int i = 0; i < myParentsAndContainers.length; ++i) {
            if (otherID != myParentsAndContainers[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isParentOrContainerOf(OntologyTerm other) {
        int[] otherParentsAndContainers = other.getParentsAndContainers();
        for (int i = 0; i < otherParentsAndContainers.length; ++i) {
            if (this.id != otherParentsAndContainers[i]) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ");
        sb.append(this.name);
        sb.append("\n");
        sb.append("id: ");
        sb.append(this.id);
        sb.append("\n");
        int[] parents = this.getParents();
        sb.append("parents: ");
        for (int i = 0; i < parents.length; ++i) {
            sb.append(parents[i]);
            sb.append(" ");
        }
        sb.append("\n");
        int[] containers = this.getContainers();
        sb.append("containers: ");
        for (int i = 0; i < containers.length; ++i) {
            sb.append(containers[i]);
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }
}

