/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import java.util.ArrayList;
import java.util.Map;

public class ContinuousRangeCalculator {
    private ArrayList points;
    private Interpolator interpolator;
    private Map attrBundle;

    public ContinuousRangeCalculator(ArrayList points, Interpolator interpolator, Map attrBundle) {
        this.points = points;
        this.interpolator = interpolator;
        this.attrBundle = attrBundle;
    }

    public Object calculateRangeValue(String attrName) {
        if (this.attrBundle == null || attrName == null) {
            return null;
        }
        if (this.points.size() == 0) {
            return null;
        }
        Object attrValue = this.attrBundle.get(attrName);
        if (!(attrValue instanceof Number)) {
            return null;
        }
        Object object = this.getRangeValue((Number)attrValue);
        return object;
    }

    private Object getRangeValue(Number domainValue) {
        ContinuousMappingPoint firstPoint = (ContinuousMappingPoint)this.points.get(0);
        Double minDomain = new Double(firstPoint.getValue());
        int firstCmp = this.compareValues(domainValue, minDomain);
        if (firstCmp <= 0) {
            BoundaryRangeValues bv = firstPoint.getRange();
            if (firstCmp < 0) {
                return bv.lesserValue;
            }
            return bv.equalValue;
        }
        ContinuousMappingPoint lastPoint = (ContinuousMappingPoint)this.points.get(this.points.size() - 1);
        Double maxDomain = new Double(lastPoint.getValue());
        if (this.compareValues(domainValue, maxDomain) > 0) {
            BoundaryRangeValues bv = lastPoint.getRange();
            return bv.greaterValue;
        }
        if (this.interpolator == null) {
            return null;
        }
        int index = 0;
        for (index = 0; index < this.points.size(); ++index) {
            ContinuousMappingPoint currentPoint = (ContinuousMappingPoint)this.points.get(index);
            Double currentValue = new Double(currentPoint.getValue());
            int cmpValue = this.compareValues(domainValue, currentValue);
            if (cmpValue == 0) {
                BoundaryRangeValues bv = currentPoint.getRange();
                return bv.equalValue;
            }
            if (cmpValue < 0) break;
        }
        Object object = this.getRangeValue(index, domainValue);
        return object;
    }

    private Object getRangeValue(int index, Number domainValue) {
        ContinuousMappingPoint lowerBound = (ContinuousMappingPoint)this.points.get(index - 1);
        Double lowerDomain = new Double(lowerBound.getValue());
        BoundaryRangeValues lv = lowerBound.getRange();
        Object lowerRange = lv.greaterValue;
        ContinuousMappingPoint upperBound = (ContinuousMappingPoint)this.points.get(index);
        Double upperDomain = new Double(upperBound.getValue());
        BoundaryRangeValues gv = upperBound.getRange();
        Object upperRange = gv.lesserValue;
        return this.interpolator.getRangeValue(lowerDomain, lowerRange, upperDomain, upperRange, domainValue);
    }

    private int compareValues(Number probe, Number target) {
        double d2;
        double d1 = probe.doubleValue();
        if (d1 < (d2 = target.doubleValue())) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

