/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;

public class VizUIUtilities {
    static Object getDefault(VisualStyle style, byte type) {
        if (style == null) {
            return null;
        }
        Object defaultObj = null;
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        NodeAppearance na = nodeCalc.getDefaultAppearance();
        EdgeAppearance ea = edgeCalc.getDefaultAppearance();
        defaultObj = na.get(type);
        if (defaultObj == null) {
            defaultObj = ea.get(type);
        }
        return defaultObj;
    }

    static void setDefault(VisualStyle style, byte type, Object c) {
        if (style == null || c == null) {
            return;
        }
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        NodeAppearance na = nodeCalc.getDefaultAppearance();
        EdgeAppearance ea = edgeCalc.getDefaultAppearance();
        na.set(type, c);
        ea.set(type, c);
        nodeCalc.setDefaultAppearance(na);
        edgeCalc.setDefaultAppearance(ea);
    }

    static Calculator getCurrentCalculator(VisualStyle style, byte type) {
        if (style == null) {
            return null;
        }
        Calculator currentCalculator = null;
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        currentCalculator = nodeCalc.getCalculator(type);
        if (currentCalculator == null) {
            currentCalculator = edgeCalc.getCalculator(type);
        }
        return currentCalculator;
    }

    static void setCurrentCalculator(VisualStyle style, byte type, Calculator c) {
        if (style == null) {
            return;
        }
        NodeAppearanceCalculator nodeCalc = style.getNodeAppearanceCalculator();
        EdgeAppearanceCalculator edgeCalc = style.getEdgeAppearanceCalculator();
        if (c == null) {
            nodeCalc.removeCalculator(type);
            edgeCalc.removeCalculator(type);
        } else {
            nodeCalc.setCalculator(c);
            edgeCalc.setCalculator(c);
        }
    }
}

