package org.baderlab.lola.model;

import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.ProteinProfile;

import javax.swing.*;
import java.util.List;
import java.util.ArrayList;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: May 28, 2007
 * Time: 6:53:53 PM
 * To change this template use File | Settings | File Templates.
 */
public class ProfileSet extends DefaultListModel {

    private LogoTree logoTree;      //the logo tree, if one was generated, for the profile set

    public ProfileSet() {
        super();
        logoTree = null;
    }

//    @Override
//    public Object get(int index) {
//        ProteinProfile profile = (ProteinProfile) this.getElementAt(index);
//        return profile.getName();
//    }
//
//    public Object getElementAt(int index) {
//        ProteinProfile profile = (ProteinProfile) this.
//        return profile.getName();
//
//    }

    public ProfileSet copy() {
        ProfileSet profileSetCopy = null;
        try {
            profileSetCopy = (ProfileSet) this.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        return profileSetCopy;
    }

    /**
     * Sets the LogoTree of this profile set. tree must be a LogoTree generated with ALL the profiles
     * contained in this ProfileSet.
     * @param tree a LogoTree object
     */
    public void setLogoTree(LogoTree tree) {
        this.logoTree = tree;
    }

    /**
     * Return the LogoTree for this profile set. The logo tree was generated with all the profiles
     * contained in this ProfileSet.
     * @return a LogoTree object
     */
    public LogoTree getLogoTree() {
        return this.logoTree;
    }


    public void setFuzzFactor() {
        for (int i = 0; i < this.getSize(); i++) {
            
        }
    }

    //returns a List of ProteinProfile objects contained in the ProfileSet
    public List getProteinProfileList() {
        List profileList = new ArrayList();
        for (int i = 0; i < getSize(); i++) {
            Profile profile = (Profile) this.get(i);
            profileList.add(profile.getProteinProfile());
        }
        return profileList;
    }


}
