package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.view.GenerateLogoTreeTask;
import org.baderlab.brain.ProfileSearchProjectFile;

import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Aug 1, 2007
 * Time: 5:07:39 PM
 * To change this template use File | Settings | File Templates.
 */
public class MakeLogoTreeAction implements ActionListener {
    private ProfileSet profileSet;
    private LolaParameterSet paramSet;

    public MakeLogoTreeAction(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) throws OutOfMemoryError {
        boolean isProjectFile = false;

        //determine if we're dealing with a project file or a single protein profile
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        try {
            if (profileProjectFile.isProjectFile(paramSet.getProfileFile().toString())) {
                isProjectFile = true;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        //logo tree only applies to a project file
        if (isProjectFile) {

            //configure task
            GenerateLogoTreeTask task = new GenerateLogoTreeTask(profileSet, paramSet);
            JTaskConfig taskConfig = new JTaskConfig();
            taskConfig.displayCancelButton(true);
            taskConfig.displayStatus(true);

            //Execute Task via TaskManager
            TaskManager.executeTask(task, taskConfig);
        }

    }
}
