/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.ProfileSet;

public class GenerateLogoTreeTask
implements Task {
    private TaskMonitor taskMonitor = null;
    private BrainAlgorithm alg = null;
    private ProfileSet profileSet;
    private LolaParameterSet paramSet;

    public GenerateLogoTreeTask(ProfileSet profileSet, LolaParameterSet paramSet) {
        this.profileSet = profileSet;
        this.paramSet = paramSet;
        this.alg = new BrainAlgorithm();
    }

    public void run() throws OutOfMemoryError {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        this.alg.setTaskMonitor(this.taskMonitor);
        this.taskMonitor.setStatus("Reading profiles");
        String outputPath = this.paramSet.getOutputPath() + File.separator + this.paramSet.getTreeFilename();
        File codonBiasFile = this.paramSet.getCodonBiasFile();
        String positionFilter = this.paramSet.getPositionFilter();
        LogoTreeDraw ltd = null;
        ltd = positionFilter != null && !positionFilter.equals("") ? this.alg.runAlignedProfileClusterByFilter(this.paramSet.getProfileFile().toString(), this.profileSet.getProteinProfileList(), positionFilter, this.paramSet.getTreeTitle(), new File(outputPath), null, codonBiasFile, this.paramSet.getTreeLeafTrimFactor(), this.paramSet.getTreeInternalNodeTrimFactor(), this.paramSet.getTreeLeafOrderingMethod(), this.paramSet.getAminoAcidGrouping(), false) : this.alg.runAlignedProfileCluster(this.paramSet.getProfileFile().toString(), this.profileSet.getProteinProfileList(), this.paramSet.getTreeTitle(), new File(outputPath), this.paramSet.getTreeLeafTrimFactor(), this.paramSet.getTreeInternalNodeTrimFactor(), this.paramSet.getTreeLeafOrderingMethod(), this.paramSet.getAminoAcidGrouping(), false);
        LogoTree tree = new LogoTree();
        tree.setIsSaved(false);
        tree.setLogoTreeDraw(ltd);
        tree.setImage(ltd.outputToGraphics());
        tree.setGTRFormat(ltd.outputToGTRFormat());
        this.profileSet.setLogoTree(tree);
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Generating Logo Tree");
    }
}

