/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.sequencelogo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class SequenceLogoDistributionTrainerContext
implements DistributionTrainerContext,
Serializable {
    private static final long serialVersionUID = 4343678513955786696L;
    private final Map distToTrainer = new IdentityHashMap();
    private final Set trainers = new HashSet();
    private double nullModelWeight;

    public double getNullModelWeight() {
        return this.nullModelWeight;
    }

    public void setNullModelWeight(double nullModelWeight) {
        this.nullModelWeight = nullModelWeight;
    }

    public void registerDistribution(Distribution dist) {
        if (!this.distToTrainer.keySet().contains(dist)) {
            dist.registerWithTrainer((DistributionTrainerContext)this);
        }
    }

    public void registerTrainer(Distribution dist, DistributionTrainer trainer) {
        this.distToTrainer.put(dist, trainer);
        this.trainers.add(trainer);
    }

    public DistributionTrainer getTrainer(Distribution dist) {
        return (DistributionTrainer)this.distToTrainer.get(dist);
    }

    public void addCount(Distribution dist, Symbol sym, double times) throws IllegalSymbolException {
        DistributionTrainer dt = this.getTrainer(dist);
        if (dt == null) {
            throw new NullPointerException("No trainer associated with distribution " + dist);
        }
        if (sym instanceof AtomicSymbol) {
            dt.addCount((DistributionTrainerContext)this, (AtomicSymbol)sym, times);
        } else {
            Distribution nullModel = dist.getNullModel();
            double totWeight = nullModel.getWeight(sym);
            for (AtomicSymbol as : (FiniteAlphabet)sym.getMatches()) {
                dt.addCount((DistributionTrainerContext)this, as, times / 20.0);
            }
        }
    }

    public double getCount(Distribution dist, Symbol sym) throws IllegalSymbolException {
        DistributionTrainer dt = this.getTrainer(dist);
        if (dt == null) {
            throw new NullPointerException("No trainer associated with distribution " + dist);
        }
        if (sym instanceof AtomicSymbol) {
            return dt.getCount((DistributionTrainerContext)this, (AtomicSymbol)sym);
        }
        double totWeight = 0.0;
        for (AtomicSymbol as : (FiniteAlphabet)sym.getMatches()) {
            totWeight += dt.getCount((DistributionTrainerContext)this, as);
        }
        return totWeight;
    }

    public void train() throws ChangeVetoException {
        Iterator i = this.trainers.iterator();
        while (i.hasNext()) {
            ((DistributionTrainer)i.next()).train((DistributionTrainerContext)this, this.getNullModelWeight());
        }
    }

    public void clearCounts() {
        Iterator i = this.trainers.iterator();
        while (i.hasNext()) {
            ((DistributionTrainer)i.next()).clearCounts((DistributionTrainerContext)this);
        }
    }
}

